"use strict";

const zlib = require('zlib');
const utils = require('../utils');
const {
  isGzipOrDeflateEncoding,
  isBrotliEncoding
} = utils;
exports.chooseDecompresser = res => {
  let decompresser;
  if (isGzipOrDeflateEncoding(res)) {
    decompresser = zlib.createUnzip();
  } else if (isBrotliEncoding(res)) {
    decompresser = zlib.createBrotliDecompress();
  } else {
    throw new Error('unknown content-encoding');
  }
  return decompresser;
};
//# sourceMappingURL=data:application/json;charset=utf-8;base64,eyJ2ZXJzaW9uIjozLCJuYW1lcyI6WyJ6bGliIiwicmVxdWlyZSIsInV0aWxzIiwiaXNHemlwT3JEZWZsYXRlRW5jb2RpbmciLCJpc0Jyb3RsaUVuY29kaW5nIiwiZXhwb3J0cyIsImNob29zZURlY29tcHJlc3NlciIsInJlcyIsImRlY29tcHJlc3NlciIsImNyZWF0ZVVuemlwIiwiY3JlYXRlQnJvdGxpRGVjb21wcmVzcyIsIkVycm9yIl0sInNvdXJjZXMiOlsiLi4vLi4vc3JjL25vZGUvZGVjb21wcmVzcy5qcyJdLCJzb3VyY2VzQ29udGVudCI6WyJjb25zdCB6bGliID0gcmVxdWlyZSgnemxpYicpO1xuY29uc3QgdXRpbHMgPSByZXF1aXJlKCcuLi91dGlscycpO1xuY29uc3QgeyBpc0d6aXBPckRlZmxhdGVFbmNvZGluZywgaXNCcm90bGlFbmNvZGluZyB9ID0gdXRpbHM7XG5cbmV4cG9ydHMuY2hvb3NlRGVjb21wcmVzc2VyID0gKHJlcykgPT4ge1xuICBsZXQgZGVjb21wcmVzc2VyO1xuICBpZiAoaXNHemlwT3JEZWZsYXRlRW5jb2RpbmcocmVzKSkge1xuICAgIGRlY29tcHJlc3NlciA9IHpsaWIuY3JlYXRlVW56aXAoKTtcbiAgfSBlbHNlIGlmIChpc0Jyb3RsaUVuY29kaW5nKHJlcykpIHtcbiAgICBkZWNvbXByZXNzZXIgPSB6bGliLmNyZWF0ZUJyb3RsaURlY29tcHJlc3MoKTtcbiAgfSBlbHNlIHtcbiAgICB0aHJvdyBuZXcgRXJyb3IoJ3Vua25vd24gY29udGVudC1lbmNvZGluZycpO1xuICB9XG4gIHJldHVybiBkZWNvbXByZXNzZXI7XG59XG4iXSwibWFwcGluZ3MiOiI7O0FBQUEsTUFBTUEsSUFBSSxHQUFHQyxPQUFPLENBQUMsTUFBTSxDQUFDO0FBQzVCLE1BQU1DLEtBQUssR0FBR0QsT0FBTyxDQUFDLFVBQVUsQ0FBQztBQUNqQyxNQUFNO0VBQUVFLHVCQUF1QjtFQUFFQztBQUFpQixDQUFDLEdBQUdGLEtBQUs7QUFFM0RHLE9BQU8sQ0FBQ0Msa0JBQWtCLEdBQUlDLEdBQUcsSUFBSztFQUNwQyxJQUFJQyxZQUFZO0VBQ2hCLElBQUlMLHVCQUF1QixDQUFDSSxHQUFHLENBQUMsRUFBRTtJQUNoQ0MsWUFBWSxHQUFHUixJQUFJLENBQUNTLFdBQVcsQ0FBQyxDQUFDO0VBQ25DLENBQUMsTUFBTSxJQUFJTCxnQkFBZ0IsQ0FBQ0csR0FBRyxDQUFDLEVBQUU7SUFDaENDLFlBQVksR0FBR1IsSUFBSSxDQUFDVSxzQkFBc0IsQ0FBQyxDQUFDO0VBQzlDLENBQUMsTUFBTTtJQUNMLE1BQU0sSUFBSUMsS0FBSyxDQUFDLDBCQUEwQixDQUFDO0VBQzdDO0VBQ0EsT0FBT0gsWUFBWTtBQUNyQixDQUFDIiwiaWdub3JlTGlzdCI6W119