import type { Formatter } from "./common.js";
export type { ConfigurationDiagnostic, FileMatchingInfo, FormatRequest, Formatter, GlobalConfiguration, Host, PluginInfo, } from "./common.js";
export interface ResponseLike {
    status: number;
    arrayBuffer(): Promise<BufferSource>;
    text(): Promise<string>;
    headers: {
        get(name: string): string | null;
    };
}
/**
 * Creates a formatter from the specified streaming source.
 * @remarks This is the most efficient way to create a formatter.
 * @param response - The streaming source to create the formatter from.
 */
export declare function createStreaming(responsePromise: Promise<ResponseLike> | ResponseLike): Promise<Formatter>;
/**
 * Creates a formatter from the specified wasm module bytes.
 * @param wasmModuleBuffer - The buffer of the wasm module.
 */
export declare function createFromBuffer(wasmModuleBuffer: BufferSource): Formatter;
export declare function createFromWasmModule(wasmModule: WebAssembly.Module): Formatter;
//# sourceMappingURL=mod.d.ts.map