"use strict";
var __spreadArray = (this && this.__spreadArray) || function (to, from, pack) {
    if (pack || arguments.length === 2) for (var i = 0, l = from.length, ar; i < l; i++) {
        if (ar || !(i in from)) {
            if (!ar) ar = Array.prototype.slice.call(from, 0, i);
            ar[i] = from[i];
        }
    }
    return to.concat(ar || Array.prototype.slice.call(from));
};
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
var chalk_1 = __importDefault(require("chalk"));
var plur_1 = __importDefault(require("plur"));
var path_1 = require("path");
var SEPARATOR = '\n';
var WARNING = 'Warning';
var ERROR = 'Error';
var isError = function (severity) { return severity === 2; };
var pad = function (str, minLen, maxLen) {
    return maxLen <= minLen ? str : "".concat(str).concat(' '.repeat(maxLen - minLen));
};
var buildPath = function (filePath, line, column) {
    var path = !filePath.includes('/') && !filePath.includes('\\')
        ? ".".concat(path_1.sep).concat(filePath)
        : filePath;
    return [path, line ? ":".concat(line) : '', column ? ":".concat(column) : ''].join('');
};
var getErrorType = function (severity, isRaw) {
    if (isRaw === void 0) { isRaw = true; }
    return isRaw
        ? "".concat(isError(severity) ? ERROR : WARNING, ": ")
        : "".concat(isError(severity) ? chalk_1.default.red(ERROR) : chalk_1.default.blue(WARNING), ": ");
};
var buildMessage = function (_a, maxPathLen, maxRuleLen) {
    var errorType = _a.errorType, message = _a.message, rule = _a.rule, path = _a.path;
    return "".concat(errorType).concat(pad(path.filePath, path.len, maxPathLen), " ").concat(pad(rule.name, rule.len, maxRuleLen), " ").concat(message);
};
var buildOutput = function (result) {
    var initialData = {
        maxRuleLen: 0,
        maxPathLen: 0,
        messages: [],
    };
    var _a = result.messages.reduce(function (_a, _b) {
        var maxRuleLen = _a.maxRuleLen, maxPathLen = _a.maxPathLen, messages = _a.messages;
        var severity = _b.severity, message = _b.message, ruleId = _b.ruleId, column = _b.column, line = _b.line;
        var errorType = getErrorType(severity);
        var path = buildPath(result.filePath, line, column);
        var ruleName = ruleId ? ruleId : '';
        var ruleLen = ruleName.length;
        var pathLen = errorType.length + path.length;
        return {
            maxRuleLen: Math.max(maxRuleLen, ruleLen),
            maxPathLen: Math.max(maxPathLen, pathLen),
            messages: __spreadArray(__spreadArray([], messages, true), [
                {
                    errorType: getErrorType(severity, false),
                    message: chalk_1.default.yellow(message),
                    rule: { name: chalk_1.default.grey(ruleName), len: ruleLen },
                    path: { filePath: path, len: pathLen },
                },
            ], false),
        };
    }, initialData), maxRuleLen = _a.maxRuleLen, maxPathLen = _a.maxPathLen, messages = _a.messages;
    return __spreadArray([
        chalk_1.default.white(result.filePath)
    ], messages.map(function (message) { return buildMessage(message, maxPathLen, maxRuleLen); }), true).join(SEPARATOR);
};
module.exports = function (results) {
    var resultsLen = results.length;
    var output = [];
    var meta = [];
    var warningCount = 0;
    var errorCount = 0;
    for (var i = 0; i < resultsLen; i++) {
        var result = results[i];
        if (result.warningCount || result.errorCount) {
            warningCount = warningCount + result.warningCount;
            errorCount = errorCount + result.errorCount;
            output.push(buildOutput(result));
        }
    }
    if (warningCount || errorCount) {
        meta.push(SEPARATOR);
    }
    if (warningCount) {
        meta.push(chalk_1.default.blue("".concat(warningCount, " ").concat((0, plur_1.default)('warning', warningCount))));
    }
    if (errorCount) {
        meta.push(chalk_1.default.red("".concat(errorCount, " ").concat((0, plur_1.default)('error', errorCount))));
    }
    return "".concat(output.join(SEPARATOR)).concat(meta.join(SEPARATOR));
};
