import { hasDependency } from '../../util/plugin.js';
import { getInputsFromHandlers } from './resolveFromAST.js';
const title = 'SST';
const enablers = ['sst'];
const isEnabled = ({ dependencies }) => hasDependency(dependencies, enablers);
const config = ['sst.config.ts'];
const resolveFromAST = (sourceFile, options) => {
    const inputs = getInputsFromHandlers(sourceFile, options);
    return inputs;
};
export default {
    title,
    enablers,
    isEnabled,
    config,
    resolveFromAST,
};
