import commandLineUsage from "command-line-usage";
import pc from "picocolors";
import { compareTaskNames } from "./utils.js";
export function formatTasks(format, tasks, defaultTask) {
    const visibleTasks = [...tasks].filter(isTaskVisible).sort(compareTaskNames);
    if (format === "simple") {
        return visibleTasks.map((task) => task.options.name).join("\n");
    }
    return commandLineUsage({
        header: "Available tasks",
        content: visibleTasks.map((task) => {
            var _a;
            const name = task === defaultTask
                ? `${pc.green(task.options.name)} (default)`
                : pc.blue(task.options.name);
            let descriptionParts = task.options.description ? [task.options.description] : undefined;
            const deps = (_a = task.options.dependencies) === null || _a === void 0 ? void 0 : _a.filter(isTaskVisible).sort(compareTaskNames);
            if (deps === null || deps === void 0 ? void 0 : deps.length) {
                const depNames = deps.map((task) => pc.blue(task.options.name));
                (descriptionParts !== null && descriptionParts !== void 0 ? descriptionParts : (descriptionParts = [])).push(`Depends on: ${depNames.join(", ")}`);
            }
            return { name, description: descriptionParts === null || descriptionParts === void 0 ? void 0 : descriptionParts.join("\n") };
        }),
    });
}
function isTaskVisible(task) {
    return !task.options.hiddenFromTaskList;
}
//# sourceMappingURL=formatTasks.js.map