/**
 * A hereby Task. To get an instance, call `test`.
 */
export class Task {
    /* @internal */
    static create(options) {
        return new Task(options);
    }
    // Note: private such that "private constructor();" is emitted in the d.ts files,
    // which prevents extending or direct instantiation.
    constructor(options) {
        // Runtime typecheck; consumers of hereby may not have enabled
        // typechecking, so this is helpful.
        var _a, _b;
        /* eslint-disable @typescript-eslint/no-unnecessary-condition */
        if (typeof options.name !== "string") {
            throw new TypeError("Task name is not a string.");
        }
        if (typeof options.description !== "string" && options.description !== undefined) {
            throw new TypeError("Task description is not a string or undefined.");
        }
        if (!Array.isArray(options.dependencies) && options.dependencies !== undefined) {
            throw new TypeError("Task dependencies is not an array or undefined.");
        }
        for (const dep of (_a = options.dependencies) !== null && _a !== void 0 ? _a : []) {
            if (!(dep instanceof Task)) {
                throw new TypeError("Task dependency is not a task.");
            }
        }
        if (typeof options.run !== "function" && options.run !== undefined) {
            throw new TypeError("Task run is not a function or undefined.");
        }
        /* eslint-enable @typescript-eslint/no-unnecessary-condition */
        // Non-type checks.
        if (!options.name) {
            throw new Error("Task name must not be empty.");
        }
        if (options.name.startsWith("-")) {
            throw new Error('Task name must not start with "-".');
        }
        if (!((_b = options.dependencies) === null || _b === void 0 ? void 0 : _b.length) && !options.run) {
            throw new Error("Task must have a run function or dependencies.");
        }
        this.options = options;
    }
}
/**
 * Creates a new Task.
 */
export function task(options) {
    return Task.create(options);
}
//# sourceMappingURL=index.js.map