import { toEntry, toProductionEntry } from '../../util/input.js';
const title = 'Node.js';
const isEnabled = () => true;
const config = ['package.json'];
const packageJsonPath = (id) => id;
const resolveConfig = localConfig => {
    const scripts = localConfig.scripts;
    const entries = [toProductionEntry('server.js')];
    if (scripts && Object.values(scripts).some(script => /(?<=^|\s)node\s(.*)--test/.test(script))) {
        const patterns = [
            '**/*{.,-,_}test.{cjs,mjs,js,cts,mts,ts}',
            '**/test-*.{cjs,mjs,js,cts,mts,ts}',
            '**/test.{cjs,mjs,js,cts,mts,ts}',
            '**/test/**/*.{cjs,mjs,js,cts,mts,ts}',
        ];
        entries.push(...patterns.map(id => toEntry(id)));
    }
    return entries;
};
const args = {
    positional: true,
    nodeImportArgs: true,
    resolve: ['test-reporter'],
    boolean: [
        'deprecation',
        'experimental-strip-types',
        'experimental-transform-types',
        'harmony',
        'inspect-brk',
        'inspect-wait',
        'inspect',
        'test-only',
        'test',
        'warnings',
        'watch',
    ],
    args: (args) => args.filter(arg => !/--test-reporter[= ](spec|tap|dot|junit|lcov)/.test(arg)),
};
export default {
    title,
    isEnabled,
    packageJsonPath,
    config,
    resolveConfig,
    args,
};
