import { z } from 'zod';
export const globSchema = z.union([z.string(), z.array(z.string())]);
export const pluginSchema = z.union([
    z.boolean(),
    globSchema,
    z.object({
        config: globSchema.optional(),
        entry: globSchema.optional(),
        project: globSchema.optional(),
    }),
]);
export const pluginsSchema = z.object({
    angular: pluginSchema,
    astro: pluginSchema,
    ava: pluginSchema,
    babel: pluginSchema,
    biome: pluginSchema,
    bun: pluginSchema,
    c8: pluginSchema,
    capacitor: pluginSchema,
    changelogen: pluginSchema,
    changelogithub: pluginSchema,
    changesets: pluginSchema,
    commitizen: pluginSchema,
    commitlint: pluginSchema,
    convex: pluginSchema,
    'create-typescript-app': pluginSchema,
    cspell: pluginSchema,
    cucumber: pluginSchema,
    cypress: pluginSchema,
    'dependency-cruiser': pluginSchema,
    docusaurus: pluginSchema,
    dotenv: pluginSchema,
    drizzle: pluginSchema,
    eleventy: pluginSchema,
    eslint: pluginSchema,
    expo: pluginSchema,
    gatsby: pluginSchema,
    'github-action': pluginSchema,
    'github-actions': pluginSchema,
    glob: pluginSchema,
    'graphql-codegen': pluginSchema,
    hardhat: pluginSchema,
    husky: pluginSchema,
    'i18next-parser': pluginSchema,
    jest: pluginSchema,
    karma: pluginSchema,
    ladle: pluginSchema,
    lefthook: pluginSchema,
    'lint-staged': pluginSchema,
    linthtml: pluginSchema,
    'lockfile-lint': pluginSchema,
    'lost-pixel': pluginSchema,
    markdownlint: pluginSchema,
    metro: pluginSchema,
    mocha: pluginSchema,
    moonrepo: pluginSchema,
    msw: pluginSchema,
    'nano-staged': pluginSchema,
    nest: pluginSchema,
    netlify: pluginSchema,
    next: pluginSchema,
    node: pluginSchema,
    nodemon: pluginSchema,
    'npm-package-json-lint': pluginSchema,
    nuxt: pluginSchema,
    nx: pluginSchema,
    nyc: pluginSchema,
    oclif: pluginSchema,
    oxlint: pluginSchema,
    playwright: pluginSchema,
    'playwright-ct': pluginSchema,
    'playwright-test': pluginSchema,
    plop: pluginSchema,
    postcss: pluginSchema,
    preconstruct: pluginSchema,
    prettier: pluginSchema,
    prisma: pluginSchema,
    'react-cosmos': pluginSchema,
    'react-router': pluginSchema,
    relay: pluginSchema,
    'release-it': pluginSchema,
    remark: pluginSchema,
    remix: pluginSchema,
    rollup: pluginSchema,
    rsbuild: pluginSchema,
    rspack: pluginSchema,
    'semantic-release': pluginSchema,
    sentry: pluginSchema,
    'simple-git-hooks': pluginSchema,
    'size-limit': pluginSchema,
    sst: pluginSchema,
    starlight: pluginSchema,
    storybook: pluginSchema,
    stryker: pluginSchema,
    stylelint: pluginSchema,
    svelte: pluginSchema,
    svgo: pluginSchema,
    syncpack: pluginSchema,
    tailwind: pluginSchema,
    travis: pluginSchema,
    'ts-node': pluginSchema,
    tsdown: pluginSchema,
    tsup: pluginSchema,
    tsx: pluginSchema,
    typedoc: pluginSchema,
    typescript: pluginSchema,
    unbuild: pluginSchema,
    unocss: pluginSchema,
    'vercel-og': pluginSchema,
    vike: pluginSchema,
    vite: pluginSchema,
    vitest: pluginSchema,
    vue: pluginSchema,
    'webdriver-io': pluginSchema,
    webpack: pluginSchema,
    wireit: pluginSchema,
    wrangler: pluginSchema,
    xo: pluginSchema,
    yarn: pluginSchema,
    yorkie: pluginSchema,
});
