import path from 'node:path';
import parsedArgValues from './cli-arguments.js';
const { directory } = parsedArgValues;
export const isAbsolute = path.isAbsolute;
export const dirname = path.posix.dirname;
export const extname = path.posix.extname;
export const basename = path.posix.basename;
export const join = path.posix.join;
export const toPosix = (value) => value.split(path.sep).join(path.posix.sep);
export const cwd = directory ? path.posix.resolve(directory) : toPosix(process.cwd());
export const resolve = (...paths) => paths.length === 1 ? path.posix.join(cwd, paths[0]) : path.posix.resolve(...paths);
export const relative = (from, to) => toPosix(path.relative(to ? from : cwd, to ?? from));
export const isInNodeModules = (filePath) => filePath.includes('node_modules');
export const toAbsolute = (id, base = cwd) => (isAbsolute(id) ? id : join(base, id));
export const toRelative = (id) => (isAbsolute(id) ? relative(id) : id);
export const isInternal = (id) => (id.startsWith('.') || isAbsolute(id)) && !isInNodeModules(id);
