"use strict";
var __createBinding = (this && this.__createBinding) || (Object.create ? (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    var desc = Object.getOwnPropertyDescriptor(m, k);
    if (!desc || ("get" in desc ? !m.__esModule : desc.writable || desc.configurable)) {
      desc = { enumerable: true, get: function() { return m[k]; } };
    }
    Object.defineProperty(o, k2, desc);
}) : (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    o[k2] = m[k];
}));
var __setModuleDefault = (this && this.__setModuleDefault) || (Object.create ? (function(o, v) {
    Object.defineProperty(o, "default", { enumerable: true, value: v });
}) : function(o, v) {
    o["default"] = v;
});
var __importStar = (this && this.__importStar) || function (mod) {
    if (mod && mod.__esModule) return mod;
    var result = {};
    if (mod != null) for (var k in mod) if (k !== "default" && Object.prototype.hasOwnProperty.call(mod, k)) __createBinding(result, mod, k);
    __setModuleDefault(result, mod);
    return result;
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.createFromWasmModule = exports.createFromBuffer = exports.createStreaming = void 0;
const v3 = __importStar(require("./v3.js"));
const v4 = __importStar(require("./v4.js"));
/**
 * Creates a formatter from the specified streaming source.
 * @remarks This is the most efficient way to create a formatter.
 * @param response - The streaming source to create the formatter from.
 */
async function createStreaming(responsePromise) {
    const response = await responsePromise;
    if (response.status !== 200) {
        throw new Error(`Unexpected status code: ${response.status}\n${await response.text()}`);
    }
    if (typeof WebAssembly.instantiateStreaming === "function"
        && response.headers.get("content-type") === "application/wasm") {
        // deno-lint-ignore no-explicit-any
        const module = await WebAssembly.compileStreaming(response);
        return createFromWasmModule(module);
    }
    else {
        // fallback for node.js or when the content type isn't application/wasm
        return response.arrayBuffer()
            .then((buffer) => createFromBuffer(buffer));
    }
}
exports.createStreaming = createStreaming;
/**
 * Creates a formatter from the specified wasm module bytes.
 * @param wasmModuleBuffer - The buffer of the wasm module.
 */
function createFromBuffer(wasmModuleBuffer) {
    const wasmModule = new WebAssembly.Module(wasmModuleBuffer);
    return createFromWasmModule(wasmModule);
}
exports.createFromBuffer = createFromBuffer;
function createFromWasmModule(wasmModule) {
    const version = getModuleVersionOrThrow(wasmModule);
    if (version === 3) {
        const host = v3.createHost();
        const wasmInstance = new WebAssembly.Instance(wasmModule, host.createImportObject());
        return v3.createFromInstance(wasmInstance, host);
    }
    else {
        const _assert4 = version;
        const host = v4.createHost();
        const wasmInstance = new WebAssembly.Instance(wasmModule, host.createImportObject());
        return v4.createFromInstance(wasmInstance, host);
    }
}
exports.createFromWasmModule = createFromWasmModule;
function getModuleVersionOrThrow(module) {
    const version = getModuleVersion(module);
    if (version == null) {
        throw new Error("Couldn't determine dprint plugin version. Maybe the js-formatter version is too old?");
    }
    else if (version === 3 || version === 4) {
        return version;
    }
    else if (version > 4) {
        throw new Error(`Unsupported new dprint plugin version '${version}'. Maybe the js-formatter version is too old?`);
    }
    else {
        throw new Error(`Unsupported old dprint plugin version '${version}'. Please upgrade the plugin.`);
    }
}
function getModuleVersion(module) {
    function getVersionFromExport(name) {
        if (name === "get_plugin_schema_version") {
            return 3;
        }
        const prefix = "dprint_plugin_version_";
        if (name.startsWith(prefix)) {
            const value = parseInt(name.substring(prefix.length), 10);
            if (!isNaN(value)) {
                return value;
            }
        }
        return undefined;
    }
    const exports = WebAssembly.Module.exports(module);
    for (const e of exports) {
        const maybeVersion = getVersionFromExport(e.name);
        if (maybeVersion != null) {
            return maybeVersion;
        }
    }
    return undefined;
}
