import { toRelative } from '../util/path.js';
import { getColoredTitle, getIssueLine, getIssueTypeTitle } from './util/util.js';
const logIssueSet = (issues, cwd) => {
    for (const filePath of issues.sort())
        console.log(toRelative(filePath, cwd));
};
const logIssueRecord = (issues, cwd) => {
    const sortedByFilePath = issues.sort((a, b) => (a.filePath > b.filePath ? 1 : -1));
    for (const issue of sortedByFilePath)
        console.log(getIssueLine(issue, cwd));
};
export default ({ report, issues, isShowProgress, cwd }) => {
    const reportMultipleGroups = Object.values(report).filter(Boolean).length > 1;
    let totalIssues = 0;
    for (const [reportType, isReportType] of Object.entries(report)) {
        if (isReportType) {
            const title = reportMultipleGroups && getIssueTypeTitle(reportType);
            const isSet = issues[reportType] instanceof Set;
            const issuesForType = isSet
                ? Array.from(issues[reportType])
                : reportType === 'duplicates'
                    ? Object.values(issues[reportType]).flatMap(Object.values)
                    : Object.values(issues[reportType]).map(issues => {
                        const items = Object.values(issues);
                        return { ...items[0], symbols: items };
                    });
            if (issuesForType.length > 0) {
                title && console.log(getColoredTitle(title, issuesForType.length));
                if (isSet) {
                    logIssueSet(Array.from(issues[reportType]), cwd);
                }
                else {
                    logIssueRecord(issuesForType, cwd);
                }
            }
            totalIssues = totalIssues + issuesForType.length;
        }
    }
    if (totalIssues === 0 && isShowProgress) {
        console.log('✂️  Excellent, Knip found no issues.');
    }
};
