import { z } from 'zod/mini';
import { globSchema, pluginsSchema } from './plugins.js';
const pathsSchema = z.record(z.string(), z.array(z.string()));
const syncCompilerSchema = z.union([z.literal(true), z.custom()]);
const asyncCompilerSchema = z.custom();
const compilerSchema = z.union([syncCompilerSchema, asyncCompilerSchema]);
const compilersSchema = z.record(z.string(), compilerSchema);
const stringOrRegexSchema = z.array(z.union([z.string(), z.instanceof(RegExp)]));
const issueTypeSchema = z.union([
    z.literal('files'),
    z.literal('dependencies'),
    z.literal('devDependencies'),
    z.literal('optionalPeerDependencies'),
    z.literal('unlisted'),
    z.literal('binaries'),
    z.literal('unresolved'),
    z.literal('exports'),
    z.literal('types'),
    z.literal('nsExports'),
    z.literal('nsTypes'),
    z.literal('duplicates'),
    z.literal('enumMembers'),
    z.literal('classMembers'),
]);
const rulesSchema = z.partialRecord(issueTypeSchema, z.enum(['error', 'warn', 'off']));
const ignoreExportsUsedInFileObjectSchema = z.strictObject({
    class: z.optional(z.boolean()),
    enum: z.optional(z.boolean()),
    function: z.optional(z.boolean()),
    interface: z.optional(z.boolean()),
    member: z.optional(z.boolean()),
    type: z.optional(z.boolean()),
});
const ignoreExportsUsedInFileSchema = z.union([z.boolean(), ignoreExportsUsedInFileObjectSchema]);
const rootConfigurationSchema = z.object({
    $schema: z.optional(z.string()),
    rules: z.optional(rulesSchema),
    entry: z.optional(globSchema),
    project: z.optional(globSchema),
    paths: z.optional(pathsSchema),
    ignore: z.optional(globSchema),
    ignoreBinaries: z.optional(stringOrRegexSchema),
    ignoreDependencies: z.optional(stringOrRegexSchema),
    ignoreMembers: z.optional(stringOrRegexSchema),
    ignoreUnresolved: z.optional(stringOrRegexSchema),
    ignoreExportsUsedInFile: z.optional(ignoreExportsUsedInFileSchema),
    ignoreWorkspaces: z.optional(z.array(z.string())),
    includeEntryExports: z.optional(z.boolean()),
    compilers: z.optional(compilersSchema),
    syncCompilers: z.optional(z.record(z.string(), syncCompilerSchema)),
    asyncCompilers: z.optional(z.record(z.string(), asyncCompilerSchema)),
    tags: z.optional(z.array(z.string())),
    treatConfigHintsAsErrors: z.optional(z.boolean()),
});
const reportConfigSchema = z.object({
    include: z.optional(z.array(issueTypeSchema)),
    exclude: z.optional(z.array(issueTypeSchema)),
});
const baseWorkspaceConfigurationSchema = z.object({
    entry: z.optional(globSchema),
    project: z.optional(globSchema),
    paths: z.optional(pathsSchema),
    ignore: z.optional(globSchema),
    ignoreBinaries: z.optional(stringOrRegexSchema),
    ignoreDependencies: z.optional(stringOrRegexSchema),
    ignoreMembers: z.optional(stringOrRegexSchema),
    ignoreUnresolved: z.optional(stringOrRegexSchema),
    includeEntryExports: z.optional(z.boolean()),
});
const partialPluginsSchema = z.partial(pluginsSchema);
const workspaceConfigurationSchema = z.strictObject({
    ...baseWorkspaceConfigurationSchema.shape,
    ...partialPluginsSchema.shape,
});
const workspacesConfigurationSchema = z.object({
    workspaces: z.optional(z.record(z.string(), workspaceConfigurationSchema)),
});
export const knipConfigurationSchema = z.strictObject({
    ...rootConfigurationSchema.shape,
    ...reportConfigSchema.shape,
    ...workspacesConfigurationSchema.shape,
    ...partialPluginsSchema.shape,
});
