export interface TaskOptions {
    /**
     * The name of the task, as referenced in logs and the CLI.
     *
     * This name must not start with a "-" in order to prevent conflicts
     * with flags.
     */
    name: string;
    /**
     * A description of the task, for display in the CLI.
     */
    description?: string | undefined;
    /**
     * A list of tasks that must have been run to completion before
     * this task can execute.
     */
    dependencies?: readonly Task[] | undefined;
    /**
     * A function to execute when this task is run. If this function
     * returns a promise, the task will not be marked as finished until
     * that promise resolves.
     */
    run?: (() => void) | (() => PromiseLike<void>) | undefined;
    /**
     * If true, this task will be hidden from `hereby --tasks`.
     */
    hiddenFromTaskList?: boolean | undefined;
}
/**
 * A hereby Task. To get an instance, call `test`.
 */
export declare class Task {
    private _;
    private constructor();
}
/**
 * Creates a new Task.
 */
export declare function task(options: TaskOptions): Task;
