export class ConsoleStreamer {
    isEnabled = false;
    lines = 0;
    constructor(options) {
        this.isEnabled = options.isShowProgress;
    }
    clearLines(count) {
        if (count > 0) {
            for (let i = 0; i < count; i++) {
                process.stdout.moveCursor(0, -1);
                process.stdout.clearLine(1);
            }
        }
        process.stdout.cursorTo(0);
    }
    resetLines() {
        this.clearLines(this.lines);
    }
    update(messages) {
        this.resetLines();
        process.stdout.write(`${messages.join('\n')}\n`);
        this.lines = messages.length;
    }
    cast(message, sub) {
        if (!this.isEnabled)
            return;
        if (Array.isArray(message))
            this.update(message);
        else
            this.update([`${message}${!sub || sub === '.' ? '' : ` (${sub})`}…`]);
    }
    clear() {
        if (!this.isEnabled)
            return;
        this.resetLines();
    }
}
