import { ISSUE_TYPES } from '../constants.js';
import { ConfigurationError } from './errors.js';
export const defaultExcludedIssueTypes = ['classMembers', 'nsExports', 'nsTypes'];
const defaultIssueTypes = ISSUE_TYPES.filter(type => !defaultExcludedIssueTypes.includes(type));
const normalize = (values) => values.flatMap(value => value.split(','));
export const shorthandDeps = ['dependencies', 'optionalPeerDependencies', 'unlisted', 'binaries', 'unresolved'];
export const shorthandTypes = ['types', 'nsTypes', 'enumMembers', 'duplicates'];
export const shorthandFiles = ['files'];
export const getIncludedIssueTypes = (options) => {
    const incl = normalize(options.includeOverrides ?? []);
    const excl = normalize(options.excludeOverrides ?? []);
    for (const type of [...incl, ...excl, ...options.include, ...options.exclude]) {
        if (!ISSUE_TYPES.includes(type))
            throw new ConfigurationError(`Invalid issue type: ${type}`);
    }
    const excludes = options.exclude.filter(exclude => !incl.includes(exclude));
    const includes = options.include.filter(include => !excl.includes(include));
    const _include = [...incl, ...includes];
    const _exclude = [...excl, ...excludes];
    if (options.isProduction) {
        _exclude.push('devDependencies');
    }
    else {
        if (_include.includes('dependencies'))
            _include.push('devDependencies', 'optionalPeerDependencies');
        if (_exclude.includes('dependencies'))
            _exclude.push('devDependencies', 'optionalPeerDependencies');
    }
    const included = (_include.length > 0
        ? _include.some(type => !defaultExcludedIssueTypes.includes(type))
            ? _include
            : [..._include, ...defaultIssueTypes]
        : defaultIssueTypes).filter(group => !_exclude.includes(group));
    return ISSUE_TYPES.filter(i => i !== '_files').reduce((types, group) => {
        types[group] = included.includes(group);
        return types;
    }, {});
};
