import path from 'node:path';
export const isAbsolute = path.isAbsolute;
export const dirname = path.posix.dirname;
export const extname = path.posix.extname;
export const basename = path.posix.basename;
export const join = path.posix.join;
export const toPosix = (value) => value.split(path.sep).join(path.posix.sep);
export const resolve = path.posix.resolve;
export const relative = (from, to) => toPosix(path.relative(from, to));
export const isInNodeModules = (filePath) => filePath.includes('node_modules');
export const toAbsolute = (id, base) => (isAbsolute(id) ? id : join(base, id));
export const toRelative = (id, base) => (isAbsolute(id) ? relative(base, id) : id);
export const isInternal = (id) => (id.startsWith('.') || isAbsolute(id)) && !isInNodeModules(id);
export const normalize = path.posix.normalize;
