// Code generated by protoc-gen-go. DO NOT EDIT.
// versions:
// 	protoc-gen-go v1.29.0
// 	protoc        v3.17.3
// source: yandex/cloud/cdn/v1/resource.proto

package cdn

import (
	protoreflect "google.golang.org/protobuf/reflect/protoreflect"
	protoimpl "google.golang.org/protobuf/runtime/protoimpl"
	timestamppb "google.golang.org/protobuf/types/known/timestamppb"
	reflect "reflect"
	sync "sync"
)

const (
	// Verify that this generated code is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(20 - protoimpl.MinVersion)
	// Verify that runtime/protoimpl is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(protoimpl.MaxVersion - 20)
)

// This option defines the protocol that will be used by CDN servers to request
// content from an origin source. If not specified, we will use HTTP to connect
// to an origin server.
type OriginProtocol int32

const (
	OriginProtocol_ORIGIN_PROTOCOL_UNSPECIFIED OriginProtocol = 0
	// CDN servers will connect to your origin via HTTP.
	OriginProtocol_HTTP OriginProtocol = 1
	// CDN servers will connect to your origin via HTTPS.
	OriginProtocol_HTTPS OriginProtocol = 2
	// Connection protocol will be chosen automatically (content on the
	// origin source should be available for the CDN both through HTTP and HTTPS).
	OriginProtocol_MATCH OriginProtocol = 3
)

// Enum value maps for OriginProtocol.
var (
	OriginProtocol_name = map[int32]string{
		0: "ORIGIN_PROTOCOL_UNSPECIFIED",
		1: "HTTP",
		2: "HTTPS",
		3: "MATCH",
	}
	OriginProtocol_value = map[string]int32{
		"ORIGIN_PROTOCOL_UNSPECIFIED": 0,
		"HTTP":                        1,
		"HTTPS":                       2,
		"MATCH":                       3,
	}
)

func (x OriginProtocol) Enum() *OriginProtocol {
	p := new(OriginProtocol)
	*p = x
	return p
}

func (x OriginProtocol) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (OriginProtocol) Descriptor() protoreflect.EnumDescriptor {
	return file_yandex_cloud_cdn_v1_resource_proto_enumTypes[0].Descriptor()
}

func (OriginProtocol) Type() protoreflect.EnumType {
	return &file_yandex_cloud_cdn_v1_resource_proto_enumTypes[0]
}

func (x OriginProtocol) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use OriginProtocol.Descriptor instead.
func (OriginProtocol) EnumDescriptor() ([]byte, []int) {
	return file_yandex_cloud_cdn_v1_resource_proto_rawDescGZIP(), []int{0}
}

// RewriteFlag defines flag for the Rewrite option.
type RewriteFlag int32

const (
	RewriteFlag_REWRITE_FLAG_UNSPECIFIED RewriteFlag = 0
	// Stops processing of the current set of ngx_http_rewrite_module directives and
	// starts a search for a new location matching changed URI.
	RewriteFlag_LAST RewriteFlag = 1
	// Stops processing of the current set of the Rewrite option.
	RewriteFlag_BREAK RewriteFlag = 2
	// Returns a temporary redirect with the 302 code; It is used when a replacement string does not start
	// with "http://", "https://", or "$scheme".
	RewriteFlag_REDIRECT RewriteFlag = 3
	// Returns a permanent redirect with the 301 code.
	RewriteFlag_PERMANENT RewriteFlag = 4
)

// Enum value maps for RewriteFlag.
var (
	RewriteFlag_name = map[int32]string{
		0: "REWRITE_FLAG_UNSPECIFIED",
		1: "LAST",
		2: "BREAK",
		3: "REDIRECT",
		4: "PERMANENT",
	}
	RewriteFlag_value = map[string]int32{
		"REWRITE_FLAG_UNSPECIFIED": 0,
		"LAST":                     1,
		"BREAK":                    2,
		"REDIRECT":                 3,
		"PERMANENT":                4,
	}
)

func (x RewriteFlag) Enum() *RewriteFlag {
	p := new(RewriteFlag)
	*p = x
	return p
}

func (x RewriteFlag) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (RewriteFlag) Descriptor() protoreflect.EnumDescriptor {
	return file_yandex_cloud_cdn_v1_resource_proto_enumTypes[1].Descriptor()
}

func (RewriteFlag) Type() protoreflect.EnumType {
	return &file_yandex_cloud_cdn_v1_resource_proto_enumTypes[1]
}

func (x RewriteFlag) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use RewriteFlag.Descriptor instead.
func (RewriteFlag) EnumDescriptor() ([]byte, []int) {
	return file_yandex_cloud_cdn_v1_resource_proto_rawDescGZIP(), []int{1}
}

// A certificate type parameters.
type SSLCertificateType int32

const (
	// SSL certificate is unspecified.
	SSLCertificateType_SSL_CERTIFICATE_TYPE_UNSPECIFIED SSLCertificateType = 0
	// No SSL certificate is added, the requests are sent via HTTP.
	SSLCertificateType_DONT_USE SSLCertificateType = 1
	// Works only if you have already pointed your domain name to the protected IP address in your DNS
	SSLCertificateType_LETS_ENCRYPT_GCORE SSLCertificateType = 2
	// Add your SSL certificate by uploading the certificate in PEM format and your private key
	SSLCertificateType_CM SSLCertificateType = 3
)

// Enum value maps for SSLCertificateType.
var (
	SSLCertificateType_name = map[int32]string{
		0: "SSL_CERTIFICATE_TYPE_UNSPECIFIED",
		1: "DONT_USE",
		2: "LETS_ENCRYPT_GCORE",
		3: "CM",
	}
	SSLCertificateType_value = map[string]int32{
		"SSL_CERTIFICATE_TYPE_UNSPECIFIED": 0,
		"DONT_USE":                         1,
		"LETS_ENCRYPT_GCORE":               2,
		"CM":                               3,
	}
)

func (x SSLCertificateType) Enum() *SSLCertificateType {
	p := new(SSLCertificateType)
	*p = x
	return p
}

func (x SSLCertificateType) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (SSLCertificateType) Descriptor() protoreflect.EnumDescriptor {
	return file_yandex_cloud_cdn_v1_resource_proto_enumTypes[2].Descriptor()
}

func (SSLCertificateType) Type() protoreflect.EnumType {
	return &file_yandex_cloud_cdn_v1_resource_proto_enumTypes[2]
}

func (x SSLCertificateType) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use SSLCertificateType.Descriptor instead.
func (SSLCertificateType) EnumDescriptor() ([]byte, []int) {
	return file_yandex_cloud_cdn_v1_resource_proto_rawDescGZIP(), []int{2}
}

// A certificate status parameters.
type SSLCertificateStatus int32

const (
	// SSL certificate is unspecified.
	SSLCertificateStatus_SSL_CERTIFICATE_STATUS_UNSPECIFIED SSLCertificateStatus = 0
	// SSL certificate is ready to use.
	SSLCertificateStatus_READY SSLCertificateStatus = 1
	// SSL certificate is creating.
	SSLCertificateStatus_CREATING SSLCertificateStatus = 2
)

// Enum value maps for SSLCertificateStatus.
var (
	SSLCertificateStatus_name = map[int32]string{
		0: "SSL_CERTIFICATE_STATUS_UNSPECIFIED",
		1: "READY",
		2: "CREATING",
	}
	SSLCertificateStatus_value = map[string]int32{
		"SSL_CERTIFICATE_STATUS_UNSPECIFIED": 0,
		"READY":                              1,
		"CREATING":                           2,
	}
)

func (x SSLCertificateStatus) Enum() *SSLCertificateStatus {
	p := new(SSLCertificateStatus)
	*p = x
	return p
}

func (x SSLCertificateStatus) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (SSLCertificateStatus) Descriptor() protoreflect.EnumDescriptor {
	return file_yandex_cloud_cdn_v1_resource_proto_enumTypes[3].Descriptor()
}

func (SSLCertificateStatus) Type() protoreflect.EnumType {
	return &file_yandex_cloud_cdn_v1_resource_proto_enumTypes[3]
}

func (x SSLCertificateStatus) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use SSLCertificateStatus.Descriptor instead.
func (SSLCertificateStatus) EnumDescriptor() ([]byte, []int) {
	return file_yandex_cloud_cdn_v1_resource_proto_rawDescGZIP(), []int{3}
}

// List of secondary (alternative) CNAMEs.
type SecondaryHostnames struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// List of secondary hostname values.
	Values []string `protobuf:"bytes,1,rep,name=values,proto3" json:"values,omitempty"`
}

func (x *SecondaryHostnames) Reset() {
	*x = SecondaryHostnames{}
	if protoimpl.UnsafeEnabled {
		mi := &file_yandex_cloud_cdn_v1_resource_proto_msgTypes[0]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *SecondaryHostnames) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*SecondaryHostnames) ProtoMessage() {}

func (x *SecondaryHostnames) ProtoReflect() protoreflect.Message {
	mi := &file_yandex_cloud_cdn_v1_resource_proto_msgTypes[0]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use SecondaryHostnames.ProtoReflect.Descriptor instead.
func (*SecondaryHostnames) Descriptor() ([]byte, []int) {
	return file_yandex_cloud_cdn_v1_resource_proto_rawDescGZIP(), []int{0}
}

func (x *SecondaryHostnames) GetValues() []string {
	if x != nil {
		return x.Values
	}
	return nil
}

// A CDN resource - representation of providers resource.
type Resource struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// ID of the resource.
	Id string `protobuf:"bytes,1,opt,name=id,proto3" json:"id,omitempty"`
	// Folder id.
	FolderId string `protobuf:"bytes,2,opt,name=folder_id,json=folderId,proto3" json:"folder_id,omitempty"`
	// CDN endpoint CNAME, must be unique among resources.
	Cname string `protobuf:"bytes,3,opt,name=cname,proto3" json:"cname,omitempty"`
	// Creation timestamp.
	CreatedAt *timestamppb.Timestamp `protobuf:"bytes,4,opt,name=created_at,json=createdAt,proto3" json:"created_at,omitempty"`
	// Update timestamp.
	UpdatedAt *timestamppb.Timestamp `protobuf:"bytes,5,opt,name=updated_at,json=updatedAt,proto3" json:"updated_at,omitempty"`
	// Flag to create Resource either in active or disabled state.
	// True - the content from CDN is available to clients.
	// False - the content from CDN isn't available to clients.
	Active bool `protobuf:"varint,6,opt,name=active,proto3" json:"active,omitempty"`
	// Resource settings and options to tune CDN edge behavior.
	Options *ResourceOptions `protobuf:"bytes,7,opt,name=options,proto3" json:"options,omitempty"`
	// List of secondary hostname strings.
	SecondaryHostnames []string `protobuf:"bytes,8,rep,name=secondary_hostnames,json=secondaryHostnames,proto3" json:"secondary_hostnames,omitempty"`
	// ID of the origin group.
	OriginGroupId int64 `protobuf:"varint,9,opt,name=origin_group_id,json=originGroupId,proto3" json:"origin_group_id,omitempty"`
	// Name of the origin group.
	OriginGroupName string `protobuf:"bytes,10,opt,name=origin_group_name,json=originGroupName,proto3" json:"origin_group_name,omitempty"`
	// Specify the protocol schema to be used in communication with origin.
	OriginProtocol OriginProtocol `protobuf:"varint,11,opt,name=origin_protocol,json=originProtocol,proto3,enum=yandex.cloud.cdn.v1.OriginProtocol" json:"origin_protocol,omitempty"`
	// SSL certificate options.
	SslCertificate *SSLCertificate `protobuf:"bytes,12,opt,name=ssl_certificate,json=sslCertificate,proto3" json:"ssl_certificate,omitempty"`
	// Labels of the resource.
	Labels map[string]string `protobuf:"bytes,13,rep,name=labels,proto3" json:"labels,omitempty" protobuf_key:"bytes,1,opt,name=key,proto3" protobuf_val:"bytes,2,opt,name=value,proto3"`
}

func (x *Resource) Reset() {
	*x = Resource{}
	if protoimpl.UnsafeEnabled {
		mi := &file_yandex_cloud_cdn_v1_resource_proto_msgTypes[1]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *Resource) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Resource) ProtoMessage() {}

func (x *Resource) ProtoReflect() protoreflect.Message {
	mi := &file_yandex_cloud_cdn_v1_resource_proto_msgTypes[1]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Resource.ProtoReflect.Descriptor instead.
func (*Resource) Descriptor() ([]byte, []int) {
	return file_yandex_cloud_cdn_v1_resource_proto_rawDescGZIP(), []int{1}
}

func (x *Resource) GetId() string {
	if x != nil {
		return x.Id
	}
	return ""
}

func (x *Resource) GetFolderId() string {
	if x != nil {
		return x.FolderId
	}
	return ""
}

func (x *Resource) GetCname() string {
	if x != nil {
		return x.Cname
	}
	return ""
}

func (x *Resource) GetCreatedAt() *timestamppb.Timestamp {
	if x != nil {
		return x.CreatedAt
	}
	return nil
}

func (x *Resource) GetUpdatedAt() *timestamppb.Timestamp {
	if x != nil {
		return x.UpdatedAt
	}
	return nil
}

func (x *Resource) GetActive() bool {
	if x != nil {
		return x.Active
	}
	return false
}

func (x *Resource) GetOptions() *ResourceOptions {
	if x != nil {
		return x.Options
	}
	return nil
}

func (x *Resource) GetSecondaryHostnames() []string {
	if x != nil {
		return x.SecondaryHostnames
	}
	return nil
}

func (x *Resource) GetOriginGroupId() int64 {
	if x != nil {
		return x.OriginGroupId
	}
	return 0
}

func (x *Resource) GetOriginGroupName() string {
	if x != nil {
		return x.OriginGroupName
	}
	return ""
}

func (x *Resource) GetOriginProtocol() OriginProtocol {
	if x != nil {
		return x.OriginProtocol
	}
	return OriginProtocol_ORIGIN_PROTOCOL_UNSPECIFIED
}

func (x *Resource) GetSslCertificate() *SSLCertificate {
	if x != nil {
		return x.SslCertificate
	}
	return nil
}

func (x *Resource) GetLabels() map[string]string {
	if x != nil {
		return x.Labels
	}
	return nil
}

// A major set of various resource options.
type ResourceOptions struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Set up a cache status.
	DisableCache *ResourceOptions_BoolOption `protobuf:"bytes,1,opt,name=disable_cache,json=disableCache,proto3" json:"disable_cache,omitempty"`
	// Set up [EdgeCacheSettings].
	EdgeCacheSettings *ResourceOptions_EdgeCacheSettings `protobuf:"bytes,2,opt,name=edge_cache_settings,json=edgeCacheSettings,proto3" json:"edge_cache_settings,omitempty"`
	// Using [Int64Option]. Set up a cache period for the end-users browser.
	// Content will be cached due to origin settings.
	// If there are no cache settings on your origin, the content will not be cached.
	// The list of HTTP response codes that can be cached in browsers: 200, 201, 204, 206, 301, 302, 303, 304, 307, 308.
	// Other response codes will not be cached.
	// The default value is 4 days.
	BrowserCacheSettings *ResourceOptions_Int64Option `protobuf:"bytes,3,opt,name=browser_cache_settings,json=browserCacheSettings,proto3" json:"browser_cache_settings,omitempty"`
	// List HTTP headers that must be included in responses to clients.
	CacheHttpHeaders *ResourceOptions_StringsListOption `protobuf:"bytes,4,opt,name=cache_http_headers,json=cacheHttpHeaders,proto3" json:"cache_http_headers,omitempty"`
	// Set up [QueryParamsOptions].
	QueryParamsOptions *ResourceOptions_QueryParamsOptions `protobuf:"bytes,5,opt,name=query_params_options,json=queryParamsOptions,proto3" json:"query_params_options,omitempty"`
	// Files larger than 10 MB will be requested and cached in parts (no larger than 10 MB each part). It reduces time to first byte.
	//
	// The origin must support HTTP Range requests.
	//
	// By default the option is disabled.
	Slice *ResourceOptions_BoolOption `protobuf:"bytes,6,opt,name=slice,proto3" json:"slice,omitempty"`
	// Set up compression variant.
	CompressionOptions *ResourceOptions_CompressionOptions `protobuf:"bytes,7,opt,name=compression_options,json=compressionOptions,proto3" json:"compression_options,omitempty"`
	// Set up redirects.
	RedirectOptions *ResourceOptions_RedirectOptions `protobuf:"bytes,8,opt,name=redirect_options,json=redirectOptions,proto3" json:"redirect_options,omitempty"`
	// Set up host parameters.
	HostOptions *ResourceOptions_HostOptions `protobuf:"bytes,9,opt,name=host_options,json=hostOptions,proto3" json:"host_options,omitempty"`
	// Set up static headers that CDN servers send in responses to clients.
	StaticHeaders *ResourceOptions_StringsMapOption `protobuf:"bytes,10,opt,name=static_headers,json=staticHeaders,proto3" json:"static_headers,omitempty"`
	// Parameter that lets browsers get access to selected resources from a domain
	// different to a domain from which the request is received.
	// [Read more](/docs/cdn/concepts/cors).
	Cors *ResourceOptions_StringsListOption `protobuf:"bytes,11,opt,name=cors,proto3" json:"cors,omitempty"`
	// List of errors which instruct CDN servers to serve stale content to clients.
	//
	// Possible values: `error`, `http_403`, `http_404`, `http_429`, `http_500`, `http_502`, `http_503`, `http_504`, `invalid_header`, `timeout`, `updating`.
	Stale *ResourceOptions_StringsListOption `protobuf:"bytes,12,opt,name=stale,proto3" json:"stale,omitempty"`
	// HTTP methods for your CDN content. By default the following methods
	// are allowed: GET, HEAD, POST, PUT, PATCH, DELETE, OPTIONS.
	// In case some methods are not allowed to the user, they will get the 405
	// (Method Not Allowed) response. If the method is not supported,
	// the user gets the 501 (Not Implemented) response.
	AllowedHttpMethods *ResourceOptions_StringsListOption `protobuf:"bytes,13,opt,name=allowed_http_methods,json=allowedHttpMethods,proto3" json:"allowed_http_methods,omitempty"`
	// Allows caching for GET, HEAD and POST requests.
	ProxyCacheMethodsSet *ResourceOptions_BoolOption `protobuf:"bytes,14,opt,name=proxy_cache_methods_set,json=proxyCacheMethodsSet,proto3" json:"proxy_cache_methods_set,omitempty"`
	// Disabling proxy force ranges.
	DisableProxyForceRanges *ResourceOptions_BoolOption `protobuf:"bytes,15,opt,name=disable_proxy_force_ranges,json=disableProxyForceRanges,proto3" json:"disable_proxy_force_ranges,omitempty"`
	// Set up custom headers that CDN servers send in requests to origins.
	// The Header name field can contain letters (A-Z, a-z), numbers (0-9), dashes (-) and underscores (_).
	// The Value field can contain letters (A-Z, a-z), numbers (0-9), dashes (-),
	// underscores (_), slashes (/), colons (:), equal (=), dots (.), and spaces.
	StaticRequestHeaders *ResourceOptions_StringsMapOption `protobuf:"bytes,16,opt,name=static_request_headers,json=staticRequestHeaders,proto3" json:"static_request_headers,omitempty"`
	// Wildcard additional CNAME.
	// If a resource has a wildcard additional CNAME, you can use your own certificate for content delivery via HTTPS. Read-only.
	CustomServerName *ResourceOptions_StringOption `protobuf:"bytes,17,opt,name=custom_server_name,json=customServerName,proto3" json:"custom_server_name,omitempty"`
	// Using [BoolOption] for ignoring cookie.
	IgnoreCookie *ResourceOptions_BoolOption `protobuf:"bytes,18,opt,name=ignore_cookie,json=ignoreCookie,proto3" json:"ignore_cookie,omitempty"`
	// Changing or redirecting query paths.
	Rewrite *ResourceOptions_RewriteOption `protobuf:"bytes,19,opt,name=rewrite,proto3" json:"rewrite,omitempty"`
}

func (x *ResourceOptions) Reset() {
	*x = ResourceOptions{}
	if protoimpl.UnsafeEnabled {
		mi := &file_yandex_cloud_cdn_v1_resource_proto_msgTypes[2]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ResourceOptions) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ResourceOptions) ProtoMessage() {}

func (x *ResourceOptions) ProtoReflect() protoreflect.Message {
	mi := &file_yandex_cloud_cdn_v1_resource_proto_msgTypes[2]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ResourceOptions.ProtoReflect.Descriptor instead.
func (*ResourceOptions) Descriptor() ([]byte, []int) {
	return file_yandex_cloud_cdn_v1_resource_proto_rawDescGZIP(), []int{2}
}

func (x *ResourceOptions) GetDisableCache() *ResourceOptions_BoolOption {
	if x != nil {
		return x.DisableCache
	}
	return nil
}

func (x *ResourceOptions) GetEdgeCacheSettings() *ResourceOptions_EdgeCacheSettings {
	if x != nil {
		return x.EdgeCacheSettings
	}
	return nil
}

func (x *ResourceOptions) GetBrowserCacheSettings() *ResourceOptions_Int64Option {
	if x != nil {
		return x.BrowserCacheSettings
	}
	return nil
}

func (x *ResourceOptions) GetCacheHttpHeaders() *ResourceOptions_StringsListOption {
	if x != nil {
		return x.CacheHttpHeaders
	}
	return nil
}

func (x *ResourceOptions) GetQueryParamsOptions() *ResourceOptions_QueryParamsOptions {
	if x != nil {
		return x.QueryParamsOptions
	}
	return nil
}

func (x *ResourceOptions) GetSlice() *ResourceOptions_BoolOption {
	if x != nil {
		return x.Slice
	}
	return nil
}

func (x *ResourceOptions) GetCompressionOptions() *ResourceOptions_CompressionOptions {
	if x != nil {
		return x.CompressionOptions
	}
	return nil
}

func (x *ResourceOptions) GetRedirectOptions() *ResourceOptions_RedirectOptions {
	if x != nil {
		return x.RedirectOptions
	}
	return nil
}

func (x *ResourceOptions) GetHostOptions() *ResourceOptions_HostOptions {
	if x != nil {
		return x.HostOptions
	}
	return nil
}

func (x *ResourceOptions) GetStaticHeaders() *ResourceOptions_StringsMapOption {
	if x != nil {
		return x.StaticHeaders
	}
	return nil
}

func (x *ResourceOptions) GetCors() *ResourceOptions_StringsListOption {
	if x != nil {
		return x.Cors
	}
	return nil
}

func (x *ResourceOptions) GetStale() *ResourceOptions_StringsListOption {
	if x != nil {
		return x.Stale
	}
	return nil
}

func (x *ResourceOptions) GetAllowedHttpMethods() *ResourceOptions_StringsListOption {
	if x != nil {
		return x.AllowedHttpMethods
	}
	return nil
}

func (x *ResourceOptions) GetProxyCacheMethodsSet() *ResourceOptions_BoolOption {
	if x != nil {
		return x.ProxyCacheMethodsSet
	}
	return nil
}

func (x *ResourceOptions) GetDisableProxyForceRanges() *ResourceOptions_BoolOption {
	if x != nil {
		return x.DisableProxyForceRanges
	}
	return nil
}

func (x *ResourceOptions) GetStaticRequestHeaders() *ResourceOptions_StringsMapOption {
	if x != nil {
		return x.StaticRequestHeaders
	}
	return nil
}

func (x *ResourceOptions) GetCustomServerName() *ResourceOptions_StringOption {
	if x != nil {
		return x.CustomServerName
	}
	return nil
}

func (x *ResourceOptions) GetIgnoreCookie() *ResourceOptions_BoolOption {
	if x != nil {
		return x.IgnoreCookie
	}
	return nil
}

func (x *ResourceOptions) GetRewrite() *ResourceOptions_RewriteOption {
	if x != nil {
		return x.Rewrite
	}
	return nil
}

// A set of the personal SSL certificate parameters.
type SSLTargetCertificate struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Type of the certificate.
	Type SSLCertificateType `protobuf:"varint,1,opt,name=type,proto3,enum=yandex.cloud.cdn.v1.SSLCertificateType" json:"type,omitempty"`
	// Certificate data.
	Data *SSLCertificateData `protobuf:"bytes,2,opt,name=data,proto3" json:"data,omitempty"`
}

func (x *SSLTargetCertificate) Reset() {
	*x = SSLTargetCertificate{}
	if protoimpl.UnsafeEnabled {
		mi := &file_yandex_cloud_cdn_v1_resource_proto_msgTypes[3]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *SSLTargetCertificate) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*SSLTargetCertificate) ProtoMessage() {}

func (x *SSLTargetCertificate) ProtoReflect() protoreflect.Message {
	mi := &file_yandex_cloud_cdn_v1_resource_proto_msgTypes[3]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use SSLTargetCertificate.ProtoReflect.Descriptor instead.
func (*SSLTargetCertificate) Descriptor() ([]byte, []int) {
	return file_yandex_cloud_cdn_v1_resource_proto_rawDescGZIP(), []int{3}
}

func (x *SSLTargetCertificate) GetType() SSLCertificateType {
	if x != nil {
		return x.Type
	}
	return SSLCertificateType_SSL_CERTIFICATE_TYPE_UNSPECIFIED
}

func (x *SSLTargetCertificate) GetData() *SSLCertificateData {
	if x != nil {
		return x.Data
	}
	return nil
}

// A SSL certificate parameters.
type SSLCertificate struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Type of the certificate.
	Type SSLCertificateType `protobuf:"varint,1,opt,name=type,proto3,enum=yandex.cloud.cdn.v1.SSLCertificateType" json:"type,omitempty"`
	// Active status.
	Status SSLCertificateStatus `protobuf:"varint,2,opt,name=status,proto3,enum=yandex.cloud.cdn.v1.SSLCertificateStatus" json:"status,omitempty"`
	// Certificate data.
	Data *SSLCertificateData `protobuf:"bytes,3,opt,name=data,proto3" json:"data,omitempty"`
}

func (x *SSLCertificate) Reset() {
	*x = SSLCertificate{}
	if protoimpl.UnsafeEnabled {
		mi := &file_yandex_cloud_cdn_v1_resource_proto_msgTypes[4]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *SSLCertificate) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*SSLCertificate) ProtoMessage() {}

func (x *SSLCertificate) ProtoReflect() protoreflect.Message {
	mi := &file_yandex_cloud_cdn_v1_resource_proto_msgTypes[4]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use SSLCertificate.ProtoReflect.Descriptor instead.
func (*SSLCertificate) Descriptor() ([]byte, []int) {
	return file_yandex_cloud_cdn_v1_resource_proto_rawDescGZIP(), []int{4}
}

func (x *SSLCertificate) GetType() SSLCertificateType {
	if x != nil {
		return x.Type
	}
	return SSLCertificateType_SSL_CERTIFICATE_TYPE_UNSPECIFIED
}

func (x *SSLCertificate) GetStatus() SSLCertificateStatus {
	if x != nil {
		return x.Status
	}
	return SSLCertificateStatus_SSL_CERTIFICATE_STATUS_UNSPECIFIED
}

func (x *SSLCertificate) GetData() *SSLCertificateData {
	if x != nil {
		return x.Data
	}
	return nil
}

// A certificate data parameters.
type SSLCertificateData struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Types that are assignable to SslCertificateDataVariant:
	//
	//	*SSLCertificateData_Cm
	SslCertificateDataVariant isSSLCertificateData_SslCertificateDataVariant `protobuf_oneof:"ssl_certificate_data_variant"`
}

func (x *SSLCertificateData) Reset() {
	*x = SSLCertificateData{}
	if protoimpl.UnsafeEnabled {
		mi := &file_yandex_cloud_cdn_v1_resource_proto_msgTypes[5]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *SSLCertificateData) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*SSLCertificateData) ProtoMessage() {}

func (x *SSLCertificateData) ProtoReflect() protoreflect.Message {
	mi := &file_yandex_cloud_cdn_v1_resource_proto_msgTypes[5]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use SSLCertificateData.ProtoReflect.Descriptor instead.
func (*SSLCertificateData) Descriptor() ([]byte, []int) {
	return file_yandex_cloud_cdn_v1_resource_proto_rawDescGZIP(), []int{5}
}

func (m *SSLCertificateData) GetSslCertificateDataVariant() isSSLCertificateData_SslCertificateDataVariant {
	if m != nil {
		return m.SslCertificateDataVariant
	}
	return nil
}

func (x *SSLCertificateData) GetCm() *SSLCertificateCMData {
	if x, ok := x.GetSslCertificateDataVariant().(*SSLCertificateData_Cm); ok {
		return x.Cm
	}
	return nil
}

type isSSLCertificateData_SslCertificateDataVariant interface {
	isSSLCertificateData_SslCertificateDataVariant()
}

type SSLCertificateData_Cm struct {
	// Custom (add your SSL certificate by uploading the certificate
	// in PEM format and your private key).
	Cm *SSLCertificateCMData `protobuf:"bytes,1,opt,name=cm,proto3,oneof"`
}

func (*SSLCertificateData_Cm) isSSLCertificateData_SslCertificateDataVariant() {}

// A certificate data custom parameters.
type SSLCertificateCMData struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// ID of the custom certificate.
	Id string `protobuf:"bytes,1,opt,name=id,proto3" json:"id,omitempty"`
}

func (x *SSLCertificateCMData) Reset() {
	*x = SSLCertificateCMData{}
	if protoimpl.UnsafeEnabled {
		mi := &file_yandex_cloud_cdn_v1_resource_proto_msgTypes[6]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *SSLCertificateCMData) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*SSLCertificateCMData) ProtoMessage() {}

func (x *SSLCertificateCMData) ProtoReflect() protoreflect.Message {
	mi := &file_yandex_cloud_cdn_v1_resource_proto_msgTypes[6]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use SSLCertificateCMData.ProtoReflect.Descriptor instead.
func (*SSLCertificateCMData) Descriptor() ([]byte, []int) {
	return file_yandex_cloud_cdn_v1_resource_proto_rawDescGZIP(), []int{6}
}

func (x *SSLCertificateCMData) GetId() string {
	if x != nil {
		return x.Id
	}
	return ""
}

// Set up bool values.
type ResourceOptions_BoolOption struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// True - the option is enabled and its [value] is applied to the resource.
	// False - the option is disabled and its default value is used for the resource.
	Enabled bool `protobuf:"varint,1,opt,name=enabled,proto3" json:"enabled,omitempty"`
	// Value of the option.
	Value bool `protobuf:"varint,2,opt,name=value,proto3" json:"value,omitempty"`
}

func (x *ResourceOptions_BoolOption) Reset() {
	*x = ResourceOptions_BoolOption{}
	if protoimpl.UnsafeEnabled {
		mi := &file_yandex_cloud_cdn_v1_resource_proto_msgTypes[8]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ResourceOptions_BoolOption) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ResourceOptions_BoolOption) ProtoMessage() {}

func (x *ResourceOptions_BoolOption) ProtoReflect() protoreflect.Message {
	mi := &file_yandex_cloud_cdn_v1_resource_proto_msgTypes[8]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ResourceOptions_BoolOption.ProtoReflect.Descriptor instead.
func (*ResourceOptions_BoolOption) Descriptor() ([]byte, []int) {
	return file_yandex_cloud_cdn_v1_resource_proto_rawDescGZIP(), []int{2, 0}
}

func (x *ResourceOptions_BoolOption) GetEnabled() bool {
	if x != nil {
		return x.Enabled
	}
	return false
}

func (x *ResourceOptions_BoolOption) GetValue() bool {
	if x != nil {
		return x.Value
	}
	return false
}

// A set of the string parameters.
type ResourceOptions_StringOption struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// True - the option is enabled and its [value] is applied to the resource.
	// False - the option is disabled and its default value is used for the resource.
	Enabled bool `protobuf:"varint,1,opt,name=enabled,proto3" json:"enabled,omitempty"`
	// Value of the option.
	Value string `protobuf:"bytes,2,opt,name=value,proto3" json:"value,omitempty"`
}

func (x *ResourceOptions_StringOption) Reset() {
	*x = ResourceOptions_StringOption{}
	if protoimpl.UnsafeEnabled {
		mi := &file_yandex_cloud_cdn_v1_resource_proto_msgTypes[9]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ResourceOptions_StringOption) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ResourceOptions_StringOption) ProtoMessage() {}

func (x *ResourceOptions_StringOption) ProtoReflect() protoreflect.Message {
	mi := &file_yandex_cloud_cdn_v1_resource_proto_msgTypes[9]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ResourceOptions_StringOption.ProtoReflect.Descriptor instead.
func (*ResourceOptions_StringOption) Descriptor() ([]byte, []int) {
	return file_yandex_cloud_cdn_v1_resource_proto_rawDescGZIP(), []int{2, 1}
}

func (x *ResourceOptions_StringOption) GetEnabled() bool {
	if x != nil {
		return x.Enabled
	}
	return false
}

func (x *ResourceOptions_StringOption) GetValue() string {
	if x != nil {
		return x.Value
	}
	return ""
}

// A set of the numeric parameters.
type ResourceOptions_Int64Option struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// True - the option is enabled and its [value] is applied to the resource.
	// False - the option is disabled and its default value is used for the resource.
	Enabled bool `protobuf:"varint,1,opt,name=enabled,proto3" json:"enabled,omitempty"`
	// Value of the option.
	Value int64 `protobuf:"varint,2,opt,name=value,proto3" json:"value,omitempty"`
}

func (x *ResourceOptions_Int64Option) Reset() {
	*x = ResourceOptions_Int64Option{}
	if protoimpl.UnsafeEnabled {
		mi := &file_yandex_cloud_cdn_v1_resource_proto_msgTypes[10]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ResourceOptions_Int64Option) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ResourceOptions_Int64Option) ProtoMessage() {}

func (x *ResourceOptions_Int64Option) ProtoReflect() protoreflect.Message {
	mi := &file_yandex_cloud_cdn_v1_resource_proto_msgTypes[10]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ResourceOptions_Int64Option.ProtoReflect.Descriptor instead.
func (*ResourceOptions_Int64Option) Descriptor() ([]byte, []int) {
	return file_yandex_cloud_cdn_v1_resource_proto_rawDescGZIP(), []int{2, 2}
}

func (x *ResourceOptions_Int64Option) GetEnabled() bool {
	if x != nil {
		return x.Enabled
	}
	return false
}

func (x *ResourceOptions_Int64Option) GetValue() int64 {
	if x != nil {
		return x.Value
	}
	return 0
}

// A set of the string list parameters.
type ResourceOptions_StringsListOption struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// True - the option is enabled and its [value] is applied to the resource.
	// False - the option is disabled and its default value is used for the resource.
	Enabled bool `protobuf:"varint,1,opt,name=enabled,proto3" json:"enabled,omitempty"`
	// Value of the option.
	Value []string `protobuf:"bytes,2,rep,name=value,proto3" json:"value,omitempty"`
}

func (x *ResourceOptions_StringsListOption) Reset() {
	*x = ResourceOptions_StringsListOption{}
	if protoimpl.UnsafeEnabled {
		mi := &file_yandex_cloud_cdn_v1_resource_proto_msgTypes[11]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ResourceOptions_StringsListOption) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ResourceOptions_StringsListOption) ProtoMessage() {}

func (x *ResourceOptions_StringsListOption) ProtoReflect() protoreflect.Message {
	mi := &file_yandex_cloud_cdn_v1_resource_proto_msgTypes[11]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ResourceOptions_StringsListOption.ProtoReflect.Descriptor instead.
func (*ResourceOptions_StringsListOption) Descriptor() ([]byte, []int) {
	return file_yandex_cloud_cdn_v1_resource_proto_rawDescGZIP(), []int{2, 3}
}

func (x *ResourceOptions_StringsListOption) GetEnabled() bool {
	if x != nil {
		return x.Enabled
	}
	return false
}

func (x *ResourceOptions_StringsListOption) GetValue() []string {
	if x != nil {
		return x.Value
	}
	return nil
}

// A set of the strings map parameters.
type ResourceOptions_StringsMapOption struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// True - the option is enabled and its [value] is applied to the resource.
	// False - the option is disabled and its default value is used for the resource.
	Enabled bool `protobuf:"varint,1,opt,name=enabled,proto3" json:"enabled,omitempty"`
	// Value of the option.
	Value map[string]string `protobuf:"bytes,2,rep,name=value,proto3" json:"value,omitempty" protobuf_key:"bytes,1,opt,name=key,proto3" protobuf_val:"bytes,2,opt,name=value,proto3"`
}

func (x *ResourceOptions_StringsMapOption) Reset() {
	*x = ResourceOptions_StringsMapOption{}
	if protoimpl.UnsafeEnabled {
		mi := &file_yandex_cloud_cdn_v1_resource_proto_msgTypes[12]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ResourceOptions_StringsMapOption) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ResourceOptions_StringsMapOption) ProtoMessage() {}

func (x *ResourceOptions_StringsMapOption) ProtoReflect() protoreflect.Message {
	mi := &file_yandex_cloud_cdn_v1_resource_proto_msgTypes[12]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ResourceOptions_StringsMapOption.ProtoReflect.Descriptor instead.
func (*ResourceOptions_StringsMapOption) Descriptor() ([]byte, []int) {
	return file_yandex_cloud_cdn_v1_resource_proto_rawDescGZIP(), []int{2, 4}
}

func (x *ResourceOptions_StringsMapOption) GetEnabled() bool {
	if x != nil {
		return x.Enabled
	}
	return false
}

func (x *ResourceOptions_StringsMapOption) GetValue() map[string]string {
	if x != nil {
		return x.Value
	}
	return nil
}

// A set of the caching response time parameters.
type ResourceOptions_CachingTimes struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Caching time for a response with codes 200, 206, 301, 302.
	// Responses with codes 4xx, 5xx will not be cached. Use `0s` disable to caching.
	// Use [custom_values] field to specify a custom caching time for a response with specific codes.
	SimpleValue int64 `protobuf:"varint,1,opt,name=simple_value,json=simpleValue,proto3" json:"simple_value,omitempty"`
	// Caching time for a response with specific codes. These settings have a higher priority than the value field.
	// Response code (`304`, `404` for example). Use `any` to specify caching time for all response codes.
	// Caching time in seconds (`0s`, `600s` for example). Use `0s` to disable caching for a specific response code.
	CustomValues map[string]int64 `protobuf:"bytes,2,rep,name=custom_values,json=customValues,proto3" json:"custom_values,omitempty" protobuf_key:"bytes,1,opt,name=key,proto3" protobuf_val:"varint,2,opt,name=value,proto3"`
}

func (x *ResourceOptions_CachingTimes) Reset() {
	*x = ResourceOptions_CachingTimes{}
	if protoimpl.UnsafeEnabled {
		mi := &file_yandex_cloud_cdn_v1_resource_proto_msgTypes[13]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ResourceOptions_CachingTimes) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ResourceOptions_CachingTimes) ProtoMessage() {}

func (x *ResourceOptions_CachingTimes) ProtoReflect() protoreflect.Message {
	mi := &file_yandex_cloud_cdn_v1_resource_proto_msgTypes[13]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ResourceOptions_CachingTimes.ProtoReflect.Descriptor instead.
func (*ResourceOptions_CachingTimes) Descriptor() ([]byte, []int) {
	return file_yandex_cloud_cdn_v1_resource_proto_rawDescGZIP(), []int{2, 5}
}

func (x *ResourceOptions_CachingTimes) GetSimpleValue() int64 {
	if x != nil {
		return x.SimpleValue
	}
	return 0
}

func (x *ResourceOptions_CachingTimes) GetCustomValues() map[string]int64 {
	if x != nil {
		return x.CustomValues
	}
	return nil
}

// A set of the edge cache parameters.
type ResourceOptions_EdgeCacheSettings struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// True - the option is enabled and its `values_variant` is applied to the resource.
	// False - the option is disabled and its default value is used for the resource.
	Enabled bool `protobuf:"varint,1,opt,name=enabled,proto3" json:"enabled,omitempty"`
	// Types that are assignable to ValuesVariant:
	//
	//	*ResourceOptions_EdgeCacheSettings_Value
	//	*ResourceOptions_EdgeCacheSettings_DefaultValue
	ValuesVariant isResourceOptions_EdgeCacheSettings_ValuesVariant `protobuf_oneof:"values_variant"`
}

func (x *ResourceOptions_EdgeCacheSettings) Reset() {
	*x = ResourceOptions_EdgeCacheSettings{}
	if protoimpl.UnsafeEnabled {
		mi := &file_yandex_cloud_cdn_v1_resource_proto_msgTypes[14]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ResourceOptions_EdgeCacheSettings) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ResourceOptions_EdgeCacheSettings) ProtoMessage() {}

func (x *ResourceOptions_EdgeCacheSettings) ProtoReflect() protoreflect.Message {
	mi := &file_yandex_cloud_cdn_v1_resource_proto_msgTypes[14]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ResourceOptions_EdgeCacheSettings.ProtoReflect.Descriptor instead.
func (*ResourceOptions_EdgeCacheSettings) Descriptor() ([]byte, []int) {
	return file_yandex_cloud_cdn_v1_resource_proto_rawDescGZIP(), []int{2, 6}
}

func (x *ResourceOptions_EdgeCacheSettings) GetEnabled() bool {
	if x != nil {
		return x.Enabled
	}
	return false
}

func (m *ResourceOptions_EdgeCacheSettings) GetValuesVariant() isResourceOptions_EdgeCacheSettings_ValuesVariant {
	if m != nil {
		return m.ValuesVariant
	}
	return nil
}

func (x *ResourceOptions_EdgeCacheSettings) GetValue() *ResourceOptions_CachingTimes {
	if x, ok := x.GetValuesVariant().(*ResourceOptions_EdgeCacheSettings_Value); ok {
		return x.Value
	}
	return nil
}

func (x *ResourceOptions_EdgeCacheSettings) GetDefaultValue() int64 {
	if x, ok := x.GetValuesVariant().(*ResourceOptions_EdgeCacheSettings_DefaultValue); ok {
		return x.DefaultValue
	}
	return 0
}

type isResourceOptions_EdgeCacheSettings_ValuesVariant interface {
	isResourceOptions_EdgeCacheSettings_ValuesVariant()
}

type ResourceOptions_EdgeCacheSettings_Value struct {
	// Value of the option.
	Value *ResourceOptions_CachingTimes `protobuf:"bytes,2,opt,name=value,proto3,oneof"`
}

type ResourceOptions_EdgeCacheSettings_DefaultValue struct {
	// Content will be cached according to origin cache settings.
	// The value applies for a response with codes 200, 201, 204, 206, 301, 302, 303, 304, 307, 308
	// if an origin server does not have caching HTTP headers.
	// Responses with other codes will not be cached.
	DefaultValue int64 `protobuf:"varint,3,opt,name=default_value,json=defaultValue,proto3,oneof"`
}

func (*ResourceOptions_EdgeCacheSettings_Value) isResourceOptions_EdgeCacheSettings_ValuesVariant() {}

func (*ResourceOptions_EdgeCacheSettings_DefaultValue) isResourceOptions_EdgeCacheSettings_ValuesVariant() {
}

// A set of the string variable map parameters.
type ResourceOptions_StringVariableMapOption struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// True - the option is enabled and its [value] is applied to the resource.
	// False - the option is disabled and its default value is used for the resource.
	Enabled bool `protobuf:"varint,1,opt,name=enabled,proto3" json:"enabled,omitempty"`
	// Value of the option.
	Value map[string]*ResourceOptions_StringVariableMapOption_OneofString `protobuf:"bytes,2,rep,name=value,proto3" json:"value,omitempty" protobuf_key:"bytes,1,opt,name=key,proto3" protobuf_val:"bytes,2,opt,name=value,proto3"`
}

func (x *ResourceOptions_StringVariableMapOption) Reset() {
	*x = ResourceOptions_StringVariableMapOption{}
	if protoimpl.UnsafeEnabled {
		mi := &file_yandex_cloud_cdn_v1_resource_proto_msgTypes[15]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ResourceOptions_StringVariableMapOption) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ResourceOptions_StringVariableMapOption) ProtoMessage() {}

func (x *ResourceOptions_StringVariableMapOption) ProtoReflect() protoreflect.Message {
	mi := &file_yandex_cloud_cdn_v1_resource_proto_msgTypes[15]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ResourceOptions_StringVariableMapOption.ProtoReflect.Descriptor instead.
func (*ResourceOptions_StringVariableMapOption) Descriptor() ([]byte, []int) {
	return file_yandex_cloud_cdn_v1_resource_proto_rawDescGZIP(), []int{2, 7}
}

func (x *ResourceOptions_StringVariableMapOption) GetEnabled() bool {
	if x != nil {
		return x.Enabled
	}
	return false
}

func (x *ResourceOptions_StringVariableMapOption) GetValue() map[string]*ResourceOptions_StringVariableMapOption_OneofString {
	if x != nil {
		return x.Value
	}
	return nil
}

// A set of the query parameters.
type ResourceOptions_QueryParamsOptions struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Types that are assignable to QueryParamsVariant:
	//
	//	*ResourceOptions_QueryParamsOptions_IgnoreQueryString
	//	*ResourceOptions_QueryParamsOptions_QueryParamsWhitelist
	//	*ResourceOptions_QueryParamsOptions_QueryParamsBlacklist
	QueryParamsVariant isResourceOptions_QueryParamsOptions_QueryParamsVariant `protobuf_oneof:"query_params_variant"`
}

func (x *ResourceOptions_QueryParamsOptions) Reset() {
	*x = ResourceOptions_QueryParamsOptions{}
	if protoimpl.UnsafeEnabled {
		mi := &file_yandex_cloud_cdn_v1_resource_proto_msgTypes[16]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ResourceOptions_QueryParamsOptions) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ResourceOptions_QueryParamsOptions) ProtoMessage() {}

func (x *ResourceOptions_QueryParamsOptions) ProtoReflect() protoreflect.Message {
	mi := &file_yandex_cloud_cdn_v1_resource_proto_msgTypes[16]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ResourceOptions_QueryParamsOptions.ProtoReflect.Descriptor instead.
func (*ResourceOptions_QueryParamsOptions) Descriptor() ([]byte, []int) {
	return file_yandex_cloud_cdn_v1_resource_proto_rawDescGZIP(), []int{2, 8}
}

func (m *ResourceOptions_QueryParamsOptions) GetQueryParamsVariant() isResourceOptions_QueryParamsOptions_QueryParamsVariant {
	if m != nil {
		return m.QueryParamsVariant
	}
	return nil
}

func (x *ResourceOptions_QueryParamsOptions) GetIgnoreQueryString() *ResourceOptions_BoolOption {
	if x, ok := x.GetQueryParamsVariant().(*ResourceOptions_QueryParamsOptions_IgnoreQueryString); ok {
		return x.IgnoreQueryString
	}
	return nil
}

func (x *ResourceOptions_QueryParamsOptions) GetQueryParamsWhitelist() *ResourceOptions_StringsListOption {
	if x, ok := x.GetQueryParamsVariant().(*ResourceOptions_QueryParamsOptions_QueryParamsWhitelist); ok {
		return x.QueryParamsWhitelist
	}
	return nil
}

func (x *ResourceOptions_QueryParamsOptions) GetQueryParamsBlacklist() *ResourceOptions_StringsListOption {
	if x, ok := x.GetQueryParamsVariant().(*ResourceOptions_QueryParamsOptions_QueryParamsBlacklist); ok {
		return x.QueryParamsBlacklist
	}
	return nil
}

type isResourceOptions_QueryParamsOptions_QueryParamsVariant interface {
	isResourceOptions_QueryParamsOptions_QueryParamsVariant()
}

type ResourceOptions_QueryParamsOptions_IgnoreQueryString struct {
	// Using [BoolOption]. Selected by default. Files with different query parameters are cached as objects with the same key regardless of the parameter value.
	IgnoreQueryString *ResourceOptions_BoolOption `protobuf:"bytes,1,opt,name=ignore_query_string,json=ignoreQueryString,proto3,oneof"`
}

type ResourceOptions_QueryParamsOptions_QueryParamsWhitelist struct {
	// Ignore All Except.
	// Files with the specified query parameters are cached as objects with different keys,
	// files with other parameters are cached as objects with the same key.
	QueryParamsWhitelist *ResourceOptions_StringsListOption `protobuf:"bytes,2,opt,name=query_params_whitelist,json=queryParamsWhitelist,proto3,oneof"`
}

type ResourceOptions_QueryParamsOptions_QueryParamsBlacklist struct {
	// Ignore only. Files with the specified query parameters are cached as objects with the same key,
	// files with other parameters are cached as objects with different keys.
	QueryParamsBlacklist *ResourceOptions_StringsListOption `protobuf:"bytes,3,opt,name=query_params_blacklist,json=queryParamsBlacklist,proto3,oneof"`
}

func (*ResourceOptions_QueryParamsOptions_IgnoreQueryString) isResourceOptions_QueryParamsOptions_QueryParamsVariant() {
}

func (*ResourceOptions_QueryParamsOptions_QueryParamsWhitelist) isResourceOptions_QueryParamsOptions_QueryParamsVariant() {
}

func (*ResourceOptions_QueryParamsOptions_QueryParamsBlacklist) isResourceOptions_QueryParamsOptions_QueryParamsVariant() {
}

// A set of the redirect parameters.
type ResourceOptions_RedirectOptions struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Types that are assignable to RedirectVariant:
	//
	//	*ResourceOptions_RedirectOptions_RedirectHttpToHttps
	//	*ResourceOptions_RedirectOptions_RedirectHttpsToHttp
	RedirectVariant isResourceOptions_RedirectOptions_RedirectVariant `protobuf_oneof:"redirect_variant"`
}

func (x *ResourceOptions_RedirectOptions) Reset() {
	*x = ResourceOptions_RedirectOptions{}
	if protoimpl.UnsafeEnabled {
		mi := &file_yandex_cloud_cdn_v1_resource_proto_msgTypes[17]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ResourceOptions_RedirectOptions) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ResourceOptions_RedirectOptions) ProtoMessage() {}

func (x *ResourceOptions_RedirectOptions) ProtoReflect() protoreflect.Message {
	mi := &file_yandex_cloud_cdn_v1_resource_proto_msgTypes[17]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ResourceOptions_RedirectOptions.ProtoReflect.Descriptor instead.
func (*ResourceOptions_RedirectOptions) Descriptor() ([]byte, []int) {
	return file_yandex_cloud_cdn_v1_resource_proto_rawDescGZIP(), []int{2, 9}
}

func (m *ResourceOptions_RedirectOptions) GetRedirectVariant() isResourceOptions_RedirectOptions_RedirectVariant {
	if m != nil {
		return m.RedirectVariant
	}
	return nil
}

func (x *ResourceOptions_RedirectOptions) GetRedirectHttpToHttps() *ResourceOptions_BoolOption {
	if x, ok := x.GetRedirectVariant().(*ResourceOptions_RedirectOptions_RedirectHttpToHttps); ok {
		return x.RedirectHttpToHttps
	}
	return nil
}

func (x *ResourceOptions_RedirectOptions) GetRedirectHttpsToHttp() *ResourceOptions_BoolOption {
	if x, ok := x.GetRedirectVariant().(*ResourceOptions_RedirectOptions_RedirectHttpsToHttp); ok {
		return x.RedirectHttpsToHttp
	}
	return nil
}

type isResourceOptions_RedirectOptions_RedirectVariant interface {
	isResourceOptions_RedirectOptions_RedirectVariant()
}

type ResourceOptions_RedirectOptions_RedirectHttpToHttps struct {
	// Using [BoolOption]. Set up a redirect from HTTPS to HTTP.
	RedirectHttpToHttps *ResourceOptions_BoolOption `protobuf:"bytes,1,opt,name=redirect_http_to_https,json=redirectHttpToHttps,proto3,oneof"`
}

type ResourceOptions_RedirectOptions_RedirectHttpsToHttp struct {
	// Using [BoolOption]. Set up a redirect from HTTP to HTTPS.
	RedirectHttpsToHttp *ResourceOptions_BoolOption `protobuf:"bytes,2,opt,name=redirect_https_to_http,json=redirectHttpsToHttp,proto3,oneof"`
}

func (*ResourceOptions_RedirectOptions_RedirectHttpToHttps) isResourceOptions_RedirectOptions_RedirectVariant() {
}

func (*ResourceOptions_RedirectOptions_RedirectHttpsToHttp) isResourceOptions_RedirectOptions_RedirectVariant() {
}

// A set of the host parameters.
type ResourceOptions_HostOptions struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Types that are assignable to HostVariant:
	//
	//	*ResourceOptions_HostOptions_Host
	//	*ResourceOptions_HostOptions_ForwardHostHeader
	HostVariant isResourceOptions_HostOptions_HostVariant `protobuf_oneof:"host_variant"`
}

func (x *ResourceOptions_HostOptions) Reset() {
	*x = ResourceOptions_HostOptions{}
	if protoimpl.UnsafeEnabled {
		mi := &file_yandex_cloud_cdn_v1_resource_proto_msgTypes[18]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ResourceOptions_HostOptions) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ResourceOptions_HostOptions) ProtoMessage() {}

func (x *ResourceOptions_HostOptions) ProtoReflect() protoreflect.Message {
	mi := &file_yandex_cloud_cdn_v1_resource_proto_msgTypes[18]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ResourceOptions_HostOptions.ProtoReflect.Descriptor instead.
func (*ResourceOptions_HostOptions) Descriptor() ([]byte, []int) {
	return file_yandex_cloud_cdn_v1_resource_proto_rawDescGZIP(), []int{2, 10}
}

func (m *ResourceOptions_HostOptions) GetHostVariant() isResourceOptions_HostOptions_HostVariant {
	if m != nil {
		return m.HostVariant
	}
	return nil
}

func (x *ResourceOptions_HostOptions) GetHost() *ResourceOptions_StringOption {
	if x, ok := x.GetHostVariant().(*ResourceOptions_HostOptions_Host); ok {
		return x.Host
	}
	return nil
}

func (x *ResourceOptions_HostOptions) GetForwardHostHeader() *ResourceOptions_BoolOption {
	if x, ok := x.GetHostVariant().(*ResourceOptions_HostOptions_ForwardHostHeader); ok {
		return x.ForwardHostHeader
	}
	return nil
}

type isResourceOptions_HostOptions_HostVariant interface {
	isResourceOptions_HostOptions_HostVariant()
}

type ResourceOptions_HostOptions_Host struct {
	// Custom value for the Host header.
	//
	// Your server must be able to process requests with the chosen header.
	//
	// Default value (if [StringOption.enabled] is `false`) is [Resource.cname].
	Host *ResourceOptions_StringOption `protobuf:"bytes,1,opt,name=host,proto3,oneof"`
}

type ResourceOptions_HostOptions_ForwardHostHeader struct {
	// Using [BoolOption]. Choose the Forward Host header option if is important to send in the request to the Origin
	// the same Host header as was sent in the request to CDN server.
	ForwardHostHeader *ResourceOptions_BoolOption `protobuf:"bytes,2,opt,name=forward_host_header,json=forwardHostHeader,proto3,oneof"`
}

func (*ResourceOptions_HostOptions_Host) isResourceOptions_HostOptions_HostVariant() {}

func (*ResourceOptions_HostOptions_ForwardHostHeader) isResourceOptions_HostOptions_HostVariant() {}

// A set of the compression variant parameters.
type ResourceOptions_CompressionOptions struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Types that are assignable to CompressionVariant:
	//
	//	*ResourceOptions_CompressionOptions_FetchCompressed
	//	*ResourceOptions_CompressionOptions_GzipOn
	//	*ResourceOptions_CompressionOptions_BrotliCompression
	CompressionVariant isResourceOptions_CompressionOptions_CompressionVariant `protobuf_oneof:"compression_variant"`
}

func (x *ResourceOptions_CompressionOptions) Reset() {
	*x = ResourceOptions_CompressionOptions{}
	if protoimpl.UnsafeEnabled {
		mi := &file_yandex_cloud_cdn_v1_resource_proto_msgTypes[19]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ResourceOptions_CompressionOptions) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ResourceOptions_CompressionOptions) ProtoMessage() {}

func (x *ResourceOptions_CompressionOptions) ProtoReflect() protoreflect.Message {
	mi := &file_yandex_cloud_cdn_v1_resource_proto_msgTypes[19]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ResourceOptions_CompressionOptions.ProtoReflect.Descriptor instead.
func (*ResourceOptions_CompressionOptions) Descriptor() ([]byte, []int) {
	return file_yandex_cloud_cdn_v1_resource_proto_rawDescGZIP(), []int{2, 11}
}

func (m *ResourceOptions_CompressionOptions) GetCompressionVariant() isResourceOptions_CompressionOptions_CompressionVariant {
	if m != nil {
		return m.CompressionVariant
	}
	return nil
}

func (x *ResourceOptions_CompressionOptions) GetFetchCompressed() *ResourceOptions_BoolOption {
	if x, ok := x.GetCompressionVariant().(*ResourceOptions_CompressionOptions_FetchCompressed); ok {
		return x.FetchCompressed
	}
	return nil
}

func (x *ResourceOptions_CompressionOptions) GetGzipOn() *ResourceOptions_BoolOption {
	if x, ok := x.GetCompressionVariant().(*ResourceOptions_CompressionOptions_GzipOn); ok {
		return x.GzipOn
	}
	return nil
}

func (x *ResourceOptions_CompressionOptions) GetBrotliCompression() *ResourceOptions_StringsListOption {
	if x, ok := x.GetCompressionVariant().(*ResourceOptions_CompressionOptions_BrotliCompression); ok {
		return x.BrotliCompression
	}
	return nil
}

type isResourceOptions_CompressionOptions_CompressionVariant interface {
	isResourceOptions_CompressionOptions_CompressionVariant()
}

type ResourceOptions_CompressionOptions_FetchCompressed struct {
	// The Fetch compressed option helps you to reduce
	// the bandwidth between origin and CDN servers.
	// Also, content delivery speed becomes higher because of reducing the time
	// for compressing files in a CDN.
	FetchCompressed *ResourceOptions_BoolOption `protobuf:"bytes,1,opt,name=fetch_compressed,json=fetchCompressed,proto3,oneof"`
}

type ResourceOptions_CompressionOptions_GzipOn struct {
	// Using [BoolOption]. GZip compression at CDN servers reduces file size by 70% and can be as high as 90%.
	GzipOn *ResourceOptions_BoolOption `protobuf:"bytes,2,opt,name=gzip_on,json=gzipOn,proto3,oneof"`
}

type ResourceOptions_CompressionOptions_BrotliCompression struct {
	// The option allows to compress content with brotli on the CDN's end.
	//
	// Compression is performed on the Origin Shielding. If a pre-cache server doesn't active for a resource, compression does not occur even if the option is enabled.
	//
	// Specify the content-type for each type of content you wish to have compressed. CDN servers will request only uncompressed content from the origin.
	BrotliCompression *ResourceOptions_StringsListOption `protobuf:"bytes,3,opt,name=brotli_compression,json=brotliCompression,proto3,oneof"`
}

func (*ResourceOptions_CompressionOptions_FetchCompressed) isResourceOptions_CompressionOptions_CompressionVariant() {
}

func (*ResourceOptions_CompressionOptions_GzipOn) isResourceOptions_CompressionOptions_CompressionVariant() {
}

func (*ResourceOptions_CompressionOptions_BrotliCompression) isResourceOptions_CompressionOptions_CompressionVariant() {
}

// An option for changing or redirecting query paths.
type ResourceOptions_RewriteOption struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// True - the option is enabled and its [flag] is applied to the resource.
	// False - the option is disabled and its default value of the [flag] is used for the resource.
	Enabled bool `protobuf:"varint,1,opt,name=enabled,proto3" json:"enabled,omitempty"`
	// Pattern for rewrite.
	//
	// The value must have the following format: `<source path> <destination path>`, where both paths are regular expressions which use at least one group. E.g., `/foo/(.*) /bar/$1`.
	Body string `protobuf:"bytes,2,opt,name=body,proto3" json:"body,omitempty"`
	// Break flag is applied to the option by default.
	// It is not shown in the field.
	Flag RewriteFlag `protobuf:"varint,3,opt,name=flag,proto3,enum=yandex.cloud.cdn.v1.RewriteFlag" json:"flag,omitempty"`
}

func (x *ResourceOptions_RewriteOption) Reset() {
	*x = ResourceOptions_RewriteOption{}
	if protoimpl.UnsafeEnabled {
		mi := &file_yandex_cloud_cdn_v1_resource_proto_msgTypes[20]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ResourceOptions_RewriteOption) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ResourceOptions_RewriteOption) ProtoMessage() {}

func (x *ResourceOptions_RewriteOption) ProtoReflect() protoreflect.Message {
	mi := &file_yandex_cloud_cdn_v1_resource_proto_msgTypes[20]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ResourceOptions_RewriteOption.ProtoReflect.Descriptor instead.
func (*ResourceOptions_RewriteOption) Descriptor() ([]byte, []int) {
	return file_yandex_cloud_cdn_v1_resource_proto_rawDescGZIP(), []int{2, 12}
}

func (x *ResourceOptions_RewriteOption) GetEnabled() bool {
	if x != nil {
		return x.Enabled
	}
	return false
}

func (x *ResourceOptions_RewriteOption) GetBody() string {
	if x != nil {
		return x.Body
	}
	return ""
}

func (x *ResourceOptions_RewriteOption) GetFlag() RewriteFlag {
	if x != nil {
		return x.Flag
	}
	return RewriteFlag_REWRITE_FLAG_UNSPECIFIED
}

type ResourceOptions_StringVariableMapOption_OneofString struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Types that are assignable to StringOption:
	//
	//	*ResourceOptions_StringVariableMapOption_OneofString_Value
	//	*ResourceOptions_StringVariableMapOption_OneofString_Values
	StringOption isResourceOptions_StringVariableMapOption_OneofString_StringOption `protobuf_oneof:"string_option"`
}

func (x *ResourceOptions_StringVariableMapOption_OneofString) Reset() {
	*x = ResourceOptions_StringVariableMapOption_OneofString{}
	if protoimpl.UnsafeEnabled {
		mi := &file_yandex_cloud_cdn_v1_resource_proto_msgTypes[23]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ResourceOptions_StringVariableMapOption_OneofString) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ResourceOptions_StringVariableMapOption_OneofString) ProtoMessage() {}

func (x *ResourceOptions_StringVariableMapOption_OneofString) ProtoReflect() protoreflect.Message {
	mi := &file_yandex_cloud_cdn_v1_resource_proto_msgTypes[23]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ResourceOptions_StringVariableMapOption_OneofString.ProtoReflect.Descriptor instead.
func (*ResourceOptions_StringVariableMapOption_OneofString) Descriptor() ([]byte, []int) {
	return file_yandex_cloud_cdn_v1_resource_proto_rawDescGZIP(), []int{2, 7, 0}
}

func (m *ResourceOptions_StringVariableMapOption_OneofString) GetStringOption() isResourceOptions_StringVariableMapOption_OneofString_StringOption {
	if m != nil {
		return m.StringOption
	}
	return nil
}

func (x *ResourceOptions_StringVariableMapOption_OneofString) GetValue() *ResourceOptions_StringOption {
	if x, ok := x.GetStringOption().(*ResourceOptions_StringVariableMapOption_OneofString_Value); ok {
		return x.Value
	}
	return nil
}

func (x *ResourceOptions_StringVariableMapOption_OneofString) GetValues() *ResourceOptions_StringsListOption {
	if x, ok := x.GetStringOption().(*ResourceOptions_StringVariableMapOption_OneofString_Values); ok {
		return x.Values
	}
	return nil
}

type isResourceOptions_StringVariableMapOption_OneofString_StringOption interface {
	isResourceOptions_StringVariableMapOption_OneofString_StringOption()
}

type ResourceOptions_StringVariableMapOption_OneofString_Value struct {
	// Using [StringOption] to set value.
	Value *ResourceOptions_StringOption `protobuf:"bytes,1,opt,name=value,proto3,oneof"`
}

type ResourceOptions_StringVariableMapOption_OneofString_Values struct {
	// Using [StringsListOption] to set values.
	Values *ResourceOptions_StringsListOption `protobuf:"bytes,2,opt,name=values,proto3,oneof"`
}

func (*ResourceOptions_StringVariableMapOption_OneofString_Value) isResourceOptions_StringVariableMapOption_OneofString_StringOption() {
}

func (*ResourceOptions_StringVariableMapOption_OneofString_Values) isResourceOptions_StringVariableMapOption_OneofString_StringOption() {
}

var File_yandex_cloud_cdn_v1_resource_proto protoreflect.FileDescriptor

var file_yandex_cloud_cdn_v1_resource_proto_rawDesc = []byte{
	0x0a, 0x22, 0x79, 0x61, 0x6e, 0x64, 0x65, 0x78, 0x2f, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2f, 0x63,
	0x64, 0x6e, 0x2f, 0x76, 0x31, 0x2f, 0x72, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x2e, 0x70,
	0x72, 0x6f, 0x74, 0x6f, 0x12, 0x13, 0x79, 0x61, 0x6e, 0x64, 0x65, 0x78, 0x2e, 0x63, 0x6c, 0x6f,
	0x75, 0x64, 0x2e, 0x63, 0x64, 0x6e, 0x2e, 0x76, 0x31, 0x1a, 0x1f, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2f, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2f, 0x74, 0x69, 0x6d, 0x65, 0x73,
	0x74, 0x61, 0x6d, 0x70, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x22, 0x2c, 0x0a, 0x12, 0x53, 0x65,
	0x63, 0x6f, 0x6e, 0x64, 0x61, 0x72, 0x79, 0x48, 0x6f, 0x73, 0x74, 0x6e, 0x61, 0x6d, 0x65, 0x73,
	0x12, 0x16, 0x0a, 0x06, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x73, 0x18, 0x01, 0x20, 0x03, 0x28, 0x09,
	0x52, 0x06, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x73, 0x22, 0xba, 0x05, 0x0a, 0x08, 0x52, 0x65, 0x73,
	0x6f, 0x75, 0x72, 0x63, 0x65, 0x12, 0x0e, 0x0a, 0x02, 0x69, 0x64, 0x18, 0x01, 0x20, 0x01, 0x28,
	0x09, 0x52, 0x02, 0x69, 0x64, 0x12, 0x1b, 0x0a, 0x09, 0x66, 0x6f, 0x6c, 0x64, 0x65, 0x72, 0x5f,
	0x69, 0x64, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x08, 0x66, 0x6f, 0x6c, 0x64, 0x65, 0x72,
	0x49, 0x64, 0x12, 0x14, 0x0a, 0x05, 0x63, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x03, 0x20, 0x01, 0x28,
	0x09, 0x52, 0x05, 0x63, 0x6e, 0x61, 0x6d, 0x65, 0x12, 0x39, 0x0a, 0x0a, 0x63, 0x72, 0x65, 0x61,
	0x74, 0x65, 0x64, 0x5f, 0x61, 0x74, 0x18, 0x04, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x54,
	0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x52, 0x09, 0x63, 0x72, 0x65, 0x61, 0x74, 0x65,
	0x64, 0x41, 0x74, 0x12, 0x39, 0x0a, 0x0a, 0x75, 0x70, 0x64, 0x61, 0x74, 0x65, 0x64, 0x5f, 0x61,
	0x74, 0x18, 0x05, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x54, 0x69, 0x6d, 0x65, 0x73, 0x74,
	0x61, 0x6d, 0x70, 0x52, 0x09, 0x75, 0x70, 0x64, 0x61, 0x74, 0x65, 0x64, 0x41, 0x74, 0x12, 0x16,
	0x0a, 0x06, 0x61, 0x63, 0x74, 0x69, 0x76, 0x65, 0x18, 0x06, 0x20, 0x01, 0x28, 0x08, 0x52, 0x06,
	0x61, 0x63, 0x74, 0x69, 0x76, 0x65, 0x12, 0x3e, 0x0a, 0x07, 0x6f, 0x70, 0x74, 0x69, 0x6f, 0x6e,
	0x73, 0x18, 0x07, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x24, 0x2e, 0x79, 0x61, 0x6e, 0x64, 0x65, 0x78,
	0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x63, 0x64, 0x6e, 0x2e, 0x76, 0x31, 0x2e, 0x52, 0x65,
	0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x4f, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x52, 0x07, 0x6f,
	0x70, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x12, 0x2f, 0x0a, 0x13, 0x73, 0x65, 0x63, 0x6f, 0x6e, 0x64,
	0x61, 0x72, 0x79, 0x5f, 0x68, 0x6f, 0x73, 0x74, 0x6e, 0x61, 0x6d, 0x65, 0x73, 0x18, 0x08, 0x20,
	0x03, 0x28, 0x09, 0x52, 0x12, 0x73, 0x65, 0x63, 0x6f, 0x6e, 0x64, 0x61, 0x72, 0x79, 0x48, 0x6f,
	0x73, 0x74, 0x6e, 0x61, 0x6d, 0x65, 0x73, 0x12, 0x26, 0x0a, 0x0f, 0x6f, 0x72, 0x69, 0x67, 0x69,
	0x6e, 0x5f, 0x67, 0x72, 0x6f, 0x75, 0x70, 0x5f, 0x69, 0x64, 0x18, 0x09, 0x20, 0x01, 0x28, 0x03,
	0x52, 0x0d, 0x6f, 0x72, 0x69, 0x67, 0x69, 0x6e, 0x47, 0x72, 0x6f, 0x75, 0x70, 0x49, 0x64, 0x12,
	0x2a, 0x0a, 0x11, 0x6f, 0x72, 0x69, 0x67, 0x69, 0x6e, 0x5f, 0x67, 0x72, 0x6f, 0x75, 0x70, 0x5f,
	0x6e, 0x61, 0x6d, 0x65, 0x18, 0x0a, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0f, 0x6f, 0x72, 0x69, 0x67,
	0x69, 0x6e, 0x47, 0x72, 0x6f, 0x75, 0x70, 0x4e, 0x61, 0x6d, 0x65, 0x12, 0x4c, 0x0a, 0x0f, 0x6f,
	0x72, 0x69, 0x67, 0x69, 0x6e, 0x5f, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x63, 0x6f, 0x6c, 0x18, 0x0b,
	0x20, 0x01, 0x28, 0x0e, 0x32, 0x23, 0x2e, 0x79, 0x61, 0x6e, 0x64, 0x65, 0x78, 0x2e, 0x63, 0x6c,
	0x6f, 0x75, 0x64, 0x2e, 0x63, 0x64, 0x6e, 0x2e, 0x76, 0x31, 0x2e, 0x4f, 0x72, 0x69, 0x67, 0x69,
	0x6e, 0x50, 0x72, 0x6f, 0x74, 0x6f, 0x63, 0x6f, 0x6c, 0x52, 0x0e, 0x6f, 0x72, 0x69, 0x67, 0x69,
	0x6e, 0x50, 0x72, 0x6f, 0x74, 0x6f, 0x63, 0x6f, 0x6c, 0x12, 0x4c, 0x0a, 0x0f, 0x73, 0x73, 0x6c,
	0x5f, 0x63, 0x65, 0x72, 0x74, 0x69, 0x66, 0x69, 0x63, 0x61, 0x74, 0x65, 0x18, 0x0c, 0x20, 0x01,
	0x28, 0x0b, 0x32, 0x23, 0x2e, 0x79, 0x61, 0x6e, 0x64, 0x65, 0x78, 0x2e, 0x63, 0x6c, 0x6f, 0x75,
	0x64, 0x2e, 0x63, 0x64, 0x6e, 0x2e, 0x76, 0x31, 0x2e, 0x53, 0x53, 0x4c, 0x43, 0x65, 0x72, 0x74,
	0x69, 0x66, 0x69, 0x63, 0x61, 0x74, 0x65, 0x52, 0x0e, 0x73, 0x73, 0x6c, 0x43, 0x65, 0x72, 0x74,
	0x69, 0x66, 0x69, 0x63, 0x61, 0x74, 0x65, 0x12, 0x41, 0x0a, 0x06, 0x6c, 0x61, 0x62, 0x65, 0x6c,
	0x73, 0x18, 0x0d, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x29, 0x2e, 0x79, 0x61, 0x6e, 0x64, 0x65, 0x78,
	0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x63, 0x64, 0x6e, 0x2e, 0x76, 0x31, 0x2e, 0x52, 0x65,
	0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x2e, 0x4c, 0x61, 0x62, 0x65, 0x6c, 0x73, 0x45, 0x6e, 0x74,
	0x72, 0x79, 0x52, 0x06, 0x6c, 0x61, 0x62, 0x65, 0x6c, 0x73, 0x1a, 0x39, 0x0a, 0x0b, 0x4c, 0x61,
	0x62, 0x65, 0x6c, 0x73, 0x45, 0x6e, 0x74, 0x72, 0x79, 0x12, 0x10, 0x0a, 0x03, 0x6b, 0x65, 0x79,
	0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x03, 0x6b, 0x65, 0x79, 0x12, 0x14, 0x0a, 0x05, 0x76,
	0x61, 0x6c, 0x75, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x05, 0x76, 0x61, 0x6c, 0x75,
	0x65, 0x3a, 0x02, 0x38, 0x01, 0x22, 0xb3, 0x22, 0x0a, 0x0f, 0x52, 0x65, 0x73, 0x6f, 0x75, 0x72,
	0x63, 0x65, 0x4f, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x12, 0x54, 0x0a, 0x0d, 0x64, 0x69, 0x73,
	0x61, 0x62, 0x6c, 0x65, 0x5f, 0x63, 0x61, 0x63, 0x68, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b,
	0x32, 0x2f, 0x2e, 0x79, 0x61, 0x6e, 0x64, 0x65, 0x78, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e,
	0x63, 0x64, 0x6e, 0x2e, 0x76, 0x31, 0x2e, 0x52, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x4f,
	0x70, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2e, 0x42, 0x6f, 0x6f, 0x6c, 0x4f, 0x70, 0x74, 0x69, 0x6f,
	0x6e, 0x52, 0x0c, 0x64, 0x69, 0x73, 0x61, 0x62, 0x6c, 0x65, 0x43, 0x61, 0x63, 0x68, 0x65, 0x12,
	0x66, 0x0a, 0x13, 0x65, 0x64, 0x67, 0x65, 0x5f, 0x63, 0x61, 0x63, 0x68, 0x65, 0x5f, 0x73, 0x65,
	0x74, 0x74, 0x69, 0x6e, 0x67, 0x73, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x36, 0x2e, 0x79,
	0x61, 0x6e, 0x64, 0x65, 0x78, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x63, 0x64, 0x6e, 0x2e,
	0x76, 0x31, 0x2e, 0x52, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x4f, 0x70, 0x74, 0x69, 0x6f,
	0x6e, 0x73, 0x2e, 0x45, 0x64, 0x67, 0x65, 0x43, 0x61, 0x63, 0x68, 0x65, 0x53, 0x65, 0x74, 0x74,
	0x69, 0x6e, 0x67, 0x73, 0x52, 0x11, 0x65, 0x64, 0x67, 0x65, 0x43, 0x61, 0x63, 0x68, 0x65, 0x53,
	0x65, 0x74, 0x74, 0x69, 0x6e, 0x67, 0x73, 0x12, 0x66, 0x0a, 0x16, 0x62, 0x72, 0x6f, 0x77, 0x73,
	0x65, 0x72, 0x5f, 0x63, 0x61, 0x63, 0x68, 0x65, 0x5f, 0x73, 0x65, 0x74, 0x74, 0x69, 0x6e, 0x67,
	0x73, 0x18, 0x03, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x30, 0x2e, 0x79, 0x61, 0x6e, 0x64, 0x65, 0x78,
	0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x63, 0x64, 0x6e, 0x2e, 0x76, 0x31, 0x2e, 0x52, 0x65,
	0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x4f, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2e, 0x49, 0x6e,
	0x74, 0x36, 0x34, 0x4f, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x52, 0x14, 0x62, 0x72, 0x6f, 0x77, 0x73,
	0x65, 0x72, 0x43, 0x61, 0x63, 0x68, 0x65, 0x53, 0x65, 0x74, 0x74, 0x69, 0x6e, 0x67, 0x73, 0x12,
	0x64, 0x0a, 0x12, 0x63, 0x61, 0x63, 0x68, 0x65, 0x5f, 0x68, 0x74, 0x74, 0x70, 0x5f, 0x68, 0x65,
	0x61, 0x64, 0x65, 0x72, 0x73, 0x18, 0x04, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x36, 0x2e, 0x79, 0x61,
	0x6e, 0x64, 0x65, 0x78, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x63, 0x64, 0x6e, 0x2e, 0x76,
	0x31, 0x2e, 0x52, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x4f, 0x70, 0x74, 0x69, 0x6f, 0x6e,
	0x73, 0x2e, 0x53, 0x74, 0x72, 0x69, 0x6e, 0x67, 0x73, 0x4c, 0x69, 0x73, 0x74, 0x4f, 0x70, 0x74,
	0x69, 0x6f, 0x6e, 0x52, 0x10, 0x63, 0x61, 0x63, 0x68, 0x65, 0x48, 0x74, 0x74, 0x70, 0x48, 0x65,
	0x61, 0x64, 0x65, 0x72, 0x73, 0x12, 0x69, 0x0a, 0x14, 0x71, 0x75, 0x65, 0x72, 0x79, 0x5f, 0x70,
	0x61, 0x72, 0x61, 0x6d, 0x73, 0x5f, 0x6f, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x18, 0x05, 0x20,
	0x01, 0x28, 0x0b, 0x32, 0x37, 0x2e, 0x79, 0x61, 0x6e, 0x64, 0x65, 0x78, 0x2e, 0x63, 0x6c, 0x6f,
	0x75, 0x64, 0x2e, 0x63, 0x64, 0x6e, 0x2e, 0x76, 0x31, 0x2e, 0x52, 0x65, 0x73, 0x6f, 0x75, 0x72,
	0x63, 0x65, 0x4f, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2e, 0x51, 0x75, 0x65, 0x72, 0x79, 0x50,
	0x61, 0x72, 0x61, 0x6d, 0x73, 0x4f, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x52, 0x12, 0x71, 0x75,
	0x65, 0x72, 0x79, 0x50, 0x61, 0x72, 0x61, 0x6d, 0x73, 0x4f, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x73,
	0x12, 0x45, 0x0a, 0x05, 0x73, 0x6c, 0x69, 0x63, 0x65, 0x18, 0x06, 0x20, 0x01, 0x28, 0x0b, 0x32,
	0x2f, 0x2e, 0x79, 0x61, 0x6e, 0x64, 0x65, 0x78, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x63,
	0x64, 0x6e, 0x2e, 0x76, 0x31, 0x2e, 0x52, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x4f, 0x70,
	0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2e, 0x42, 0x6f, 0x6f, 0x6c, 0x4f, 0x70, 0x74, 0x69, 0x6f, 0x6e,
	0x52, 0x05, 0x73, 0x6c, 0x69, 0x63, 0x65, 0x12, 0x68, 0x0a, 0x13, 0x63, 0x6f, 0x6d, 0x70, 0x72,
	0x65, 0x73, 0x73, 0x69, 0x6f, 0x6e, 0x5f, 0x6f, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x18, 0x07,
	0x20, 0x01, 0x28, 0x0b, 0x32, 0x37, 0x2e, 0x79, 0x61, 0x6e, 0x64, 0x65, 0x78, 0x2e, 0x63, 0x6c,
	0x6f, 0x75, 0x64, 0x2e, 0x63, 0x64, 0x6e, 0x2e, 0x76, 0x31, 0x2e, 0x52, 0x65, 0x73, 0x6f, 0x75,
	0x72, 0x63, 0x65, 0x4f, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2e, 0x43, 0x6f, 0x6d, 0x70, 0x72,
	0x65, 0x73, 0x73, 0x69, 0x6f, 0x6e, 0x4f, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x52, 0x12, 0x63,
	0x6f, 0x6d, 0x70, 0x72, 0x65, 0x73, 0x73, 0x69, 0x6f, 0x6e, 0x4f, 0x70, 0x74, 0x69, 0x6f, 0x6e,
	0x73, 0x12, 0x5f, 0x0a, 0x10, 0x72, 0x65, 0x64, 0x69, 0x72, 0x65, 0x63, 0x74, 0x5f, 0x6f, 0x70,
	0x74, 0x69, 0x6f, 0x6e, 0x73, 0x18, 0x08, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x34, 0x2e, 0x79, 0x61,
	0x6e, 0x64, 0x65, 0x78, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x63, 0x64, 0x6e, 0x2e, 0x76,
	0x31, 0x2e, 0x52, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x4f, 0x70, 0x74, 0x69, 0x6f, 0x6e,
	0x73, 0x2e, 0x52, 0x65, 0x64, 0x69, 0x72, 0x65, 0x63, 0x74, 0x4f, 0x70, 0x74, 0x69, 0x6f, 0x6e,
	0x73, 0x52, 0x0f, 0x72, 0x65, 0x64, 0x69, 0x72, 0x65, 0x63, 0x74, 0x4f, 0x70, 0x74, 0x69, 0x6f,
	0x6e, 0x73, 0x12, 0x53, 0x0a, 0x0c, 0x68, 0x6f, 0x73, 0x74, 0x5f, 0x6f, 0x70, 0x74, 0x69, 0x6f,
	0x6e, 0x73, 0x18, 0x09, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x30, 0x2e, 0x79, 0x61, 0x6e, 0x64, 0x65,
	0x78, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x63, 0x64, 0x6e, 0x2e, 0x76, 0x31, 0x2e, 0x52,
	0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x4f, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2e, 0x48,
	0x6f, 0x73, 0x74, 0x4f, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x52, 0x0b, 0x68, 0x6f, 0x73, 0x74,
	0x4f, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x12, 0x5c, 0x0a, 0x0e, 0x73, 0x74, 0x61, 0x74, 0x69,
	0x63, 0x5f, 0x68, 0x65, 0x61, 0x64, 0x65, 0x72, 0x73, 0x18, 0x0a, 0x20, 0x01, 0x28, 0x0b, 0x32,
	0x35, 0x2e, 0x79, 0x61, 0x6e, 0x64, 0x65, 0x78, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x63,
	0x64, 0x6e, 0x2e, 0x76, 0x31, 0x2e, 0x52, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x4f, 0x70,
	0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2e, 0x53, 0x74, 0x72, 0x69, 0x6e, 0x67, 0x73, 0x4d, 0x61, 0x70,
	0x4f, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x52, 0x0d, 0x73, 0x74, 0x61, 0x74, 0x69, 0x63, 0x48, 0x65,
	0x61, 0x64, 0x65, 0x72, 0x73, 0x12, 0x4a, 0x0a, 0x04, 0x63, 0x6f, 0x72, 0x73, 0x18, 0x0b, 0x20,
	0x01, 0x28, 0x0b, 0x32, 0x36, 0x2e, 0x79, 0x61, 0x6e, 0x64, 0x65, 0x78, 0x2e, 0x63, 0x6c, 0x6f,
	0x75, 0x64, 0x2e, 0x63, 0x64, 0x6e, 0x2e, 0x76, 0x31, 0x2e, 0x52, 0x65, 0x73, 0x6f, 0x75, 0x72,
	0x63, 0x65, 0x4f, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2e, 0x53, 0x74, 0x72, 0x69, 0x6e, 0x67,
	0x73, 0x4c, 0x69, 0x73, 0x74, 0x4f, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x52, 0x04, 0x63, 0x6f, 0x72,
	0x73, 0x12, 0x4c, 0x0a, 0x05, 0x73, 0x74, 0x61, 0x6c, 0x65, 0x18, 0x0c, 0x20, 0x01, 0x28, 0x0b,
	0x32, 0x36, 0x2e, 0x79, 0x61, 0x6e, 0x64, 0x65, 0x78, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e,
	0x63, 0x64, 0x6e, 0x2e, 0x76, 0x31, 0x2e, 0x52, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x4f,
	0x70, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2e, 0x53, 0x74, 0x72, 0x69, 0x6e, 0x67, 0x73, 0x4c, 0x69,
	0x73, 0x74, 0x4f, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x52, 0x05, 0x73, 0x74, 0x61, 0x6c, 0x65, 0x12,
	0x68, 0x0a, 0x14, 0x61, 0x6c, 0x6c, 0x6f, 0x77, 0x65, 0x64, 0x5f, 0x68, 0x74, 0x74, 0x70, 0x5f,
	0x6d, 0x65, 0x74, 0x68, 0x6f, 0x64, 0x73, 0x18, 0x0d, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x36, 0x2e,
	0x79, 0x61, 0x6e, 0x64, 0x65, 0x78, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x63, 0x64, 0x6e,
	0x2e, 0x76, 0x31, 0x2e, 0x52, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x4f, 0x70, 0x74, 0x69,
	0x6f, 0x6e, 0x73, 0x2e, 0x53, 0x74, 0x72, 0x69, 0x6e, 0x67, 0x73, 0x4c, 0x69, 0x73, 0x74, 0x4f,
	0x70, 0x74, 0x69, 0x6f, 0x6e, 0x52, 0x12, 0x61, 0x6c, 0x6c, 0x6f, 0x77, 0x65, 0x64, 0x48, 0x74,
	0x74, 0x70, 0x4d, 0x65, 0x74, 0x68, 0x6f, 0x64, 0x73, 0x12, 0x66, 0x0a, 0x17, 0x70, 0x72, 0x6f,
	0x78, 0x79, 0x5f, 0x63, 0x61, 0x63, 0x68, 0x65, 0x5f, 0x6d, 0x65, 0x74, 0x68, 0x6f, 0x64, 0x73,
	0x5f, 0x73, 0x65, 0x74, 0x18, 0x0e, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x2f, 0x2e, 0x79, 0x61, 0x6e,
	0x64, 0x65, 0x78, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x63, 0x64, 0x6e, 0x2e, 0x76, 0x31,
	0x2e, 0x52, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x4f, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x73,
	0x2e, 0x42, 0x6f, 0x6f, 0x6c, 0x4f, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x52, 0x14, 0x70, 0x72, 0x6f,
	0x78, 0x79, 0x43, 0x61, 0x63, 0x68, 0x65, 0x4d, 0x65, 0x74, 0x68, 0x6f, 0x64, 0x73, 0x53, 0x65,
	0x74, 0x12, 0x6c, 0x0a, 0x1a, 0x64, 0x69, 0x73, 0x61, 0x62, 0x6c, 0x65, 0x5f, 0x70, 0x72, 0x6f,
	0x78, 0x79, 0x5f, 0x66, 0x6f, 0x72, 0x63, 0x65, 0x5f, 0x72, 0x61, 0x6e, 0x67, 0x65, 0x73, 0x18,
	0x0f, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x2f, 0x2e, 0x79, 0x61, 0x6e, 0x64, 0x65, 0x78, 0x2e, 0x63,
	0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x63, 0x64, 0x6e, 0x2e, 0x76, 0x31, 0x2e, 0x52, 0x65, 0x73, 0x6f,
	0x75, 0x72, 0x63, 0x65, 0x4f, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2e, 0x42, 0x6f, 0x6f, 0x6c,
	0x4f, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x52, 0x17, 0x64, 0x69, 0x73, 0x61, 0x62, 0x6c, 0x65, 0x50,
	0x72, 0x6f, 0x78, 0x79, 0x46, 0x6f, 0x72, 0x63, 0x65, 0x52, 0x61, 0x6e, 0x67, 0x65, 0x73, 0x12,
	0x6b, 0x0a, 0x16, 0x73, 0x74, 0x61, 0x74, 0x69, 0x63, 0x5f, 0x72, 0x65, 0x71, 0x75, 0x65, 0x73,
	0x74, 0x5f, 0x68, 0x65, 0x61, 0x64, 0x65, 0x72, 0x73, 0x18, 0x10, 0x20, 0x01, 0x28, 0x0b, 0x32,
	0x35, 0x2e, 0x79, 0x61, 0x6e, 0x64, 0x65, 0x78, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x63,
	0x64, 0x6e, 0x2e, 0x76, 0x31, 0x2e, 0x52, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x4f, 0x70,
	0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2e, 0x53, 0x74, 0x72, 0x69, 0x6e, 0x67, 0x73, 0x4d, 0x61, 0x70,
	0x4f, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x52, 0x14, 0x73, 0x74, 0x61, 0x74, 0x69, 0x63, 0x52, 0x65,
	0x71, 0x75, 0x65, 0x73, 0x74, 0x48, 0x65, 0x61, 0x64, 0x65, 0x72, 0x73, 0x12, 0x5f, 0x0a, 0x12,
	0x63, 0x75, 0x73, 0x74, 0x6f, 0x6d, 0x5f, 0x73, 0x65, 0x72, 0x76, 0x65, 0x72, 0x5f, 0x6e, 0x61,
	0x6d, 0x65, 0x18, 0x11, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x31, 0x2e, 0x79, 0x61, 0x6e, 0x64, 0x65,
	0x78, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x63, 0x64, 0x6e, 0x2e, 0x76, 0x31, 0x2e, 0x52,
	0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x4f, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2e, 0x53,
	0x74, 0x72, 0x69, 0x6e, 0x67, 0x4f, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x52, 0x10, 0x63, 0x75, 0x73,
	0x74, 0x6f, 0x6d, 0x53, 0x65, 0x72, 0x76, 0x65, 0x72, 0x4e, 0x61, 0x6d, 0x65, 0x12, 0x54, 0x0a,
	0x0d, 0x69, 0x67, 0x6e, 0x6f, 0x72, 0x65, 0x5f, 0x63, 0x6f, 0x6f, 0x6b, 0x69, 0x65, 0x18, 0x12,
	0x20, 0x01, 0x28, 0x0b, 0x32, 0x2f, 0x2e, 0x79, 0x61, 0x6e, 0x64, 0x65, 0x78, 0x2e, 0x63, 0x6c,
	0x6f, 0x75, 0x64, 0x2e, 0x63, 0x64, 0x6e, 0x2e, 0x76, 0x31, 0x2e, 0x52, 0x65, 0x73, 0x6f, 0x75,
	0x72, 0x63, 0x65, 0x4f, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2e, 0x42, 0x6f, 0x6f, 0x6c, 0x4f,
	0x70, 0x74, 0x69, 0x6f, 0x6e, 0x52, 0x0c, 0x69, 0x67, 0x6e, 0x6f, 0x72, 0x65, 0x43, 0x6f, 0x6f,
	0x6b, 0x69, 0x65, 0x12, 0x4c, 0x0a, 0x07, 0x72, 0x65, 0x77, 0x72, 0x69, 0x74, 0x65, 0x18, 0x13,
	0x20, 0x01, 0x28, 0x0b, 0x32, 0x32, 0x2e, 0x79, 0x61, 0x6e, 0x64, 0x65, 0x78, 0x2e, 0x63, 0x6c,
	0x6f, 0x75, 0x64, 0x2e, 0x63, 0x64, 0x6e, 0x2e, 0x76, 0x31, 0x2e, 0x52, 0x65, 0x73, 0x6f, 0x75,
	0x72, 0x63, 0x65, 0x4f, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2e, 0x52, 0x65, 0x77, 0x72, 0x69,
	0x74, 0x65, 0x4f, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x52, 0x07, 0x72, 0x65, 0x77, 0x72, 0x69, 0x74,
	0x65, 0x1a, 0x3c, 0x0a, 0x0a, 0x42, 0x6f, 0x6f, 0x6c, 0x4f, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x12,
	0x18, 0x0a, 0x07, 0x65, 0x6e, 0x61, 0x62, 0x6c, 0x65, 0x64, 0x18, 0x01, 0x20, 0x01, 0x28, 0x08,
	0x52, 0x07, 0x65, 0x6e, 0x61, 0x62, 0x6c, 0x65, 0x64, 0x12, 0x14, 0x0a, 0x05, 0x76, 0x61, 0x6c,
	0x75, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x08, 0x52, 0x05, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x1a,
	0x3e, 0x0a, 0x0c, 0x53, 0x74, 0x72, 0x69, 0x6e, 0x67, 0x4f, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x12,
	0x18, 0x0a, 0x07, 0x65, 0x6e, 0x61, 0x62, 0x6c, 0x65, 0x64, 0x18, 0x01, 0x20, 0x01, 0x28, 0x08,
	0x52, 0x07, 0x65, 0x6e, 0x61, 0x62, 0x6c, 0x65, 0x64, 0x12, 0x14, 0x0a, 0x05, 0x76, 0x61, 0x6c,
	0x75, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x05, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x1a,
	0x3d, 0x0a, 0x0b, 0x49, 0x6e, 0x74, 0x36, 0x34, 0x4f, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x18,
	0x0a, 0x07, 0x65, 0x6e, 0x61, 0x62, 0x6c, 0x65, 0x64, 0x18, 0x01, 0x20, 0x01, 0x28, 0x08, 0x52,
	0x07, 0x65, 0x6e, 0x61, 0x62, 0x6c, 0x65, 0x64, 0x12, 0x14, 0x0a, 0x05, 0x76, 0x61, 0x6c, 0x75,
	0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x03, 0x52, 0x05, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x1a, 0x43,
	0x0a, 0x11, 0x53, 0x74, 0x72, 0x69, 0x6e, 0x67, 0x73, 0x4c, 0x69, 0x73, 0x74, 0x4f, 0x70, 0x74,
	0x69, 0x6f, 0x6e, 0x12, 0x18, 0x0a, 0x07, 0x65, 0x6e, 0x61, 0x62, 0x6c, 0x65, 0x64, 0x18, 0x01,
	0x20, 0x01, 0x28, 0x08, 0x52, 0x07, 0x65, 0x6e, 0x61, 0x62, 0x6c, 0x65, 0x64, 0x12, 0x14, 0x0a,
	0x05, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x18, 0x02, 0x20, 0x03, 0x28, 0x09, 0x52, 0x05, 0x76, 0x61,
	0x6c, 0x75, 0x65, 0x1a, 0xbe, 0x01, 0x0a, 0x10, 0x53, 0x74, 0x72, 0x69, 0x6e, 0x67, 0x73, 0x4d,
	0x61, 0x70, 0x4f, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x18, 0x0a, 0x07, 0x65, 0x6e, 0x61, 0x62,
	0x6c, 0x65, 0x64, 0x18, 0x01, 0x20, 0x01, 0x28, 0x08, 0x52, 0x07, 0x65, 0x6e, 0x61, 0x62, 0x6c,
	0x65, 0x64, 0x12, 0x56, 0x0a, 0x05, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x18, 0x02, 0x20, 0x03, 0x28,
	0x0b, 0x32, 0x40, 0x2e, 0x79, 0x61, 0x6e, 0x64, 0x65, 0x78, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64,
	0x2e, 0x63, 0x64, 0x6e, 0x2e, 0x76, 0x31, 0x2e, 0x52, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65,
	0x4f, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2e, 0x53, 0x74, 0x72, 0x69, 0x6e, 0x67, 0x73, 0x4d,
	0x61, 0x70, 0x4f, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x56, 0x61, 0x6c, 0x75, 0x65, 0x45, 0x6e,
	0x74, 0x72, 0x79, 0x52, 0x05, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x1a, 0x38, 0x0a, 0x0a, 0x56, 0x61,
	0x6c, 0x75, 0x65, 0x45, 0x6e, 0x74, 0x72, 0x79, 0x12, 0x10, 0x0a, 0x03, 0x6b, 0x65, 0x79, 0x18,
	0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x03, 0x6b, 0x65, 0x79, 0x12, 0x14, 0x0a, 0x05, 0x76, 0x61,
	0x6c, 0x75, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x05, 0x76, 0x61, 0x6c, 0x75, 0x65,
	0x3a, 0x02, 0x38, 0x01, 0x1a, 0xdc, 0x01, 0x0a, 0x0c, 0x43, 0x61, 0x63, 0x68, 0x69, 0x6e, 0x67,
	0x54, 0x69, 0x6d, 0x65, 0x73, 0x12, 0x21, 0x0a, 0x0c, 0x73, 0x69, 0x6d, 0x70, 0x6c, 0x65, 0x5f,
	0x76, 0x61, 0x6c, 0x75, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x03, 0x52, 0x0b, 0x73, 0x69, 0x6d,
	0x70, 0x6c, 0x65, 0x56, 0x61, 0x6c, 0x75, 0x65, 0x12, 0x68, 0x0a, 0x0d, 0x63, 0x75, 0x73, 0x74,
	0x6f, 0x6d, 0x5f, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x73, 0x18, 0x02, 0x20, 0x03, 0x28, 0x0b, 0x32,
	0x43, 0x2e, 0x79, 0x61, 0x6e, 0x64, 0x65, 0x78, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x63,
	0x64, 0x6e, 0x2e, 0x76, 0x31, 0x2e, 0x52, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x4f, 0x70,
	0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2e, 0x43, 0x61, 0x63, 0x68, 0x69, 0x6e, 0x67, 0x54, 0x69, 0x6d,
	0x65, 0x73, 0x2e, 0x43, 0x75, 0x73, 0x74, 0x6f, 0x6d, 0x56, 0x61, 0x6c, 0x75, 0x65, 0x73, 0x45,
	0x6e, 0x74, 0x72, 0x79, 0x52, 0x0c, 0x63, 0x75, 0x73, 0x74, 0x6f, 0x6d, 0x56, 0x61, 0x6c, 0x75,
	0x65, 0x73, 0x1a, 0x3f, 0x0a, 0x11, 0x43, 0x75, 0x73, 0x74, 0x6f, 0x6d, 0x56, 0x61, 0x6c, 0x75,
	0x65, 0x73, 0x45, 0x6e, 0x74, 0x72, 0x79, 0x12, 0x10, 0x0a, 0x03, 0x6b, 0x65, 0x79, 0x18, 0x01,
	0x20, 0x01, 0x28, 0x09, 0x52, 0x03, 0x6b, 0x65, 0x79, 0x12, 0x14, 0x0a, 0x05, 0x76, 0x61, 0x6c,
	0x75, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x03, 0x52, 0x05, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x3a,
	0x02, 0x38, 0x01, 0x1a, 0xb1, 0x01, 0x0a, 0x11, 0x45, 0x64, 0x67, 0x65, 0x43, 0x61, 0x63, 0x68,
	0x65, 0x53, 0x65, 0x74, 0x74, 0x69, 0x6e, 0x67, 0x73, 0x12, 0x18, 0x0a, 0x07, 0x65, 0x6e, 0x61,
	0x62, 0x6c, 0x65, 0x64, 0x18, 0x01, 0x20, 0x01, 0x28, 0x08, 0x52, 0x07, 0x65, 0x6e, 0x61, 0x62,
	0x6c, 0x65, 0x64, 0x12, 0x49, 0x0a, 0x05, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x18, 0x02, 0x20, 0x01,
	0x28, 0x0b, 0x32, 0x31, 0x2e, 0x79, 0x61, 0x6e, 0x64, 0x65, 0x78, 0x2e, 0x63, 0x6c, 0x6f, 0x75,
	0x64, 0x2e, 0x63, 0x64, 0x6e, 0x2e, 0x76, 0x31, 0x2e, 0x52, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63,
	0x65, 0x4f, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2e, 0x43, 0x61, 0x63, 0x68, 0x69, 0x6e, 0x67,
	0x54, 0x69, 0x6d, 0x65, 0x73, 0x48, 0x00, 0x52, 0x05, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x12, 0x25,
	0x0a, 0x0d, 0x64, 0x65, 0x66, 0x61, 0x75, 0x6c, 0x74, 0x5f, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x18,
	0x03, 0x20, 0x01, 0x28, 0x03, 0x48, 0x00, 0x52, 0x0c, 0x64, 0x65, 0x66, 0x61, 0x75, 0x6c, 0x74,
	0x56, 0x61, 0x6c, 0x75, 0x65, 0x42, 0x10, 0x0a, 0x0e, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x73, 0x5f,
	0x76, 0x61, 0x72, 0x69, 0x61, 0x6e, 0x74, 0x1a, 0xd5, 0x03, 0x0a, 0x17, 0x53, 0x74, 0x72, 0x69,
	0x6e, 0x67, 0x56, 0x61, 0x72, 0x69, 0x61, 0x62, 0x6c, 0x65, 0x4d, 0x61, 0x70, 0x4f, 0x70, 0x74,
	0x69, 0x6f, 0x6e, 0x12, 0x18, 0x0a, 0x07, 0x65, 0x6e, 0x61, 0x62, 0x6c, 0x65, 0x64, 0x18, 0x01,
	0x20, 0x01, 0x28, 0x08, 0x52, 0x07, 0x65, 0x6e, 0x61, 0x62, 0x6c, 0x65, 0x64, 0x12, 0x5d, 0x0a,
	0x05, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x18, 0x02, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x47, 0x2e, 0x79,
	0x61, 0x6e, 0x64, 0x65, 0x78, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x63, 0x64, 0x6e, 0x2e,
	0x76, 0x31, 0x2e, 0x52, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x4f, 0x70, 0x74, 0x69, 0x6f,
	0x6e, 0x73, 0x2e, 0x53, 0x74, 0x72, 0x69, 0x6e, 0x67, 0x56, 0x61, 0x72, 0x69, 0x61, 0x62, 0x6c,
	0x65, 0x4d, 0x61, 0x70, 0x4f, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x56, 0x61, 0x6c, 0x75, 0x65,
	0x45, 0x6e, 0x74, 0x72, 0x79, 0x52, 0x05, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x1a, 0xbb, 0x01, 0x0a,
	0x0b, 0x4f, 0x6e, 0x65, 0x6f, 0x66, 0x53, 0x74, 0x72, 0x69, 0x6e, 0x67, 0x12, 0x49, 0x0a, 0x05,
	0x76, 0x61, 0x6c, 0x75, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x31, 0x2e, 0x79, 0x61,
	0x6e, 0x64, 0x65, 0x78, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x63, 0x64, 0x6e, 0x2e, 0x76,
	0x31, 0x2e, 0x52, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x4f, 0x70, 0x74, 0x69, 0x6f, 0x6e,
	0x73, 0x2e, 0x53, 0x74, 0x72, 0x69, 0x6e, 0x67, 0x4f, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x48, 0x00,
	0x52, 0x05, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x12, 0x50, 0x0a, 0x06, 0x76, 0x61, 0x6c, 0x75, 0x65,
	0x73, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x36, 0x2e, 0x79, 0x61, 0x6e, 0x64, 0x65, 0x78,
	0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x63, 0x64, 0x6e, 0x2e, 0x76, 0x31, 0x2e, 0x52, 0x65,
	0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x4f, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2e, 0x53, 0x74,
	0x72, 0x69, 0x6e, 0x67, 0x73, 0x4c, 0x69, 0x73, 0x74, 0x4f, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x48,
	0x00, 0x52, 0x06, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x73, 0x42, 0x0f, 0x0a, 0x0d, 0x73, 0x74, 0x72,
	0x69, 0x6e, 0x67, 0x5f, 0x6f, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x1a, 0x82, 0x01, 0x0a, 0x0a, 0x56,
	0x61, 0x6c, 0x75, 0x65, 0x45, 0x6e, 0x74, 0x72, 0x79, 0x12, 0x10, 0x0a, 0x03, 0x6b, 0x65, 0x79,
	0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x03, 0x6b, 0x65, 0x79, 0x12, 0x5e, 0x0a, 0x05, 0x76,
	0x61, 0x6c, 0x75, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x48, 0x2e, 0x79, 0x61, 0x6e,
	0x64, 0x65, 0x78, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x63, 0x64, 0x6e, 0x2e, 0x76, 0x31,
	0x2e, 0x52, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x4f, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x73,
	0x2e, 0x53, 0x74, 0x72, 0x69, 0x6e, 0x67, 0x56, 0x61, 0x72, 0x69, 0x61, 0x62, 0x6c, 0x65, 0x4d,
	0x61, 0x70, 0x4f, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x4f, 0x6e, 0x65, 0x6f, 0x66, 0x53, 0x74,
	0x72, 0x69, 0x6e, 0x67, 0x52, 0x05, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x3a, 0x02, 0x38, 0x01, 0x1a,
	0xef, 0x02, 0x0a, 0x12, 0x51, 0x75, 0x65, 0x72, 0x79, 0x50, 0x61, 0x72, 0x61, 0x6d, 0x73, 0x4f,
	0x70, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x12, 0x61, 0x0a, 0x13, 0x69, 0x67, 0x6e, 0x6f, 0x72, 0x65,
	0x5f, 0x71, 0x75, 0x65, 0x72, 0x79, 0x5f, 0x73, 0x74, 0x72, 0x69, 0x6e, 0x67, 0x18, 0x01, 0x20,
	0x01, 0x28, 0x0b, 0x32, 0x2f, 0x2e, 0x79, 0x61, 0x6e, 0x64, 0x65, 0x78, 0x2e, 0x63, 0x6c, 0x6f,
	0x75, 0x64, 0x2e, 0x63, 0x64, 0x6e, 0x2e, 0x76, 0x31, 0x2e, 0x52, 0x65, 0x73, 0x6f, 0x75, 0x72,
	0x63, 0x65, 0x4f, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2e, 0x42, 0x6f, 0x6f, 0x6c, 0x4f, 0x70,
	0x74, 0x69, 0x6f, 0x6e, 0x48, 0x00, 0x52, 0x11, 0x69, 0x67, 0x6e, 0x6f, 0x72, 0x65, 0x51, 0x75,
	0x65, 0x72, 0x79, 0x53, 0x74, 0x72, 0x69, 0x6e, 0x67, 0x12, 0x6e, 0x0a, 0x16, 0x71, 0x75, 0x65,
	0x72, 0x79, 0x5f, 0x70, 0x61, 0x72, 0x61, 0x6d, 0x73, 0x5f, 0x77, 0x68, 0x69, 0x74, 0x65, 0x6c,
	0x69, 0x73, 0x74, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x36, 0x2e, 0x79, 0x61, 0x6e, 0x64,
	0x65, 0x78, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x63, 0x64, 0x6e, 0x2e, 0x76, 0x31, 0x2e,
	0x52, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x4f, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2e,
	0x53, 0x74, 0x72, 0x69, 0x6e, 0x67, 0x73, 0x4c, 0x69, 0x73, 0x74, 0x4f, 0x70, 0x74, 0x69, 0x6f,
	0x6e, 0x48, 0x00, 0x52, 0x14, 0x71, 0x75, 0x65, 0x72, 0x79, 0x50, 0x61, 0x72, 0x61, 0x6d, 0x73,
	0x57, 0x68, 0x69, 0x74, 0x65, 0x6c, 0x69, 0x73, 0x74, 0x12, 0x6e, 0x0a, 0x16, 0x71, 0x75, 0x65,
	0x72, 0x79, 0x5f, 0x70, 0x61, 0x72, 0x61, 0x6d, 0x73, 0x5f, 0x62, 0x6c, 0x61, 0x63, 0x6b, 0x6c,
	0x69, 0x73, 0x74, 0x18, 0x03, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x36, 0x2e, 0x79, 0x61, 0x6e, 0x64,
	0x65, 0x78, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x63, 0x64, 0x6e, 0x2e, 0x76, 0x31, 0x2e,
	0x52, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x4f, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2e,
	0x53, 0x74, 0x72, 0x69, 0x6e, 0x67, 0x73, 0x4c, 0x69, 0x73, 0x74, 0x4f, 0x70, 0x74, 0x69, 0x6f,
	0x6e, 0x48, 0x00, 0x52, 0x14, 0x71, 0x75, 0x65, 0x72, 0x79, 0x50, 0x61, 0x72, 0x61, 0x6d, 0x73,
	0x42, 0x6c, 0x61, 0x63, 0x6b, 0x6c, 0x69, 0x73, 0x74, 0x42, 0x16, 0x0a, 0x14, 0x71, 0x75, 0x65,
	0x72, 0x79, 0x5f, 0x70, 0x61, 0x72, 0x61, 0x6d, 0x73, 0x5f, 0x76, 0x61, 0x72, 0x69, 0x61, 0x6e,
	0x74, 0x1a, 0xf5, 0x01, 0x0a, 0x0f, 0x52, 0x65, 0x64, 0x69, 0x72, 0x65, 0x63, 0x74, 0x4f, 0x70,
	0x74, 0x69, 0x6f, 0x6e, 0x73, 0x12, 0x66, 0x0a, 0x16, 0x72, 0x65, 0x64, 0x69, 0x72, 0x65, 0x63,
	0x74, 0x5f, 0x68, 0x74, 0x74, 0x70, 0x5f, 0x74, 0x6f, 0x5f, 0x68, 0x74, 0x74, 0x70, 0x73, 0x18,
	0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x2f, 0x2e, 0x79, 0x61, 0x6e, 0x64, 0x65, 0x78, 0x2e, 0x63,
	0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x63, 0x64, 0x6e, 0x2e, 0x76, 0x31, 0x2e, 0x52, 0x65, 0x73, 0x6f,
	0x75, 0x72, 0x63, 0x65, 0x4f, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2e, 0x42, 0x6f, 0x6f, 0x6c,
	0x4f, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x48, 0x00, 0x52, 0x13, 0x72, 0x65, 0x64, 0x69, 0x72, 0x65,
	0x63, 0x74, 0x48, 0x74, 0x74, 0x70, 0x54, 0x6f, 0x48, 0x74, 0x74, 0x70, 0x73, 0x12, 0x66, 0x0a,
	0x16, 0x72, 0x65, 0x64, 0x69, 0x72, 0x65, 0x63, 0x74, 0x5f, 0x68, 0x74, 0x74, 0x70, 0x73, 0x5f,
	0x74, 0x6f, 0x5f, 0x68, 0x74, 0x74, 0x70, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x2f, 0x2e,
	0x79, 0x61, 0x6e, 0x64, 0x65, 0x78, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x63, 0x64, 0x6e,
	0x2e, 0x76, 0x31, 0x2e, 0x52, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x4f, 0x70, 0x74, 0x69,
	0x6f, 0x6e, 0x73, 0x2e, 0x42, 0x6f, 0x6f, 0x6c, 0x4f, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x48, 0x00,
	0x52, 0x13, 0x72, 0x65, 0x64, 0x69, 0x72, 0x65, 0x63, 0x74, 0x48, 0x74, 0x74, 0x70, 0x73, 0x54,
	0x6f, 0x48, 0x74, 0x74, 0x70, 0x42, 0x12, 0x0a, 0x10, 0x72, 0x65, 0x64, 0x69, 0x72, 0x65, 0x63,
	0x74, 0x5f, 0x76, 0x61, 0x72, 0x69, 0x61, 0x6e, 0x74, 0x1a, 0xc9, 0x01, 0x0a, 0x0b, 0x48, 0x6f,
	0x73, 0x74, 0x4f, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x12, 0x47, 0x0a, 0x04, 0x68, 0x6f, 0x73,
	0x74, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x31, 0x2e, 0x79, 0x61, 0x6e, 0x64, 0x65, 0x78,
	0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x63, 0x64, 0x6e, 0x2e, 0x76, 0x31, 0x2e, 0x52, 0x65,
	0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x4f, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2e, 0x53, 0x74,
	0x72, 0x69, 0x6e, 0x67, 0x4f, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x48, 0x00, 0x52, 0x04, 0x68, 0x6f,
	0x73, 0x74, 0x12, 0x61, 0x0a, 0x13, 0x66, 0x6f, 0x72, 0x77, 0x61, 0x72, 0x64, 0x5f, 0x68, 0x6f,
	0x73, 0x74, 0x5f, 0x68, 0x65, 0x61, 0x64, 0x65, 0x72, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32,
	0x2f, 0x2e, 0x79, 0x61, 0x6e, 0x64, 0x65, 0x78, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x63,
	0x64, 0x6e, 0x2e, 0x76, 0x31, 0x2e, 0x52, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x4f, 0x70,
	0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2e, 0x42, 0x6f, 0x6f, 0x6c, 0x4f, 0x70, 0x74, 0x69, 0x6f, 0x6e,
	0x48, 0x00, 0x52, 0x11, 0x66, 0x6f, 0x72, 0x77, 0x61, 0x72, 0x64, 0x48, 0x6f, 0x73, 0x74, 0x48,
	0x65, 0x61, 0x64, 0x65, 0x72, 0x42, 0x0e, 0x0a, 0x0c, 0x68, 0x6f, 0x73, 0x74, 0x5f, 0x76, 0x61,
	0x72, 0x69, 0x61, 0x6e, 0x74, 0x1a, 0xbe, 0x02, 0x0a, 0x12, 0x43, 0x6f, 0x6d, 0x70, 0x72, 0x65,
	0x73, 0x73, 0x69, 0x6f, 0x6e, 0x4f, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x12, 0x5c, 0x0a, 0x10,
	0x66, 0x65, 0x74, 0x63, 0x68, 0x5f, 0x63, 0x6f, 0x6d, 0x70, 0x72, 0x65, 0x73, 0x73, 0x65, 0x64,
	0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x2f, 0x2e, 0x79, 0x61, 0x6e, 0x64, 0x65, 0x78, 0x2e,
	0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x63, 0x64, 0x6e, 0x2e, 0x76, 0x31, 0x2e, 0x52, 0x65, 0x73,
	0x6f, 0x75, 0x72, 0x63, 0x65, 0x4f, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2e, 0x42, 0x6f, 0x6f,
	0x6c, 0x4f, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x48, 0x00, 0x52, 0x0f, 0x66, 0x65, 0x74, 0x63, 0x68,
	0x43, 0x6f, 0x6d, 0x70, 0x72, 0x65, 0x73, 0x73, 0x65, 0x64, 0x12, 0x4a, 0x0a, 0x07, 0x67, 0x7a,
	0x69, 0x70, 0x5f, 0x6f, 0x6e, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x2f, 0x2e, 0x79, 0x61,
	0x6e, 0x64, 0x65, 0x78, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x63, 0x64, 0x6e, 0x2e, 0x76,
	0x31, 0x2e, 0x52, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x4f, 0x70, 0x74, 0x69, 0x6f, 0x6e,
	0x73, 0x2e, 0x42, 0x6f, 0x6f, 0x6c, 0x4f, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x48, 0x00, 0x52, 0x06,
	0x67, 0x7a, 0x69, 0x70, 0x4f, 0x6e, 0x12, 0x67, 0x0a, 0x12, 0x62, 0x72, 0x6f, 0x74, 0x6c, 0x69,
	0x5f, 0x63, 0x6f, 0x6d, 0x70, 0x72, 0x65, 0x73, 0x73, 0x69, 0x6f, 0x6e, 0x18, 0x03, 0x20, 0x01,
	0x28, 0x0b, 0x32, 0x36, 0x2e, 0x79, 0x61, 0x6e, 0x64, 0x65, 0x78, 0x2e, 0x63, 0x6c, 0x6f, 0x75,
	0x64, 0x2e, 0x63, 0x64, 0x6e, 0x2e, 0x76, 0x31, 0x2e, 0x52, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63,
	0x65, 0x4f, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2e, 0x53, 0x74, 0x72, 0x69, 0x6e, 0x67, 0x73,
	0x4c, 0x69, 0x73, 0x74, 0x4f, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x48, 0x00, 0x52, 0x11, 0x62, 0x72,
	0x6f, 0x74, 0x6c, 0x69, 0x43, 0x6f, 0x6d, 0x70, 0x72, 0x65, 0x73, 0x73, 0x69, 0x6f, 0x6e, 0x42,
	0x15, 0x0a, 0x13, 0x63, 0x6f, 0x6d, 0x70, 0x72, 0x65, 0x73, 0x73, 0x69, 0x6f, 0x6e, 0x5f, 0x76,
	0x61, 0x72, 0x69, 0x61, 0x6e, 0x74, 0x1a, 0x73, 0x0a, 0x0d, 0x52, 0x65, 0x77, 0x72, 0x69, 0x74,
	0x65, 0x4f, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x18, 0x0a, 0x07, 0x65, 0x6e, 0x61, 0x62, 0x6c,
	0x65, 0x64, 0x18, 0x01, 0x20, 0x01, 0x28, 0x08, 0x52, 0x07, 0x65, 0x6e, 0x61, 0x62, 0x6c, 0x65,
	0x64, 0x12, 0x12, 0x0a, 0x04, 0x62, 0x6f, 0x64, 0x79, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52,
	0x04, 0x62, 0x6f, 0x64, 0x79, 0x12, 0x34, 0x0a, 0x04, 0x66, 0x6c, 0x61, 0x67, 0x18, 0x03, 0x20,
	0x01, 0x28, 0x0e, 0x32, 0x20, 0x2e, 0x79, 0x61, 0x6e, 0x64, 0x65, 0x78, 0x2e, 0x63, 0x6c, 0x6f,
	0x75, 0x64, 0x2e, 0x63, 0x64, 0x6e, 0x2e, 0x76, 0x31, 0x2e, 0x52, 0x65, 0x77, 0x72, 0x69, 0x74,
	0x65, 0x46, 0x6c, 0x61, 0x67, 0x52, 0x04, 0x66, 0x6c, 0x61, 0x67, 0x22, 0x90, 0x01, 0x0a, 0x14,
	0x53, 0x53, 0x4c, 0x54, 0x61, 0x72, 0x67, 0x65, 0x74, 0x43, 0x65, 0x72, 0x74, 0x69, 0x66, 0x69,
	0x63, 0x61, 0x74, 0x65, 0x12, 0x3b, 0x0a, 0x04, 0x74, 0x79, 0x70, 0x65, 0x18, 0x01, 0x20, 0x01,
	0x28, 0x0e, 0x32, 0x27, 0x2e, 0x79, 0x61, 0x6e, 0x64, 0x65, 0x78, 0x2e, 0x63, 0x6c, 0x6f, 0x75,
	0x64, 0x2e, 0x63, 0x64, 0x6e, 0x2e, 0x76, 0x31, 0x2e, 0x53, 0x53, 0x4c, 0x43, 0x65, 0x72, 0x74,
	0x69, 0x66, 0x69, 0x63, 0x61, 0x74, 0x65, 0x54, 0x79, 0x70, 0x65, 0x52, 0x04, 0x74, 0x79, 0x70,
	0x65, 0x12, 0x3b, 0x0a, 0x04, 0x64, 0x61, 0x74, 0x61, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32,
	0x27, 0x2e, 0x79, 0x61, 0x6e, 0x64, 0x65, 0x78, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x63,
	0x64, 0x6e, 0x2e, 0x76, 0x31, 0x2e, 0x53, 0x53, 0x4c, 0x43, 0x65, 0x72, 0x74, 0x69, 0x66, 0x69,
	0x63, 0x61, 0x74, 0x65, 0x44, 0x61, 0x74, 0x61, 0x52, 0x04, 0x64, 0x61, 0x74, 0x61, 0x22, 0xcd,
	0x01, 0x0a, 0x0e, 0x53, 0x53, 0x4c, 0x43, 0x65, 0x72, 0x74, 0x69, 0x66, 0x69, 0x63, 0x61, 0x74,
	0x65, 0x12, 0x3b, 0x0a, 0x04, 0x74, 0x79, 0x70, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0e, 0x32,
	0x27, 0x2e, 0x79, 0x61, 0x6e, 0x64, 0x65, 0x78, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x63,
	0x64, 0x6e, 0x2e, 0x76, 0x31, 0x2e, 0x53, 0x53, 0x4c, 0x43, 0x65, 0x72, 0x74, 0x69, 0x66, 0x69,
	0x63, 0x61, 0x74, 0x65, 0x54, 0x79, 0x70, 0x65, 0x52, 0x04, 0x74, 0x79, 0x70, 0x65, 0x12, 0x41,
	0x0a, 0x06, 0x73, 0x74, 0x61, 0x74, 0x75, 0x73, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x29,
	0x2e, 0x79, 0x61, 0x6e, 0x64, 0x65, 0x78, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x63, 0x64,
	0x6e, 0x2e, 0x76, 0x31, 0x2e, 0x53, 0x53, 0x4c, 0x43, 0x65, 0x72, 0x74, 0x69, 0x66, 0x69, 0x63,
	0x61, 0x74, 0x65, 0x53, 0x74, 0x61, 0x74, 0x75, 0x73, 0x52, 0x06, 0x73, 0x74, 0x61, 0x74, 0x75,
	0x73, 0x12, 0x3b, 0x0a, 0x04, 0x64, 0x61, 0x74, 0x61, 0x18, 0x03, 0x20, 0x01, 0x28, 0x0b, 0x32,
	0x27, 0x2e, 0x79, 0x61, 0x6e, 0x64, 0x65, 0x78, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x63,
	0x64, 0x6e, 0x2e, 0x76, 0x31, 0x2e, 0x53, 0x53, 0x4c, 0x43, 0x65, 0x72, 0x74, 0x69, 0x66, 0x69,
	0x63, 0x61, 0x74, 0x65, 0x44, 0x61, 0x74, 0x61, 0x52, 0x04, 0x64, 0x61, 0x74, 0x61, 0x22, 0x71,
	0x0a, 0x12, 0x53, 0x53, 0x4c, 0x43, 0x65, 0x72, 0x74, 0x69, 0x66, 0x69, 0x63, 0x61, 0x74, 0x65,
	0x44, 0x61, 0x74, 0x61, 0x12, 0x3b, 0x0a, 0x02, 0x63, 0x6d, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b,
	0x32, 0x29, 0x2e, 0x79, 0x61, 0x6e, 0x64, 0x65, 0x78, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e,
	0x63, 0x64, 0x6e, 0x2e, 0x76, 0x31, 0x2e, 0x53, 0x53, 0x4c, 0x43, 0x65, 0x72, 0x74, 0x69, 0x66,
	0x69, 0x63, 0x61, 0x74, 0x65, 0x43, 0x4d, 0x44, 0x61, 0x74, 0x61, 0x48, 0x00, 0x52, 0x02, 0x63,
	0x6d, 0x42, 0x1e, 0x0a, 0x1c, 0x73, 0x73, 0x6c, 0x5f, 0x63, 0x65, 0x72, 0x74, 0x69, 0x66, 0x69,
	0x63, 0x61, 0x74, 0x65, 0x5f, 0x64, 0x61, 0x74, 0x61, 0x5f, 0x76, 0x61, 0x72, 0x69, 0x61, 0x6e,
	0x74, 0x22, 0x26, 0x0a, 0x14, 0x53, 0x53, 0x4c, 0x43, 0x65, 0x72, 0x74, 0x69, 0x66, 0x69, 0x63,
	0x61, 0x74, 0x65, 0x43, 0x4d, 0x44, 0x61, 0x74, 0x61, 0x12, 0x0e, 0x0a, 0x02, 0x69, 0x64, 0x18,
	0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x02, 0x69, 0x64, 0x2a, 0x51, 0x0a, 0x0e, 0x4f, 0x72, 0x69,
	0x67, 0x69, 0x6e, 0x50, 0x72, 0x6f, 0x74, 0x6f, 0x63, 0x6f, 0x6c, 0x12, 0x1f, 0x0a, 0x1b, 0x4f,
	0x52, 0x49, 0x47, 0x49, 0x4e, 0x5f, 0x50, 0x52, 0x4f, 0x54, 0x4f, 0x43, 0x4f, 0x4c, 0x5f, 0x55,
	0x4e, 0x53, 0x50, 0x45, 0x43, 0x49, 0x46, 0x49, 0x45, 0x44, 0x10, 0x00, 0x12, 0x08, 0x0a, 0x04,
	0x48, 0x54, 0x54, 0x50, 0x10, 0x01, 0x12, 0x09, 0x0a, 0x05, 0x48, 0x54, 0x54, 0x50, 0x53, 0x10,
	0x02, 0x12, 0x09, 0x0a, 0x05, 0x4d, 0x41, 0x54, 0x43, 0x48, 0x10, 0x03, 0x2a, 0x5d, 0x0a, 0x0b,
	0x52, 0x65, 0x77, 0x72, 0x69, 0x74, 0x65, 0x46, 0x6c, 0x61, 0x67, 0x12, 0x1c, 0x0a, 0x18, 0x52,
	0x45, 0x57, 0x52, 0x49, 0x54, 0x45, 0x5f, 0x46, 0x4c, 0x41, 0x47, 0x5f, 0x55, 0x4e, 0x53, 0x50,
	0x45, 0x43, 0x49, 0x46, 0x49, 0x45, 0x44, 0x10, 0x00, 0x12, 0x08, 0x0a, 0x04, 0x4c, 0x41, 0x53,
	0x54, 0x10, 0x01, 0x12, 0x09, 0x0a, 0x05, 0x42, 0x52, 0x45, 0x41, 0x4b, 0x10, 0x02, 0x12, 0x0c,
	0x0a, 0x08, 0x52, 0x45, 0x44, 0x49, 0x52, 0x45, 0x43, 0x54, 0x10, 0x03, 0x12, 0x0d, 0x0a, 0x09,
	0x50, 0x45, 0x52, 0x4d, 0x41, 0x4e, 0x45, 0x4e, 0x54, 0x10, 0x04, 0x2a, 0x68, 0x0a, 0x12, 0x53,
	0x53, 0x4c, 0x43, 0x65, 0x72, 0x74, 0x69, 0x66, 0x69, 0x63, 0x61, 0x74, 0x65, 0x54, 0x79, 0x70,
	0x65, 0x12, 0x24, 0x0a, 0x20, 0x53, 0x53, 0x4c, 0x5f, 0x43, 0x45, 0x52, 0x54, 0x49, 0x46, 0x49,
	0x43, 0x41, 0x54, 0x45, 0x5f, 0x54, 0x59, 0x50, 0x45, 0x5f, 0x55, 0x4e, 0x53, 0x50, 0x45, 0x43,
	0x49, 0x46, 0x49, 0x45, 0x44, 0x10, 0x00, 0x12, 0x0c, 0x0a, 0x08, 0x44, 0x4f, 0x4e, 0x54, 0x5f,
	0x55, 0x53, 0x45, 0x10, 0x01, 0x12, 0x16, 0x0a, 0x12, 0x4c, 0x45, 0x54, 0x53, 0x5f, 0x45, 0x4e,
	0x43, 0x52, 0x59, 0x50, 0x54, 0x5f, 0x47, 0x43, 0x4f, 0x52, 0x45, 0x10, 0x02, 0x12, 0x06, 0x0a,
	0x02, 0x43, 0x4d, 0x10, 0x03, 0x2a, 0x57, 0x0a, 0x14, 0x53, 0x53, 0x4c, 0x43, 0x65, 0x72, 0x74,
	0x69, 0x66, 0x69, 0x63, 0x61, 0x74, 0x65, 0x53, 0x74, 0x61, 0x74, 0x75, 0x73, 0x12, 0x26, 0x0a,
	0x22, 0x53, 0x53, 0x4c, 0x5f, 0x43, 0x45, 0x52, 0x54, 0x49, 0x46, 0x49, 0x43, 0x41, 0x54, 0x45,
	0x5f, 0x53, 0x54, 0x41, 0x54, 0x55, 0x53, 0x5f, 0x55, 0x4e, 0x53, 0x50, 0x45, 0x43, 0x49, 0x46,
	0x49, 0x45, 0x44, 0x10, 0x00, 0x12, 0x09, 0x0a, 0x05, 0x52, 0x45, 0x41, 0x44, 0x59, 0x10, 0x01,
	0x12, 0x0c, 0x0a, 0x08, 0x43, 0x52, 0x45, 0x41, 0x54, 0x49, 0x4e, 0x47, 0x10, 0x02, 0x42, 0x56,
	0x0a, 0x17, 0x79, 0x61, 0x6e, 0x64, 0x65, 0x78, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x61,
	0x70, 0x69, 0x2e, 0x63, 0x64, 0x6e, 0x2e, 0x76, 0x31, 0x5a, 0x3b, 0x67, 0x69, 0x74, 0x68, 0x75,
	0x62, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x79, 0x61, 0x6e, 0x64, 0x65, 0x78, 0x2d, 0x63, 0x6c, 0x6f,
	0x75, 0x64, 0x2f, 0x67, 0x6f, 0x2d, 0x67, 0x65, 0x6e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x2f, 0x79,
	0x61, 0x6e, 0x64, 0x65, 0x78, 0x2f, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2f, 0x63, 0x64, 0x6e, 0x2f,
	0x76, 0x31, 0x3b, 0x63, 0x64, 0x6e, 0x62, 0x06, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x33,
}

var (
	file_yandex_cloud_cdn_v1_resource_proto_rawDescOnce sync.Once
	file_yandex_cloud_cdn_v1_resource_proto_rawDescData = file_yandex_cloud_cdn_v1_resource_proto_rawDesc
)

func file_yandex_cloud_cdn_v1_resource_proto_rawDescGZIP() []byte {
	file_yandex_cloud_cdn_v1_resource_proto_rawDescOnce.Do(func() {
		file_yandex_cloud_cdn_v1_resource_proto_rawDescData = protoimpl.X.CompressGZIP(file_yandex_cloud_cdn_v1_resource_proto_rawDescData)
	})
	return file_yandex_cloud_cdn_v1_resource_proto_rawDescData
}

var file_yandex_cloud_cdn_v1_resource_proto_enumTypes = make([]protoimpl.EnumInfo, 4)
var file_yandex_cloud_cdn_v1_resource_proto_msgTypes = make([]protoimpl.MessageInfo, 25)
var file_yandex_cloud_cdn_v1_resource_proto_goTypes = []interface{}{
	(OriginProtocol)(0),                             // 0: yandex.cloud.cdn.v1.OriginProtocol
	(RewriteFlag)(0),                                // 1: yandex.cloud.cdn.v1.RewriteFlag
	(SSLCertificateType)(0),                         // 2: yandex.cloud.cdn.v1.SSLCertificateType
	(SSLCertificateStatus)(0),                       // 3: yandex.cloud.cdn.v1.SSLCertificateStatus
	(*SecondaryHostnames)(nil),                      // 4: yandex.cloud.cdn.v1.SecondaryHostnames
	(*Resource)(nil),                                // 5: yandex.cloud.cdn.v1.Resource
	(*ResourceOptions)(nil),                         // 6: yandex.cloud.cdn.v1.ResourceOptions
	(*SSLTargetCertificate)(nil),                    // 7: yandex.cloud.cdn.v1.SSLTargetCertificate
	(*SSLCertificate)(nil),                          // 8: yandex.cloud.cdn.v1.SSLCertificate
	(*SSLCertificateData)(nil),                      // 9: yandex.cloud.cdn.v1.SSLCertificateData
	(*SSLCertificateCMData)(nil),                    // 10: yandex.cloud.cdn.v1.SSLCertificateCMData
	nil,                                             // 11: yandex.cloud.cdn.v1.Resource.LabelsEntry
	(*ResourceOptions_BoolOption)(nil),              // 12: yandex.cloud.cdn.v1.ResourceOptions.BoolOption
	(*ResourceOptions_StringOption)(nil),            // 13: yandex.cloud.cdn.v1.ResourceOptions.StringOption
	(*ResourceOptions_Int64Option)(nil),             // 14: yandex.cloud.cdn.v1.ResourceOptions.Int64Option
	(*ResourceOptions_StringsListOption)(nil),       // 15: yandex.cloud.cdn.v1.ResourceOptions.StringsListOption
	(*ResourceOptions_StringsMapOption)(nil),        // 16: yandex.cloud.cdn.v1.ResourceOptions.StringsMapOption
	(*ResourceOptions_CachingTimes)(nil),            // 17: yandex.cloud.cdn.v1.ResourceOptions.CachingTimes
	(*ResourceOptions_EdgeCacheSettings)(nil),       // 18: yandex.cloud.cdn.v1.ResourceOptions.EdgeCacheSettings
	(*ResourceOptions_StringVariableMapOption)(nil), // 19: yandex.cloud.cdn.v1.ResourceOptions.StringVariableMapOption
	(*ResourceOptions_QueryParamsOptions)(nil),      // 20: yandex.cloud.cdn.v1.ResourceOptions.QueryParamsOptions
	(*ResourceOptions_RedirectOptions)(nil),         // 21: yandex.cloud.cdn.v1.ResourceOptions.RedirectOptions
	(*ResourceOptions_HostOptions)(nil),             // 22: yandex.cloud.cdn.v1.ResourceOptions.HostOptions
	(*ResourceOptions_CompressionOptions)(nil),      // 23: yandex.cloud.cdn.v1.ResourceOptions.CompressionOptions
	(*ResourceOptions_RewriteOption)(nil),           // 24: yandex.cloud.cdn.v1.ResourceOptions.RewriteOption
	nil,                                             // 25: yandex.cloud.cdn.v1.ResourceOptions.StringsMapOption.ValueEntry
	nil,                                             // 26: yandex.cloud.cdn.v1.ResourceOptions.CachingTimes.CustomValuesEntry
	(*ResourceOptions_StringVariableMapOption_OneofString)(nil), // 27: yandex.cloud.cdn.v1.ResourceOptions.StringVariableMapOption.OneofString
	nil,                           // 28: yandex.cloud.cdn.v1.ResourceOptions.StringVariableMapOption.ValueEntry
	(*timestamppb.Timestamp)(nil), // 29: google.protobuf.Timestamp
}
var file_yandex_cloud_cdn_v1_resource_proto_depIdxs = []int32{
	29, // 0: yandex.cloud.cdn.v1.Resource.created_at:type_name -> google.protobuf.Timestamp
	29, // 1: yandex.cloud.cdn.v1.Resource.updated_at:type_name -> google.protobuf.Timestamp
	6,  // 2: yandex.cloud.cdn.v1.Resource.options:type_name -> yandex.cloud.cdn.v1.ResourceOptions
	0,  // 3: yandex.cloud.cdn.v1.Resource.origin_protocol:type_name -> yandex.cloud.cdn.v1.OriginProtocol
	8,  // 4: yandex.cloud.cdn.v1.Resource.ssl_certificate:type_name -> yandex.cloud.cdn.v1.SSLCertificate
	11, // 5: yandex.cloud.cdn.v1.Resource.labels:type_name -> yandex.cloud.cdn.v1.Resource.LabelsEntry
	12, // 6: yandex.cloud.cdn.v1.ResourceOptions.disable_cache:type_name -> yandex.cloud.cdn.v1.ResourceOptions.BoolOption
	18, // 7: yandex.cloud.cdn.v1.ResourceOptions.edge_cache_settings:type_name -> yandex.cloud.cdn.v1.ResourceOptions.EdgeCacheSettings
	14, // 8: yandex.cloud.cdn.v1.ResourceOptions.browser_cache_settings:type_name -> yandex.cloud.cdn.v1.ResourceOptions.Int64Option
	15, // 9: yandex.cloud.cdn.v1.ResourceOptions.cache_http_headers:type_name -> yandex.cloud.cdn.v1.ResourceOptions.StringsListOption
	20, // 10: yandex.cloud.cdn.v1.ResourceOptions.query_params_options:type_name -> yandex.cloud.cdn.v1.ResourceOptions.QueryParamsOptions
	12, // 11: yandex.cloud.cdn.v1.ResourceOptions.slice:type_name -> yandex.cloud.cdn.v1.ResourceOptions.BoolOption
	23, // 12: yandex.cloud.cdn.v1.ResourceOptions.compression_options:type_name -> yandex.cloud.cdn.v1.ResourceOptions.CompressionOptions
	21, // 13: yandex.cloud.cdn.v1.ResourceOptions.redirect_options:type_name -> yandex.cloud.cdn.v1.ResourceOptions.RedirectOptions
	22, // 14: yandex.cloud.cdn.v1.ResourceOptions.host_options:type_name -> yandex.cloud.cdn.v1.ResourceOptions.HostOptions
	16, // 15: yandex.cloud.cdn.v1.ResourceOptions.static_headers:type_name -> yandex.cloud.cdn.v1.ResourceOptions.StringsMapOption
	15, // 16: yandex.cloud.cdn.v1.ResourceOptions.cors:type_name -> yandex.cloud.cdn.v1.ResourceOptions.StringsListOption
	15, // 17: yandex.cloud.cdn.v1.ResourceOptions.stale:type_name -> yandex.cloud.cdn.v1.ResourceOptions.StringsListOption
	15, // 18: yandex.cloud.cdn.v1.ResourceOptions.allowed_http_methods:type_name -> yandex.cloud.cdn.v1.ResourceOptions.StringsListOption
	12, // 19: yandex.cloud.cdn.v1.ResourceOptions.proxy_cache_methods_set:type_name -> yandex.cloud.cdn.v1.ResourceOptions.BoolOption
	12, // 20: yandex.cloud.cdn.v1.ResourceOptions.disable_proxy_force_ranges:type_name -> yandex.cloud.cdn.v1.ResourceOptions.BoolOption
	16, // 21: yandex.cloud.cdn.v1.ResourceOptions.static_request_headers:type_name -> yandex.cloud.cdn.v1.ResourceOptions.StringsMapOption
	13, // 22: yandex.cloud.cdn.v1.ResourceOptions.custom_server_name:type_name -> yandex.cloud.cdn.v1.ResourceOptions.StringOption
	12, // 23: yandex.cloud.cdn.v1.ResourceOptions.ignore_cookie:type_name -> yandex.cloud.cdn.v1.ResourceOptions.BoolOption
	24, // 24: yandex.cloud.cdn.v1.ResourceOptions.rewrite:type_name -> yandex.cloud.cdn.v1.ResourceOptions.RewriteOption
	2,  // 25: yandex.cloud.cdn.v1.SSLTargetCertificate.type:type_name -> yandex.cloud.cdn.v1.SSLCertificateType
	9,  // 26: yandex.cloud.cdn.v1.SSLTargetCertificate.data:type_name -> yandex.cloud.cdn.v1.SSLCertificateData
	2,  // 27: yandex.cloud.cdn.v1.SSLCertificate.type:type_name -> yandex.cloud.cdn.v1.SSLCertificateType
	3,  // 28: yandex.cloud.cdn.v1.SSLCertificate.status:type_name -> yandex.cloud.cdn.v1.SSLCertificateStatus
	9,  // 29: yandex.cloud.cdn.v1.SSLCertificate.data:type_name -> yandex.cloud.cdn.v1.SSLCertificateData
	10, // 30: yandex.cloud.cdn.v1.SSLCertificateData.cm:type_name -> yandex.cloud.cdn.v1.SSLCertificateCMData
	25, // 31: yandex.cloud.cdn.v1.ResourceOptions.StringsMapOption.value:type_name -> yandex.cloud.cdn.v1.ResourceOptions.StringsMapOption.ValueEntry
	26, // 32: yandex.cloud.cdn.v1.ResourceOptions.CachingTimes.custom_values:type_name -> yandex.cloud.cdn.v1.ResourceOptions.CachingTimes.CustomValuesEntry
	17, // 33: yandex.cloud.cdn.v1.ResourceOptions.EdgeCacheSettings.value:type_name -> yandex.cloud.cdn.v1.ResourceOptions.CachingTimes
	28, // 34: yandex.cloud.cdn.v1.ResourceOptions.StringVariableMapOption.value:type_name -> yandex.cloud.cdn.v1.ResourceOptions.StringVariableMapOption.ValueEntry
	12, // 35: yandex.cloud.cdn.v1.ResourceOptions.QueryParamsOptions.ignore_query_string:type_name -> yandex.cloud.cdn.v1.ResourceOptions.BoolOption
	15, // 36: yandex.cloud.cdn.v1.ResourceOptions.QueryParamsOptions.query_params_whitelist:type_name -> yandex.cloud.cdn.v1.ResourceOptions.StringsListOption
	15, // 37: yandex.cloud.cdn.v1.ResourceOptions.QueryParamsOptions.query_params_blacklist:type_name -> yandex.cloud.cdn.v1.ResourceOptions.StringsListOption
	12, // 38: yandex.cloud.cdn.v1.ResourceOptions.RedirectOptions.redirect_http_to_https:type_name -> yandex.cloud.cdn.v1.ResourceOptions.BoolOption
	12, // 39: yandex.cloud.cdn.v1.ResourceOptions.RedirectOptions.redirect_https_to_http:type_name -> yandex.cloud.cdn.v1.ResourceOptions.BoolOption
	13, // 40: yandex.cloud.cdn.v1.ResourceOptions.HostOptions.host:type_name -> yandex.cloud.cdn.v1.ResourceOptions.StringOption
	12, // 41: yandex.cloud.cdn.v1.ResourceOptions.HostOptions.forward_host_header:type_name -> yandex.cloud.cdn.v1.ResourceOptions.BoolOption
	12, // 42: yandex.cloud.cdn.v1.ResourceOptions.CompressionOptions.fetch_compressed:type_name -> yandex.cloud.cdn.v1.ResourceOptions.BoolOption
	12, // 43: yandex.cloud.cdn.v1.ResourceOptions.CompressionOptions.gzip_on:type_name -> yandex.cloud.cdn.v1.ResourceOptions.BoolOption
	15, // 44: yandex.cloud.cdn.v1.ResourceOptions.CompressionOptions.brotli_compression:type_name -> yandex.cloud.cdn.v1.ResourceOptions.StringsListOption
	1,  // 45: yandex.cloud.cdn.v1.ResourceOptions.RewriteOption.flag:type_name -> yandex.cloud.cdn.v1.RewriteFlag
	13, // 46: yandex.cloud.cdn.v1.ResourceOptions.StringVariableMapOption.OneofString.value:type_name -> yandex.cloud.cdn.v1.ResourceOptions.StringOption
	15, // 47: yandex.cloud.cdn.v1.ResourceOptions.StringVariableMapOption.OneofString.values:type_name -> yandex.cloud.cdn.v1.ResourceOptions.StringsListOption
	27, // 48: yandex.cloud.cdn.v1.ResourceOptions.StringVariableMapOption.ValueEntry.value:type_name -> yandex.cloud.cdn.v1.ResourceOptions.StringVariableMapOption.OneofString
	49, // [49:49] is the sub-list for method output_type
	49, // [49:49] is the sub-list for method input_type
	49, // [49:49] is the sub-list for extension type_name
	49, // [49:49] is the sub-list for extension extendee
	0,  // [0:49] is the sub-list for field type_name
}

func init() { file_yandex_cloud_cdn_v1_resource_proto_init() }
func file_yandex_cloud_cdn_v1_resource_proto_init() {
	if File_yandex_cloud_cdn_v1_resource_proto != nil {
		return
	}
	if !protoimpl.UnsafeEnabled {
		file_yandex_cloud_cdn_v1_resource_proto_msgTypes[0].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*SecondaryHostnames); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_yandex_cloud_cdn_v1_resource_proto_msgTypes[1].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*Resource); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_yandex_cloud_cdn_v1_resource_proto_msgTypes[2].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ResourceOptions); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_yandex_cloud_cdn_v1_resource_proto_msgTypes[3].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*SSLTargetCertificate); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_yandex_cloud_cdn_v1_resource_proto_msgTypes[4].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*SSLCertificate); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_yandex_cloud_cdn_v1_resource_proto_msgTypes[5].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*SSLCertificateData); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_yandex_cloud_cdn_v1_resource_proto_msgTypes[6].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*SSLCertificateCMData); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_yandex_cloud_cdn_v1_resource_proto_msgTypes[8].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ResourceOptions_BoolOption); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_yandex_cloud_cdn_v1_resource_proto_msgTypes[9].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ResourceOptions_StringOption); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_yandex_cloud_cdn_v1_resource_proto_msgTypes[10].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ResourceOptions_Int64Option); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_yandex_cloud_cdn_v1_resource_proto_msgTypes[11].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ResourceOptions_StringsListOption); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_yandex_cloud_cdn_v1_resource_proto_msgTypes[12].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ResourceOptions_StringsMapOption); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_yandex_cloud_cdn_v1_resource_proto_msgTypes[13].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ResourceOptions_CachingTimes); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_yandex_cloud_cdn_v1_resource_proto_msgTypes[14].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ResourceOptions_EdgeCacheSettings); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_yandex_cloud_cdn_v1_resource_proto_msgTypes[15].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ResourceOptions_StringVariableMapOption); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_yandex_cloud_cdn_v1_resource_proto_msgTypes[16].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ResourceOptions_QueryParamsOptions); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_yandex_cloud_cdn_v1_resource_proto_msgTypes[17].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ResourceOptions_RedirectOptions); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_yandex_cloud_cdn_v1_resource_proto_msgTypes[18].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ResourceOptions_HostOptions); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_yandex_cloud_cdn_v1_resource_proto_msgTypes[19].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ResourceOptions_CompressionOptions); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_yandex_cloud_cdn_v1_resource_proto_msgTypes[20].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ResourceOptions_RewriteOption); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_yandex_cloud_cdn_v1_resource_proto_msgTypes[23].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ResourceOptions_StringVariableMapOption_OneofString); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
	}
	file_yandex_cloud_cdn_v1_resource_proto_msgTypes[5].OneofWrappers = []interface{}{
		(*SSLCertificateData_Cm)(nil),
	}
	file_yandex_cloud_cdn_v1_resource_proto_msgTypes[14].OneofWrappers = []interface{}{
		(*ResourceOptions_EdgeCacheSettings_Value)(nil),
		(*ResourceOptions_EdgeCacheSettings_DefaultValue)(nil),
	}
	file_yandex_cloud_cdn_v1_resource_proto_msgTypes[16].OneofWrappers = []interface{}{
		(*ResourceOptions_QueryParamsOptions_IgnoreQueryString)(nil),
		(*ResourceOptions_QueryParamsOptions_QueryParamsWhitelist)(nil),
		(*ResourceOptions_QueryParamsOptions_QueryParamsBlacklist)(nil),
	}
	file_yandex_cloud_cdn_v1_resource_proto_msgTypes[17].OneofWrappers = []interface{}{
		(*ResourceOptions_RedirectOptions_RedirectHttpToHttps)(nil),
		(*ResourceOptions_RedirectOptions_RedirectHttpsToHttp)(nil),
	}
	file_yandex_cloud_cdn_v1_resource_proto_msgTypes[18].OneofWrappers = []interface{}{
		(*ResourceOptions_HostOptions_Host)(nil),
		(*ResourceOptions_HostOptions_ForwardHostHeader)(nil),
	}
	file_yandex_cloud_cdn_v1_resource_proto_msgTypes[19].OneofWrappers = []interface{}{
		(*ResourceOptions_CompressionOptions_FetchCompressed)(nil),
		(*ResourceOptions_CompressionOptions_GzipOn)(nil),
		(*ResourceOptions_CompressionOptions_BrotliCompression)(nil),
	}
	file_yandex_cloud_cdn_v1_resource_proto_msgTypes[23].OneofWrappers = []interface{}{
		(*ResourceOptions_StringVariableMapOption_OneofString_Value)(nil),
		(*ResourceOptions_StringVariableMapOption_OneofString_Values)(nil),
	}
	type x struct{}
	out := protoimpl.TypeBuilder{
		File: protoimpl.DescBuilder{
			GoPackagePath: reflect.TypeOf(x{}).PkgPath(),
			RawDescriptor: file_yandex_cloud_cdn_v1_resource_proto_rawDesc,
			NumEnums:      4,
			NumMessages:   25,
			NumExtensions: 0,
			NumServices:   0,
		},
		GoTypes:           file_yandex_cloud_cdn_v1_resource_proto_goTypes,
		DependencyIndexes: file_yandex_cloud_cdn_v1_resource_proto_depIdxs,
		EnumInfos:         file_yandex_cloud_cdn_v1_resource_proto_enumTypes,
		MessageInfos:      file_yandex_cloud_cdn_v1_resource_proto_msgTypes,
	}.Build()
	File_yandex_cloud_cdn_v1_resource_proto = out.File
	file_yandex_cloud_cdn_v1_resource_proto_rawDesc = nil
	file_yandex_cloud_cdn_v1_resource_proto_goTypes = nil
	file_yandex_cloud_cdn_v1_resource_proto_depIdxs = nil
}
