// Code generated by protoc-gen-go-grpc. DO NOT EDIT.
// versions:
// - protoc-gen-go-grpc v1.3.0
// - protoc             v3.17.3
// source: yandex/cloud/containerregistry/v1/scanner_service.proto

package containerregistry

import (
	context "context"
	operation "github.com/yandex-cloud/go-genproto/yandex/cloud/operation"
	grpc "google.golang.org/grpc"
	codes "google.golang.org/grpc/codes"
	status "google.golang.org/grpc/status"
)

// This is a compile-time assertion to ensure that this generated file
// is compatible with the grpc package it is being compiled against.
// Requires gRPC-Go v1.32.0 or later.
const _ = grpc.SupportPackageIsVersion7

const (
	ScannerService_Scan_FullMethodName                = "/yandex.cloud.containerregistry.v1.ScannerService/Scan"
	ScannerService_Get_FullMethodName                 = "/yandex.cloud.containerregistry.v1.ScannerService/Get"
	ScannerService_GetLast_FullMethodName             = "/yandex.cloud.containerregistry.v1.ScannerService/GetLast"
	ScannerService_List_FullMethodName                = "/yandex.cloud.containerregistry.v1.ScannerService/List"
	ScannerService_ListVulnerabilities_FullMethodName = "/yandex.cloud.containerregistry.v1.ScannerService/ListVulnerabilities"
)

// ScannerServiceClient is the client API for ScannerService service.
//
// For semantics around ctx use and closing/ending streaming RPCs, please refer to https://pkg.go.dev/google.golang.org/grpc/?tab=doc#ClientConn.NewStream.
type ScannerServiceClient interface {
	// Executes scanning of specified image.
	Scan(ctx context.Context, in *ScanRequest, opts ...grpc.CallOption) (*operation.Operation, error)
	// Returns the specified ScanResult resource.
	//
	// To get the list of ScanResults for specified Image, make a [List] request.
	Get(ctx context.Context, in *GetScanResultRequest, opts ...grpc.CallOption) (*ScanResult, error)
	// Returns the last finished ScanResult for the specified Image.
	GetLast(ctx context.Context, in *GetLastScanResultRequest, opts ...grpc.CallOption) (*ScanResult, error)
	// Retrieves the list of ScanResults for specified Image.
	List(ctx context.Context, in *ListScanResultsRequest, opts ...grpc.CallOption) (*ListScanResultsResponse, error)
	// Retrieves the list of vulnerabilities found in particular scan.
	ListVulnerabilities(ctx context.Context, in *ListVulnerabilitiesRequest, opts ...grpc.CallOption) (*ListVulnerabilitiesResponse, error)
}

type scannerServiceClient struct {
	cc grpc.ClientConnInterface
}

func NewScannerServiceClient(cc grpc.ClientConnInterface) ScannerServiceClient {
	return &scannerServiceClient{cc}
}

func (c *scannerServiceClient) Scan(ctx context.Context, in *ScanRequest, opts ...grpc.CallOption) (*operation.Operation, error) {
	out := new(operation.Operation)
	err := c.cc.Invoke(ctx, ScannerService_Scan_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *scannerServiceClient) Get(ctx context.Context, in *GetScanResultRequest, opts ...grpc.CallOption) (*ScanResult, error) {
	out := new(ScanResult)
	err := c.cc.Invoke(ctx, ScannerService_Get_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *scannerServiceClient) GetLast(ctx context.Context, in *GetLastScanResultRequest, opts ...grpc.CallOption) (*ScanResult, error) {
	out := new(ScanResult)
	err := c.cc.Invoke(ctx, ScannerService_GetLast_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *scannerServiceClient) List(ctx context.Context, in *ListScanResultsRequest, opts ...grpc.CallOption) (*ListScanResultsResponse, error) {
	out := new(ListScanResultsResponse)
	err := c.cc.Invoke(ctx, ScannerService_List_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *scannerServiceClient) ListVulnerabilities(ctx context.Context, in *ListVulnerabilitiesRequest, opts ...grpc.CallOption) (*ListVulnerabilitiesResponse, error) {
	out := new(ListVulnerabilitiesResponse)
	err := c.cc.Invoke(ctx, ScannerService_ListVulnerabilities_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

// ScannerServiceServer is the server API for ScannerService service.
// All implementations should embed UnimplementedScannerServiceServer
// for forward compatibility
type ScannerServiceServer interface {
	// Executes scanning of specified image.
	Scan(context.Context, *ScanRequest) (*operation.Operation, error)
	// Returns the specified ScanResult resource.
	//
	// To get the list of ScanResults for specified Image, make a [List] request.
	Get(context.Context, *GetScanResultRequest) (*ScanResult, error)
	// Returns the last finished ScanResult for the specified Image.
	GetLast(context.Context, *GetLastScanResultRequest) (*ScanResult, error)
	// Retrieves the list of ScanResults for specified Image.
	List(context.Context, *ListScanResultsRequest) (*ListScanResultsResponse, error)
	// Retrieves the list of vulnerabilities found in particular scan.
	ListVulnerabilities(context.Context, *ListVulnerabilitiesRequest) (*ListVulnerabilitiesResponse, error)
}

// UnimplementedScannerServiceServer should be embedded to have forward compatible implementations.
type UnimplementedScannerServiceServer struct {
}

func (UnimplementedScannerServiceServer) Scan(context.Context, *ScanRequest) (*operation.Operation, error) {
	return nil, status.Errorf(codes.Unimplemented, "method Scan not implemented")
}
func (UnimplementedScannerServiceServer) Get(context.Context, *GetScanResultRequest) (*ScanResult, error) {
	return nil, status.Errorf(codes.Unimplemented, "method Get not implemented")
}
func (UnimplementedScannerServiceServer) GetLast(context.Context, *GetLastScanResultRequest) (*ScanResult, error) {
	return nil, status.Errorf(codes.Unimplemented, "method GetLast not implemented")
}
func (UnimplementedScannerServiceServer) List(context.Context, *ListScanResultsRequest) (*ListScanResultsResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method List not implemented")
}
func (UnimplementedScannerServiceServer) ListVulnerabilities(context.Context, *ListVulnerabilitiesRequest) (*ListVulnerabilitiesResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method ListVulnerabilities not implemented")
}

// UnsafeScannerServiceServer may be embedded to opt out of forward compatibility for this service.
// Use of this interface is not recommended, as added methods to ScannerServiceServer will
// result in compilation errors.
type UnsafeScannerServiceServer interface {
	mustEmbedUnimplementedScannerServiceServer()
}

func RegisterScannerServiceServer(s grpc.ServiceRegistrar, srv ScannerServiceServer) {
	s.RegisterService(&ScannerService_ServiceDesc, srv)
}

func _ScannerService_Scan_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ScanRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ScannerServiceServer).Scan(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: ScannerService_Scan_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ScannerServiceServer).Scan(ctx, req.(*ScanRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _ScannerService_Get_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GetScanResultRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ScannerServiceServer).Get(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: ScannerService_Get_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ScannerServiceServer).Get(ctx, req.(*GetScanResultRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _ScannerService_GetLast_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GetLastScanResultRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ScannerServiceServer).GetLast(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: ScannerService_GetLast_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ScannerServiceServer).GetLast(ctx, req.(*GetLastScanResultRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _ScannerService_List_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ListScanResultsRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ScannerServiceServer).List(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: ScannerService_List_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ScannerServiceServer).List(ctx, req.(*ListScanResultsRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _ScannerService_ListVulnerabilities_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ListVulnerabilitiesRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ScannerServiceServer).ListVulnerabilities(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: ScannerService_ListVulnerabilities_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ScannerServiceServer).ListVulnerabilities(ctx, req.(*ListVulnerabilitiesRequest))
	}
	return interceptor(ctx, in, info, handler)
}

// ScannerService_ServiceDesc is the grpc.ServiceDesc for ScannerService service.
// It's only intended for direct use with grpc.RegisterService,
// and not to be introspected or modified (even as a copy)
var ScannerService_ServiceDesc = grpc.ServiceDesc{
	ServiceName: "yandex.cloud.containerregistry.v1.ScannerService",
	HandlerType: (*ScannerServiceServer)(nil),
	Methods: []grpc.MethodDesc{
		{
			MethodName: "Scan",
			Handler:    _ScannerService_Scan_Handler,
		},
		{
			MethodName: "Get",
			Handler:    _ScannerService_Get_Handler,
		},
		{
			MethodName: "GetLast",
			Handler:    _ScannerService_GetLast_Handler,
		},
		{
			MethodName: "List",
			Handler:    _ScannerService_List_Handler,
		},
		{
			MethodName: "ListVulnerabilities",
			Handler:    _ScannerService_ListVulnerabilities_Handler,
		},
	},
	Streams:  []grpc.StreamDesc{},
	Metadata: "yandex/cloud/containerregistry/v1/scanner_service.proto",
}
