// Code generated by protoc-gen-go. DO NOT EDIT.
// versions:
// 	protoc-gen-go v1.29.0
// 	protoc        v3.17.3
// source: yandex/cloud/mdb/opensearch/v1/cluster.proto

package opensearch

import (
	config "github.com/yandex-cloud/go-genproto/yandex/cloud/mdb/opensearch/v1/config"
	protoreflect "google.golang.org/protobuf/reflect/protoreflect"
	protoimpl "google.golang.org/protobuf/runtime/protoimpl"
	timestamppb "google.golang.org/protobuf/types/known/timestamppb"
	reflect "reflect"
	sync "sync"
)

const (
	// Verify that this generated code is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(20 - protoimpl.MinVersion)
	// Verify that runtime/protoimpl is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(protoimpl.MaxVersion - 20)
)

type Cluster_Environment int32

const (
	Cluster_ENVIRONMENT_UNSPECIFIED Cluster_Environment = 0
	// Stable environment with a conservative update policy:
	// only hotfixes are applied during regular maintenance.
	Cluster_PRODUCTION Cluster_Environment = 1
	// Environment with more aggressive update policy: new versions
	// are rolled out irrespective of backward compatibility.
	Cluster_PRESTABLE Cluster_Environment = 2
)

// Enum value maps for Cluster_Environment.
var (
	Cluster_Environment_name = map[int32]string{
		0: "ENVIRONMENT_UNSPECIFIED",
		1: "PRODUCTION",
		2: "PRESTABLE",
	}
	Cluster_Environment_value = map[string]int32{
		"ENVIRONMENT_UNSPECIFIED": 0,
		"PRODUCTION":              1,
		"PRESTABLE":               2,
	}
)

func (x Cluster_Environment) Enum() *Cluster_Environment {
	p := new(Cluster_Environment)
	*p = x
	return p
}

func (x Cluster_Environment) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (Cluster_Environment) Descriptor() protoreflect.EnumDescriptor {
	return file_yandex_cloud_mdb_opensearch_v1_cluster_proto_enumTypes[0].Descriptor()
}

func (Cluster_Environment) Type() protoreflect.EnumType {
	return &file_yandex_cloud_mdb_opensearch_v1_cluster_proto_enumTypes[0]
}

func (x Cluster_Environment) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use Cluster_Environment.Descriptor instead.
func (Cluster_Environment) EnumDescriptor() ([]byte, []int) {
	return file_yandex_cloud_mdb_opensearch_v1_cluster_proto_rawDescGZIP(), []int{0, 0}
}

type Cluster_Health int32

const (
	// Health of the cluster is unknown ([Host.health] for every host in the cluster is UNKNOWN).
	Cluster_HEALTH_UNKNOWN Cluster_Health = 0
	// Cluster is working normally ([Host.health] for every host in the cluster is ALIVE).
	Cluster_ALIVE Cluster_Health = 1
	// Cluster is inoperable ([Host.health] for every host in the cluster is DEAD).
	Cluster_DEAD Cluster_Health = 2
	// Cluster is working below capacity ([Host.health] for at least one host in the cluster is not ALIVE).
	Cluster_DEGRADED Cluster_Health = 3
)

// Enum value maps for Cluster_Health.
var (
	Cluster_Health_name = map[int32]string{
		0: "HEALTH_UNKNOWN",
		1: "ALIVE",
		2: "DEAD",
		3: "DEGRADED",
	}
	Cluster_Health_value = map[string]int32{
		"HEALTH_UNKNOWN": 0,
		"ALIVE":          1,
		"DEAD":           2,
		"DEGRADED":       3,
	}
)

func (x Cluster_Health) Enum() *Cluster_Health {
	p := new(Cluster_Health)
	*p = x
	return p
}

func (x Cluster_Health) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (Cluster_Health) Descriptor() protoreflect.EnumDescriptor {
	return file_yandex_cloud_mdb_opensearch_v1_cluster_proto_enumTypes[1].Descriptor()
}

func (Cluster_Health) Type() protoreflect.EnumType {
	return &file_yandex_cloud_mdb_opensearch_v1_cluster_proto_enumTypes[1]
}

func (x Cluster_Health) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use Cluster_Health.Descriptor instead.
func (Cluster_Health) EnumDescriptor() ([]byte, []int) {
	return file_yandex_cloud_mdb_opensearch_v1_cluster_proto_rawDescGZIP(), []int{0, 1}
}

// Current state of the cluster.
type Cluster_Status int32

const (
	// Cluster state is unknown.
	Cluster_STATUS_UNKNOWN Cluster_Status = 0
	// Cluster is being created.
	Cluster_CREATING Cluster_Status = 1
	// Cluster is running normally.
	Cluster_RUNNING Cluster_Status = 2
	// Cluster has encountered a problem and cannot operate.
	Cluster_ERROR Cluster_Status = 3
	// Cluster is being updated.
	Cluster_UPDATING Cluster_Status = 4
	// Cluster is stopping.
	Cluster_STOPPING Cluster_Status = 5
	// Cluster has stopped.
	Cluster_STOPPED Cluster_Status = 6
	// Cluster is starting.
	Cluster_STARTING Cluster_Status = 7
)

// Enum value maps for Cluster_Status.
var (
	Cluster_Status_name = map[int32]string{
		0: "STATUS_UNKNOWN",
		1: "CREATING",
		2: "RUNNING",
		3: "ERROR",
		4: "UPDATING",
		5: "STOPPING",
		6: "STOPPED",
		7: "STARTING",
	}
	Cluster_Status_value = map[string]int32{
		"STATUS_UNKNOWN": 0,
		"CREATING":       1,
		"RUNNING":        2,
		"ERROR":          3,
		"UPDATING":       4,
		"STOPPING":       5,
		"STOPPED":        6,
		"STARTING":       7,
	}
)

func (x Cluster_Status) Enum() *Cluster_Status {
	p := new(Cluster_Status)
	*p = x
	return p
}

func (x Cluster_Status) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (Cluster_Status) Descriptor() protoreflect.EnumDescriptor {
	return file_yandex_cloud_mdb_opensearch_v1_cluster_proto_enumTypes[2].Descriptor()
}

func (Cluster_Status) Type() protoreflect.EnumType {
	return &file_yandex_cloud_mdb_opensearch_v1_cluster_proto_enumTypes[2]
}

func (x Cluster_Status) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use Cluster_Status.Descriptor instead.
func (Cluster_Status) EnumDescriptor() ([]byte, []int) {
	return file_yandex_cloud_mdb_opensearch_v1_cluster_proto_rawDescGZIP(), []int{0, 2}
}

type OpenSearch_GroupRole int32

const (
	OpenSearch_GROUP_ROLE_UNSPECIFIED OpenSearch_GroupRole = 0
	OpenSearch_DATA                   OpenSearch_GroupRole = 1
	OpenSearch_MANAGER                OpenSearch_GroupRole = 2
)

// Enum value maps for OpenSearch_GroupRole.
var (
	OpenSearch_GroupRole_name = map[int32]string{
		0: "GROUP_ROLE_UNSPECIFIED",
		1: "DATA",
		2: "MANAGER",
	}
	OpenSearch_GroupRole_value = map[string]int32{
		"GROUP_ROLE_UNSPECIFIED": 0,
		"DATA":                   1,
		"MANAGER":                2,
	}
)

func (x OpenSearch_GroupRole) Enum() *OpenSearch_GroupRole {
	p := new(OpenSearch_GroupRole)
	*p = x
	return p
}

func (x OpenSearch_GroupRole) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (OpenSearch_GroupRole) Descriptor() protoreflect.EnumDescriptor {
	return file_yandex_cloud_mdb_opensearch_v1_cluster_proto_enumTypes[3].Descriptor()
}

func (OpenSearch_GroupRole) Type() protoreflect.EnumType {
	return &file_yandex_cloud_mdb_opensearch_v1_cluster_proto_enumTypes[3]
}

func (x OpenSearch_GroupRole) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use OpenSearch_GroupRole.Descriptor instead.
func (OpenSearch_GroupRole) EnumDescriptor() ([]byte, []int) {
	return file_yandex_cloud_mdb_opensearch_v1_cluster_proto_rawDescGZIP(), []int{3, 0}
}

type Host_Health int32

const (
	// Health of the host is unknown.
	Host_UNKNOWN Host_Health = 0
	// The host is performing all its functions normally.
	Host_ALIVE Host_Health = 1
	// The host is inoperable and cannot perform any of its essential functions.
	Host_DEAD Host_Health = 2
	// The host is working below capacity or not fully functional.
	Host_DEGRADED Host_Health = 3
)

// Enum value maps for Host_Health.
var (
	Host_Health_name = map[int32]string{
		0: "UNKNOWN",
		1: "ALIVE",
		2: "DEAD",
		3: "DEGRADED",
	}
	Host_Health_value = map[string]int32{
		"UNKNOWN":  0,
		"ALIVE":    1,
		"DEAD":     2,
		"DEGRADED": 3,
	}
)

func (x Host_Health) Enum() *Host_Health {
	p := new(Host_Health)
	*p = x
	return p
}

func (x Host_Health) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (Host_Health) Descriptor() protoreflect.EnumDescriptor {
	return file_yandex_cloud_mdb_opensearch_v1_cluster_proto_enumTypes[4].Descriptor()
}

func (Host_Health) Type() protoreflect.EnumType {
	return &file_yandex_cloud_mdb_opensearch_v1_cluster_proto_enumTypes[4]
}

func (x Host_Health) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use Host_Health.Descriptor instead.
func (Host_Health) EnumDescriptor() ([]byte, []int) {
	return file_yandex_cloud_mdb_opensearch_v1_cluster_proto_rawDescGZIP(), []int{6, 0}
}

type Host_Type int32

const (
	// The type is not specified.
	Host_TYPE_UNSPECIFIED Host_Type = 0
	// An OpenSearch type host.
	Host_OPENSEARCH Host_Type = 1
	// A Dashboards type host.
	Host_DASHBOARDS Host_Type = 2
)

// Enum value maps for Host_Type.
var (
	Host_Type_name = map[int32]string{
		0: "TYPE_UNSPECIFIED",
		1: "OPENSEARCH",
		2: "DASHBOARDS",
	}
	Host_Type_value = map[string]int32{
		"TYPE_UNSPECIFIED": 0,
		"OPENSEARCH":       1,
		"DASHBOARDS":       2,
	}
)

func (x Host_Type) Enum() *Host_Type {
	p := new(Host_Type)
	*p = x
	return p
}

func (x Host_Type) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (Host_Type) Descriptor() protoreflect.EnumDescriptor {
	return file_yandex_cloud_mdb_opensearch_v1_cluster_proto_enumTypes[5].Descriptor()
}

func (Host_Type) Type() protoreflect.EnumType {
	return &file_yandex_cloud_mdb_opensearch_v1_cluster_proto_enumTypes[5]
}

func (x Host_Type) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use Host_Type.Descriptor instead.
func (Host_Type) EnumDescriptor() ([]byte, []int) {
	return file_yandex_cloud_mdb_opensearch_v1_cluster_proto_rawDescGZIP(), []int{6, 1}
}

// An OpenSearch cluster resource.
type Cluster struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// ID of the OpenSearch cluster.
	// This ID is assigned by the platform at the moment of cluster creation.
	Id string `protobuf:"bytes,1,opt,name=id,proto3" json:"id,omitempty"`
	// ID of the folder that the OpenSearch cluster belongs to.
	FolderId string `protobuf:"bytes,2,opt,name=folder_id,json=folderId,proto3" json:"folder_id,omitempty"`
	// Time when the cluster was created.
	CreatedAt *timestamppb.Timestamp `protobuf:"bytes,3,opt,name=created_at,json=createdAt,proto3" json:"created_at,omitempty"`
	// Name of the OpenSearch cluster.
	// The name is unique within the folder. 1-63 characters long.
	Name string `protobuf:"bytes,4,opt,name=name,proto3" json:"name,omitempty"`
	// Description of the OpenSearch cluster. 0-256 characters long.
	Description string `protobuf:"bytes,5,opt,name=description,proto3" json:"description,omitempty"`
	// Custom labels for the OpenSearch cluster as `key:value` pairs.
	// Maximum 64 labels per resource.
	Labels map[string]string `protobuf:"bytes,6,rep,name=labels,proto3" json:"labels,omitempty" protobuf_key:"bytes,1,opt,name=key,proto3" protobuf_val:"bytes,2,opt,name=value,proto3"`
	// Deployment environment of the OpenSearch cluster.
	Environment Cluster_Environment `protobuf:"varint,7,opt,name=environment,proto3,enum=yandex.cloud.mdb.opensearch.v1.Cluster_Environment" json:"environment,omitempty"`
	// Description of monitoring systems relevant to the OpenSearch cluster.
	Monitoring []*Monitoring `protobuf:"bytes,8,rep,name=monitoring,proto3" json:"monitoring,omitempty"`
	// Configuration of the OpenSearch cluster.
	Config *ClusterConfig `protobuf:"bytes,9,opt,name=config,proto3" json:"config,omitempty"`
	// ID of the cloud network that the cluster belongs to.
	NetworkId string `protobuf:"bytes,10,opt,name=network_id,json=networkId,proto3" json:"network_id,omitempty"`
	// Aggregated cluster health.
	Health Cluster_Health `protobuf:"varint,11,opt,name=health,proto3,enum=yandex.cloud.mdb.opensearch.v1.Cluster_Health" json:"health,omitempty"`
	// Current state of the cluster.
	Status Cluster_Status `protobuf:"varint,12,opt,name=status,proto3,enum=yandex.cloud.mdb.opensearch.v1.Cluster_Status" json:"status,omitempty"`
	// User security groups.
	SecurityGroupIds []string `protobuf:"bytes,13,rep,name=security_group_ids,json=securityGroupIds,proto3" json:"security_group_ids,omitempty"`
	// ID of the service account used to access Object Storage.
	ServiceAccountId string `protobuf:"bytes,14,opt,name=service_account_id,json=serviceAccountId,proto3" json:"service_account_id,omitempty"`
	// Determines whether the cluster is protected from being deleted.
	DeletionProtection bool `protobuf:"varint,15,opt,name=deletion_protection,json=deletionProtection,proto3" json:"deletion_protection,omitempty"`
	// Cluster maintenance window. Should be defined by either one of the two options.
	MaintenanceWindow *MaintenanceWindow `protobuf:"bytes,16,opt,name=maintenance_window,json=maintenanceWindow,proto3" json:"maintenance_window,omitempty"`
	// Maintenance operation planned at nearest [maintenance_window].
	PlannedOperation *MaintenanceOperation `protobuf:"bytes,17,opt,name=planned_operation,json=plannedOperation,proto3" json:"planned_operation,omitempty"`
}

func (x *Cluster) Reset() {
	*x = Cluster{}
	if protoimpl.UnsafeEnabled {
		mi := &file_yandex_cloud_mdb_opensearch_v1_cluster_proto_msgTypes[0]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *Cluster) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Cluster) ProtoMessage() {}

func (x *Cluster) ProtoReflect() protoreflect.Message {
	mi := &file_yandex_cloud_mdb_opensearch_v1_cluster_proto_msgTypes[0]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Cluster.ProtoReflect.Descriptor instead.
func (*Cluster) Descriptor() ([]byte, []int) {
	return file_yandex_cloud_mdb_opensearch_v1_cluster_proto_rawDescGZIP(), []int{0}
}

func (x *Cluster) GetId() string {
	if x != nil {
		return x.Id
	}
	return ""
}

func (x *Cluster) GetFolderId() string {
	if x != nil {
		return x.FolderId
	}
	return ""
}

func (x *Cluster) GetCreatedAt() *timestamppb.Timestamp {
	if x != nil {
		return x.CreatedAt
	}
	return nil
}

func (x *Cluster) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

func (x *Cluster) GetDescription() string {
	if x != nil {
		return x.Description
	}
	return ""
}

func (x *Cluster) GetLabels() map[string]string {
	if x != nil {
		return x.Labels
	}
	return nil
}

func (x *Cluster) GetEnvironment() Cluster_Environment {
	if x != nil {
		return x.Environment
	}
	return Cluster_ENVIRONMENT_UNSPECIFIED
}

func (x *Cluster) GetMonitoring() []*Monitoring {
	if x != nil {
		return x.Monitoring
	}
	return nil
}

func (x *Cluster) GetConfig() *ClusterConfig {
	if x != nil {
		return x.Config
	}
	return nil
}

func (x *Cluster) GetNetworkId() string {
	if x != nil {
		return x.NetworkId
	}
	return ""
}

func (x *Cluster) GetHealth() Cluster_Health {
	if x != nil {
		return x.Health
	}
	return Cluster_HEALTH_UNKNOWN
}

func (x *Cluster) GetStatus() Cluster_Status {
	if x != nil {
		return x.Status
	}
	return Cluster_STATUS_UNKNOWN
}

func (x *Cluster) GetSecurityGroupIds() []string {
	if x != nil {
		return x.SecurityGroupIds
	}
	return nil
}

func (x *Cluster) GetServiceAccountId() string {
	if x != nil {
		return x.ServiceAccountId
	}
	return ""
}

func (x *Cluster) GetDeletionProtection() bool {
	if x != nil {
		return x.DeletionProtection
	}
	return false
}

func (x *Cluster) GetMaintenanceWindow() *MaintenanceWindow {
	if x != nil {
		return x.MaintenanceWindow
	}
	return nil
}

func (x *Cluster) GetPlannedOperation() *MaintenanceOperation {
	if x != nil {
		return x.PlannedOperation
	}
	return nil
}

// Monitoring system metadata.
type Monitoring struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Name of the monitoring system.
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// Description of the monitoring system.
	Description string `protobuf:"bytes,2,opt,name=description,proto3" json:"description,omitempty"`
	// Link to the monitoring system charts for the OpenSearch cluster.
	Link string `protobuf:"bytes,3,opt,name=link,proto3" json:"link,omitempty"`
}

func (x *Monitoring) Reset() {
	*x = Monitoring{}
	if protoimpl.UnsafeEnabled {
		mi := &file_yandex_cloud_mdb_opensearch_v1_cluster_proto_msgTypes[1]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *Monitoring) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Monitoring) ProtoMessage() {}

func (x *Monitoring) ProtoReflect() protoreflect.Message {
	mi := &file_yandex_cloud_mdb_opensearch_v1_cluster_proto_msgTypes[1]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Monitoring.ProtoReflect.Descriptor instead.
func (*Monitoring) Descriptor() ([]byte, []int) {
	return file_yandex_cloud_mdb_opensearch_v1_cluster_proto_rawDescGZIP(), []int{1}
}

func (x *Monitoring) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

func (x *Monitoring) GetDescription() string {
	if x != nil {
		return x.Description
	}
	return ""
}

func (x *Monitoring) GetLink() string {
	if x != nil {
		return x.Link
	}
	return ""
}

// The OpenSearch cluster configuration.
type ClusterConfig struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Version of the OpenSearch server software.
	Version string `protobuf:"bytes,1,opt,name=version,proto3" json:"version,omitempty"`
	// OpenSearch configuration.
	Opensearch *OpenSearch `protobuf:"bytes,2,opt,name=opensearch,proto3" json:"opensearch,omitempty"`
	// Dashboards configuration.
	Dashboards *Dashboards `protobuf:"bytes,3,opt,name=dashboards,proto3" json:"dashboards,omitempty"`
	// Access policy for external services.
	Access *Access `protobuf:"bytes,4,opt,name=access,proto3" json:"access,omitempty"`
}

func (x *ClusterConfig) Reset() {
	*x = ClusterConfig{}
	if protoimpl.UnsafeEnabled {
		mi := &file_yandex_cloud_mdb_opensearch_v1_cluster_proto_msgTypes[2]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ClusterConfig) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ClusterConfig) ProtoMessage() {}

func (x *ClusterConfig) ProtoReflect() protoreflect.Message {
	mi := &file_yandex_cloud_mdb_opensearch_v1_cluster_proto_msgTypes[2]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ClusterConfig.ProtoReflect.Descriptor instead.
func (*ClusterConfig) Descriptor() ([]byte, []int) {
	return file_yandex_cloud_mdb_opensearch_v1_cluster_proto_rawDescGZIP(), []int{2}
}

func (x *ClusterConfig) GetVersion() string {
	if x != nil {
		return x.Version
	}
	return ""
}

func (x *ClusterConfig) GetOpensearch() *OpenSearch {
	if x != nil {
		return x.Opensearch
	}
	return nil
}

func (x *ClusterConfig) GetDashboards() *Dashboards {
	if x != nil {
		return x.Dashboards
	}
	return nil
}

func (x *ClusterConfig) GetAccess() *Access {
	if x != nil {
		return x.Access
	}
	return nil
}

// The OpenSearch host group type configuration.
type OpenSearch struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Names of the cluster plugins.
	Plugins []string `protobuf:"bytes,1,rep,name=plugins,proto3" json:"plugins,omitempty"`
	// Host groups of the OpenSearch type.
	NodeGroups []*OpenSearch_NodeGroup `protobuf:"bytes,2,rep,name=node_groups,json=nodeGroups,proto3" json:"node_groups,omitempty"`
	// Types that are assignable to Config:
	//
	//	*OpenSearch_OpensearchConfigSet_2
	Config isOpenSearch_Config `protobuf_oneof:"config"`
}

func (x *OpenSearch) Reset() {
	*x = OpenSearch{}
	if protoimpl.UnsafeEnabled {
		mi := &file_yandex_cloud_mdb_opensearch_v1_cluster_proto_msgTypes[3]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *OpenSearch) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*OpenSearch) ProtoMessage() {}

func (x *OpenSearch) ProtoReflect() protoreflect.Message {
	mi := &file_yandex_cloud_mdb_opensearch_v1_cluster_proto_msgTypes[3]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use OpenSearch.ProtoReflect.Descriptor instead.
func (*OpenSearch) Descriptor() ([]byte, []int) {
	return file_yandex_cloud_mdb_opensearch_v1_cluster_proto_rawDescGZIP(), []int{3}
}

func (x *OpenSearch) GetPlugins() []string {
	if x != nil {
		return x.Plugins
	}
	return nil
}

func (x *OpenSearch) GetNodeGroups() []*OpenSearch_NodeGroup {
	if x != nil {
		return x.NodeGroups
	}
	return nil
}

func (m *OpenSearch) GetConfig() isOpenSearch_Config {
	if m != nil {
		return m.Config
	}
	return nil
}

func (x *OpenSearch) GetOpensearchConfigSet_2() *config.OpenSearchConfigSet2 {
	if x, ok := x.GetConfig().(*OpenSearch_OpensearchConfigSet_2); ok {
		return x.OpensearchConfigSet_2
	}
	return nil
}

type isOpenSearch_Config interface {
	isOpenSearch_Config()
}

type OpenSearch_OpensearchConfigSet_2 struct {
	OpensearchConfigSet_2 *config.OpenSearchConfigSet2 `protobuf:"bytes,3,opt,name=opensearch_config_set_2,json=opensearchConfigSet_2,proto3,oneof"`
}

func (*OpenSearch_OpensearchConfigSet_2) isOpenSearch_Config() {}

// The Dashboards host group type configuration.
type Dashboards struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Host groups of the Dashboards type.
	NodeGroups []*Dashboards_NodeGroup `protobuf:"bytes,2,rep,name=node_groups,json=nodeGroups,proto3" json:"node_groups,omitempty"`
}

func (x *Dashboards) Reset() {
	*x = Dashboards{}
	if protoimpl.UnsafeEnabled {
		mi := &file_yandex_cloud_mdb_opensearch_v1_cluster_proto_msgTypes[4]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *Dashboards) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Dashboards) ProtoMessage() {}

func (x *Dashboards) ProtoReflect() protoreflect.Message {
	mi := &file_yandex_cloud_mdb_opensearch_v1_cluster_proto_msgTypes[4]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Dashboards.ProtoReflect.Descriptor instead.
func (*Dashboards) Descriptor() ([]byte, []int) {
	return file_yandex_cloud_mdb_opensearch_v1_cluster_proto_rawDescGZIP(), []int{4}
}

func (x *Dashboards) GetNodeGroups() []*Dashboards_NodeGroup {
	if x != nil {
		return x.NodeGroups
	}
	return nil
}

// A list of computational resources allocated to a host.
type Resources struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// ID of the preset for computational resources allocated to a host.
	ResourcePresetId string `protobuf:"bytes,1,opt,name=resource_preset_id,json=resourcePresetId,proto3" json:"resource_preset_id,omitempty"`
	// Volume of the storage used by the host, in bytes.
	DiskSize int64 `protobuf:"varint,2,opt,name=disk_size,json=diskSize,proto3" json:"disk_size,omitempty"`
	// Type of the storage used by the host: `network-hdd`, `network-ssd` or `local-ssd`.
	DiskTypeId string `protobuf:"bytes,3,opt,name=disk_type_id,json=diskTypeId,proto3" json:"disk_type_id,omitempty"`
}

func (x *Resources) Reset() {
	*x = Resources{}
	if protoimpl.UnsafeEnabled {
		mi := &file_yandex_cloud_mdb_opensearch_v1_cluster_proto_msgTypes[5]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *Resources) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Resources) ProtoMessage() {}

func (x *Resources) ProtoReflect() protoreflect.Message {
	mi := &file_yandex_cloud_mdb_opensearch_v1_cluster_proto_msgTypes[5]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Resources.ProtoReflect.Descriptor instead.
func (*Resources) Descriptor() ([]byte, []int) {
	return file_yandex_cloud_mdb_opensearch_v1_cluster_proto_rawDescGZIP(), []int{5}
}

func (x *Resources) GetResourcePresetId() string {
	if x != nil {
		return x.ResourcePresetId
	}
	return ""
}

func (x *Resources) GetDiskSize() int64 {
	if x != nil {
		return x.DiskSize
	}
	return 0
}

func (x *Resources) GetDiskTypeId() string {
	if x != nil {
		return x.DiskTypeId
	}
	return ""
}

// An OpenSearch cluster host resource.
type Host struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. Name of the OpenSearch host.
	//
	// The host name is assigned by the platform at creation time and cannot be changed.
	//
	// The name is unique across all MDB hosts that exist on the platform, as it defines the FQDN of the host.
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// Required. ID of the OpenSearch cluster. The ID is assigned by the platform at creation time.
	ClusterId string `protobuf:"bytes,2,opt,name=cluster_id,json=clusterId,proto3" json:"cluster_id,omitempty"`
	// ID of the availability zone the OpenSearch host belongs to.
	ZoneId string `protobuf:"bytes,3,opt,name=zone_id,json=zoneId,proto3" json:"zone_id,omitempty"`
	// Resources allocated to the OpenSearch host.
	Resources *Resources `protobuf:"bytes,4,opt,name=resources,proto3" json:"resources,omitempty"`
	// Type of the host.
	Type Host_Type `protobuf:"varint,5,opt,name=type,proto3,enum=yandex.cloud.mdb.opensearch.v1.Host_Type" json:"type,omitempty"`
	// Status code of the aggregated health of the host.
	Health Host_Health `protobuf:"varint,6,opt,name=health,proto3,enum=yandex.cloud.mdb.opensearch.v1.Host_Health" json:"health,omitempty"`
	// ID of the subnet that the host belongs to.
	SubnetId string `protobuf:"bytes,8,opt,name=subnet_id,json=subnetId,proto3" json:"subnet_id,omitempty"`
	// Determines whether a public IP is assigned to the host.
	AssignPublicIp bool `protobuf:"varint,9,opt,name=assign_public_ip,json=assignPublicIp,proto3" json:"assign_public_ip,omitempty"`
	// Resources used by the host.
	System *Host_SystemMetrics `protobuf:"bytes,10,opt,name=system,proto3" json:"system,omitempty"`
	// Name of the host group that the host belongs to.
	NodeGroup string `protobuf:"bytes,11,opt,name=node_group,json=nodeGroup,proto3" json:"node_group,omitempty"`
	// Roles of the host.
	Roles []OpenSearch_GroupRole `protobuf:"varint,12,rep,packed,name=roles,proto3,enum=yandex.cloud.mdb.opensearch.v1.OpenSearch_GroupRole" json:"roles,omitempty"`
}

func (x *Host) Reset() {
	*x = Host{}
	if protoimpl.UnsafeEnabled {
		mi := &file_yandex_cloud_mdb_opensearch_v1_cluster_proto_msgTypes[6]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *Host) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Host) ProtoMessage() {}

func (x *Host) ProtoReflect() protoreflect.Message {
	mi := &file_yandex_cloud_mdb_opensearch_v1_cluster_proto_msgTypes[6]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Host.ProtoReflect.Descriptor instead.
func (*Host) Descriptor() ([]byte, []int) {
	return file_yandex_cloud_mdb_opensearch_v1_cluster_proto_rawDescGZIP(), []int{6}
}

func (x *Host) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

func (x *Host) GetClusterId() string {
	if x != nil {
		return x.ClusterId
	}
	return ""
}

func (x *Host) GetZoneId() string {
	if x != nil {
		return x.ZoneId
	}
	return ""
}

func (x *Host) GetResources() *Resources {
	if x != nil {
		return x.Resources
	}
	return nil
}

func (x *Host) GetType() Host_Type {
	if x != nil {
		return x.Type
	}
	return Host_TYPE_UNSPECIFIED
}

func (x *Host) GetHealth() Host_Health {
	if x != nil {
		return x.Health
	}
	return Host_UNKNOWN
}

func (x *Host) GetSubnetId() string {
	if x != nil {
		return x.SubnetId
	}
	return ""
}

func (x *Host) GetAssignPublicIp() bool {
	if x != nil {
		return x.AssignPublicIp
	}
	return false
}

func (x *Host) GetSystem() *Host_SystemMetrics {
	if x != nil {
		return x.System
	}
	return nil
}

func (x *Host) GetNodeGroup() string {
	if x != nil {
		return x.NodeGroup
	}
	return ""
}

func (x *Host) GetRoles() []OpenSearch_GroupRole {
	if x != nil {
		return x.Roles
	}
	return nil
}

// Access policy for external services.
type Access struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Determines whether the access to Data Transfer is allowed.
	DataTransfer bool `protobuf:"varint,1,opt,name=data_transfer,json=dataTransfer,proto3" json:"data_transfer,omitempty"`
	// Determines whether the access to Serverless is allowed.
	Serverless bool `protobuf:"varint,2,opt,name=serverless,proto3" json:"serverless,omitempty"`
}

func (x *Access) Reset() {
	*x = Access{}
	if protoimpl.UnsafeEnabled {
		mi := &file_yandex_cloud_mdb_opensearch_v1_cluster_proto_msgTypes[7]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *Access) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Access) ProtoMessage() {}

func (x *Access) ProtoReflect() protoreflect.Message {
	mi := &file_yandex_cloud_mdb_opensearch_v1_cluster_proto_msgTypes[7]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Access.ProtoReflect.Descriptor instead.
func (*Access) Descriptor() ([]byte, []int) {
	return file_yandex_cloud_mdb_opensearch_v1_cluster_proto_rawDescGZIP(), []int{7}
}

func (x *Access) GetDataTransfer() bool {
	if x != nil {
		return x.DataTransfer
	}
	return false
}

func (x *Access) GetServerless() bool {
	if x != nil {
		return x.Serverless
	}
	return false
}

// Configuration of the host group.
type OpenSearch_NodeGroup struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Name of the group. Must be 1-63 characters long.
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// Resources allocated to the hosts.
	Resources *Resources `protobuf:"bytes,2,opt,name=resources,proto3" json:"resources,omitempty"`
	// Number of hosts in the group.
	HostsCount int64 `protobuf:"varint,3,opt,name=hosts_count,json=hostsCount,proto3" json:"hosts_count,omitempty"`
	// IDs of the availability zones the hosts belong to.
	ZoneIds []string `protobuf:"bytes,4,rep,name=zone_ids,json=zoneIds,proto3" json:"zone_ids,omitempty"`
	// IDs of the subnets that the hosts belong to.
	SubnetIds []string `protobuf:"bytes,5,rep,name=subnet_ids,json=subnetIds,proto3" json:"subnet_ids,omitempty"`
	// Determines whether a public IP is assigned to the hosts in the group.
	AssignPublicIp bool `protobuf:"varint,6,opt,name=assign_public_ip,json=assignPublicIp,proto3" json:"assign_public_ip,omitempty"`
	// Roles of the host group.
	Roles []OpenSearch_GroupRole `protobuf:"varint,7,rep,packed,name=roles,proto3,enum=yandex.cloud.mdb.opensearch.v1.OpenSearch_GroupRole" json:"roles,omitempty"`
}

func (x *OpenSearch_NodeGroup) Reset() {
	*x = OpenSearch_NodeGroup{}
	if protoimpl.UnsafeEnabled {
		mi := &file_yandex_cloud_mdb_opensearch_v1_cluster_proto_msgTypes[9]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *OpenSearch_NodeGroup) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*OpenSearch_NodeGroup) ProtoMessage() {}

func (x *OpenSearch_NodeGroup) ProtoReflect() protoreflect.Message {
	mi := &file_yandex_cloud_mdb_opensearch_v1_cluster_proto_msgTypes[9]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use OpenSearch_NodeGroup.ProtoReflect.Descriptor instead.
func (*OpenSearch_NodeGroup) Descriptor() ([]byte, []int) {
	return file_yandex_cloud_mdb_opensearch_v1_cluster_proto_rawDescGZIP(), []int{3, 0}
}

func (x *OpenSearch_NodeGroup) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

func (x *OpenSearch_NodeGroup) GetResources() *Resources {
	if x != nil {
		return x.Resources
	}
	return nil
}

func (x *OpenSearch_NodeGroup) GetHostsCount() int64 {
	if x != nil {
		return x.HostsCount
	}
	return 0
}

func (x *OpenSearch_NodeGroup) GetZoneIds() []string {
	if x != nil {
		return x.ZoneIds
	}
	return nil
}

func (x *OpenSearch_NodeGroup) GetSubnetIds() []string {
	if x != nil {
		return x.SubnetIds
	}
	return nil
}

func (x *OpenSearch_NodeGroup) GetAssignPublicIp() bool {
	if x != nil {
		return x.AssignPublicIp
	}
	return false
}

func (x *OpenSearch_NodeGroup) GetRoles() []OpenSearch_GroupRole {
	if x != nil {
		return x.Roles
	}
	return nil
}

type Dashboards_NodeGroup struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Name of the group. 1-63 characters long.
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// Resources allocated to the hosts.
	Resources *Resources `protobuf:"bytes,2,opt,name=resources,proto3" json:"resources,omitempty"`
	// Number of hosts in the group.
	HostsCount int64 `protobuf:"varint,3,opt,name=hosts_count,json=hostsCount,proto3" json:"hosts_count,omitempty"`
	// IDs of the availability zones the hosts belong to.
	ZoneIds []string `protobuf:"bytes,4,rep,name=zone_ids,json=zoneIds,proto3" json:"zone_ids,omitempty"`
	// IDs of the subnets that the hosts belong to.
	SubnetIds []string `protobuf:"bytes,5,rep,name=subnet_ids,json=subnetIds,proto3" json:"subnet_ids,omitempty"`
	// Determines whether a public IP is assigned to the hosts in the group.
	AssignPublicIp bool `protobuf:"varint,6,opt,name=assign_public_ip,json=assignPublicIp,proto3" json:"assign_public_ip,omitempty"`
}

func (x *Dashboards_NodeGroup) Reset() {
	*x = Dashboards_NodeGroup{}
	if protoimpl.UnsafeEnabled {
		mi := &file_yandex_cloud_mdb_opensearch_v1_cluster_proto_msgTypes[10]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *Dashboards_NodeGroup) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Dashboards_NodeGroup) ProtoMessage() {}

func (x *Dashboards_NodeGroup) ProtoReflect() protoreflect.Message {
	mi := &file_yandex_cloud_mdb_opensearch_v1_cluster_proto_msgTypes[10]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Dashboards_NodeGroup.ProtoReflect.Descriptor instead.
func (*Dashboards_NodeGroup) Descriptor() ([]byte, []int) {
	return file_yandex_cloud_mdb_opensearch_v1_cluster_proto_rawDescGZIP(), []int{4, 0}
}

func (x *Dashboards_NodeGroup) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

func (x *Dashboards_NodeGroup) GetResources() *Resources {
	if x != nil {
		return x.Resources
	}
	return nil
}

func (x *Dashboards_NodeGroup) GetHostsCount() int64 {
	if x != nil {
		return x.HostsCount
	}
	return 0
}

func (x *Dashboards_NodeGroup) GetZoneIds() []string {
	if x != nil {
		return x.ZoneIds
	}
	return nil
}

func (x *Dashboards_NodeGroup) GetSubnetIds() []string {
	if x != nil {
		return x.SubnetIds
	}
	return nil
}

func (x *Dashboards_NodeGroup) GetAssignPublicIp() bool {
	if x != nil {
		return x.AssignPublicIp
	}
	return false
}

// CPU usage of the host.
type Host_CPUMetric struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Time of the record.
	Timestamp int64 `protobuf:"varint,1,opt,name=timestamp,proto3" json:"timestamp,omitempty"`
	// Percentage of the CPU used.
	Used float64 `protobuf:"fixed64,2,opt,name=used,proto3" json:"used,omitempty"`
}

func (x *Host_CPUMetric) Reset() {
	*x = Host_CPUMetric{}
	if protoimpl.UnsafeEnabled {
		mi := &file_yandex_cloud_mdb_opensearch_v1_cluster_proto_msgTypes[11]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *Host_CPUMetric) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Host_CPUMetric) ProtoMessage() {}

func (x *Host_CPUMetric) ProtoReflect() protoreflect.Message {
	mi := &file_yandex_cloud_mdb_opensearch_v1_cluster_proto_msgTypes[11]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Host_CPUMetric.ProtoReflect.Descriptor instead.
func (*Host_CPUMetric) Descriptor() ([]byte, []int) {
	return file_yandex_cloud_mdb_opensearch_v1_cluster_proto_rawDescGZIP(), []int{6, 0}
}

func (x *Host_CPUMetric) GetTimestamp() int64 {
	if x != nil {
		return x.Timestamp
	}
	return 0
}

func (x *Host_CPUMetric) GetUsed() float64 {
	if x != nil {
		return x.Used
	}
	return 0
}

// RAM usage of the host.
type Host_MemoryMetric struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Time of the record.
	Timestamp int64 `protobuf:"varint,1,opt,name=timestamp,proto3" json:"timestamp,omitempty"`
	// The amount of RAM used, in bytes.
	Used int64 `protobuf:"varint,2,opt,name=used,proto3" json:"used,omitempty"`
	// Total amount of RAM allocated to the host.
	Total int64 `protobuf:"varint,3,opt,name=total,proto3" json:"total,omitempty"`
}

func (x *Host_MemoryMetric) Reset() {
	*x = Host_MemoryMetric{}
	if protoimpl.UnsafeEnabled {
		mi := &file_yandex_cloud_mdb_opensearch_v1_cluster_proto_msgTypes[12]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *Host_MemoryMetric) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Host_MemoryMetric) ProtoMessage() {}

func (x *Host_MemoryMetric) ProtoReflect() protoreflect.Message {
	mi := &file_yandex_cloud_mdb_opensearch_v1_cluster_proto_msgTypes[12]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Host_MemoryMetric.ProtoReflect.Descriptor instead.
func (*Host_MemoryMetric) Descriptor() ([]byte, []int) {
	return file_yandex_cloud_mdb_opensearch_v1_cluster_proto_rawDescGZIP(), []int{6, 1}
}

func (x *Host_MemoryMetric) GetTimestamp() int64 {
	if x != nil {
		return x.Timestamp
	}
	return 0
}

func (x *Host_MemoryMetric) GetUsed() int64 {
	if x != nil {
		return x.Used
	}
	return 0
}

func (x *Host_MemoryMetric) GetTotal() int64 {
	if x != nil {
		return x.Total
	}
	return 0
}

// Disk usage of the host.
type Host_DiskMetric struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Time of the record.
	Timestamp int64 `protobuf:"varint,1,opt,name=timestamp,proto3" json:"timestamp,omitempty"`
	// The amount of disk space used, in bytes.
	Used int64 `protobuf:"varint,2,opt,name=used,proto3" json:"used,omitempty"`
	// Total amount of disk space allocated to the host.
	Total int64 `protobuf:"varint,3,opt,name=total,proto3" json:"total,omitempty"`
}

func (x *Host_DiskMetric) Reset() {
	*x = Host_DiskMetric{}
	if protoimpl.UnsafeEnabled {
		mi := &file_yandex_cloud_mdb_opensearch_v1_cluster_proto_msgTypes[13]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *Host_DiskMetric) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Host_DiskMetric) ProtoMessage() {}

func (x *Host_DiskMetric) ProtoReflect() protoreflect.Message {
	mi := &file_yandex_cloud_mdb_opensearch_v1_cluster_proto_msgTypes[13]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Host_DiskMetric.ProtoReflect.Descriptor instead.
func (*Host_DiskMetric) Descriptor() ([]byte, []int) {
	return file_yandex_cloud_mdb_opensearch_v1_cluster_proto_rawDescGZIP(), []int{6, 2}
}

func (x *Host_DiskMetric) GetTimestamp() int64 {
	if x != nil {
		return x.Timestamp
	}
	return 0
}

func (x *Host_DiskMetric) GetUsed() int64 {
	if x != nil {
		return x.Used
	}
	return 0
}

func (x *Host_DiskMetric) GetTotal() int64 {
	if x != nil {
		return x.Total
	}
	return 0
}

// Resources used by the host.
type Host_SystemMetrics struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// CPU usage of the host.
	Cpu *Host_CPUMetric `protobuf:"bytes,1,opt,name=cpu,proto3" json:"cpu,omitempty"`
	// RAM usage of the host.
	Memory *Host_MemoryMetric `protobuf:"bytes,2,opt,name=memory,proto3" json:"memory,omitempty"`
	// Disk usage of the host.
	Disk *Host_DiskMetric `protobuf:"bytes,3,opt,name=disk,proto3" json:"disk,omitempty"`
}

func (x *Host_SystemMetrics) Reset() {
	*x = Host_SystemMetrics{}
	if protoimpl.UnsafeEnabled {
		mi := &file_yandex_cloud_mdb_opensearch_v1_cluster_proto_msgTypes[14]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *Host_SystemMetrics) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Host_SystemMetrics) ProtoMessage() {}

func (x *Host_SystemMetrics) ProtoReflect() protoreflect.Message {
	mi := &file_yandex_cloud_mdb_opensearch_v1_cluster_proto_msgTypes[14]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Host_SystemMetrics.ProtoReflect.Descriptor instead.
func (*Host_SystemMetrics) Descriptor() ([]byte, []int) {
	return file_yandex_cloud_mdb_opensearch_v1_cluster_proto_rawDescGZIP(), []int{6, 3}
}

func (x *Host_SystemMetrics) GetCpu() *Host_CPUMetric {
	if x != nil {
		return x.Cpu
	}
	return nil
}

func (x *Host_SystemMetrics) GetMemory() *Host_MemoryMetric {
	if x != nil {
		return x.Memory
	}
	return nil
}

func (x *Host_SystemMetrics) GetDisk() *Host_DiskMetric {
	if x != nil {
		return x.Disk
	}
	return nil
}

var File_yandex_cloud_mdb_opensearch_v1_cluster_proto protoreflect.FileDescriptor

var file_yandex_cloud_mdb_opensearch_v1_cluster_proto_rawDesc = []byte{
	0x0a, 0x2c, 0x79, 0x61, 0x6e, 0x64, 0x65, 0x78, 0x2f, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2f, 0x6d,
	0x64, 0x62, 0x2f, 0x6f, 0x70, 0x65, 0x6e, 0x73, 0x65, 0x61, 0x72, 0x63, 0x68, 0x2f, 0x76, 0x31,
	0x2f, 0x63, 0x6c, 0x75, 0x73, 0x74, 0x65, 0x72, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x12, 0x1e,
	0x79, 0x61, 0x6e, 0x64, 0x65, 0x78, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x6d, 0x64, 0x62,
	0x2e, 0x6f, 0x70, 0x65, 0x6e, 0x73, 0x65, 0x61, 0x72, 0x63, 0x68, 0x2e, 0x76, 0x31, 0x1a, 0x1f,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2f,
	0x74, 0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a,
	0x30, 0x79, 0x61, 0x6e, 0x64, 0x65, 0x78, 0x2f, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2f, 0x6d, 0x64,
	0x62, 0x2f, 0x6f, 0x70, 0x65, 0x6e, 0x73, 0x65, 0x61, 0x72, 0x63, 0x68, 0x2f, 0x76, 0x31, 0x2f,
	0x6d, 0x61, 0x69, 0x6e, 0x74, 0x65, 0x6e, 0x61, 0x6e, 0x63, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74,
	0x6f, 0x1a, 0x36, 0x79, 0x61, 0x6e, 0x64, 0x65, 0x78, 0x2f, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2f,
	0x6d, 0x64, 0x62, 0x2f, 0x6f, 0x70, 0x65, 0x6e, 0x73, 0x65, 0x61, 0x72, 0x63, 0x68, 0x2f, 0x76,
	0x31, 0x2f, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x2f, 0x6f, 0x70, 0x65, 0x6e, 0x73, 0x65, 0x61,
	0x72, 0x63, 0x68, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x22, 0xa1, 0x0a, 0x0a, 0x07, 0x43, 0x6c,
	0x75, 0x73, 0x74, 0x65, 0x72, 0x12, 0x0e, 0x0a, 0x02, 0x69, 0x64, 0x18, 0x01, 0x20, 0x01, 0x28,
	0x09, 0x52, 0x02, 0x69, 0x64, 0x12, 0x1b, 0x0a, 0x09, 0x66, 0x6f, 0x6c, 0x64, 0x65, 0x72, 0x5f,
	0x69, 0x64, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x08, 0x66, 0x6f, 0x6c, 0x64, 0x65, 0x72,
	0x49, 0x64, 0x12, 0x39, 0x0a, 0x0a, 0x63, 0x72, 0x65, 0x61, 0x74, 0x65, 0x64, 0x5f, 0x61, 0x74,
	0x18, 0x03, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e,
	0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x54, 0x69, 0x6d, 0x65, 0x73, 0x74, 0x61,
	0x6d, 0x70, 0x52, 0x09, 0x63, 0x72, 0x65, 0x61, 0x74, 0x65, 0x64, 0x41, 0x74, 0x12, 0x12, 0x0a,
	0x04, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x04, 0x20, 0x01, 0x28, 0x09, 0x52, 0x04, 0x6e, 0x61, 0x6d,
	0x65, 0x12, 0x20, 0x0a, 0x0b, 0x64, 0x65, 0x73, 0x63, 0x72, 0x69, 0x70, 0x74, 0x69, 0x6f, 0x6e,
	0x18, 0x05, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0b, 0x64, 0x65, 0x73, 0x63, 0x72, 0x69, 0x70, 0x74,
	0x69, 0x6f, 0x6e, 0x12, 0x4b, 0x0a, 0x06, 0x6c, 0x61, 0x62, 0x65, 0x6c, 0x73, 0x18, 0x06, 0x20,
	0x03, 0x28, 0x0b, 0x32, 0x33, 0x2e, 0x79, 0x61, 0x6e, 0x64, 0x65, 0x78, 0x2e, 0x63, 0x6c, 0x6f,
	0x75, 0x64, 0x2e, 0x6d, 0x64, 0x62, 0x2e, 0x6f, 0x70, 0x65, 0x6e, 0x73, 0x65, 0x61, 0x72, 0x63,
	0x68, 0x2e, 0x76, 0x31, 0x2e, 0x43, 0x6c, 0x75, 0x73, 0x74, 0x65, 0x72, 0x2e, 0x4c, 0x61, 0x62,
	0x65, 0x6c, 0x73, 0x45, 0x6e, 0x74, 0x72, 0x79, 0x52, 0x06, 0x6c, 0x61, 0x62, 0x65, 0x6c, 0x73,
	0x12, 0x55, 0x0a, 0x0b, 0x65, 0x6e, 0x76, 0x69, 0x72, 0x6f, 0x6e, 0x6d, 0x65, 0x6e, 0x74, 0x18,
	0x07, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x33, 0x2e, 0x79, 0x61, 0x6e, 0x64, 0x65, 0x78, 0x2e, 0x63,
	0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x6d, 0x64, 0x62, 0x2e, 0x6f, 0x70, 0x65, 0x6e, 0x73, 0x65, 0x61,
	0x72, 0x63, 0x68, 0x2e, 0x76, 0x31, 0x2e, 0x43, 0x6c, 0x75, 0x73, 0x74, 0x65, 0x72, 0x2e, 0x45,
	0x6e, 0x76, 0x69, 0x72, 0x6f, 0x6e, 0x6d, 0x65, 0x6e, 0x74, 0x52, 0x0b, 0x65, 0x6e, 0x76, 0x69,
	0x72, 0x6f, 0x6e, 0x6d, 0x65, 0x6e, 0x74, 0x12, 0x4a, 0x0a, 0x0a, 0x6d, 0x6f, 0x6e, 0x69, 0x74,
	0x6f, 0x72, 0x69, 0x6e, 0x67, 0x18, 0x08, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x2a, 0x2e, 0x79, 0x61,
	0x6e, 0x64, 0x65, 0x78, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x6d, 0x64, 0x62, 0x2e, 0x6f,
	0x70, 0x65, 0x6e, 0x73, 0x65, 0x61, 0x72, 0x63, 0x68, 0x2e, 0x76, 0x31, 0x2e, 0x4d, 0x6f, 0x6e,
	0x69, 0x74, 0x6f, 0x72, 0x69, 0x6e, 0x67, 0x52, 0x0a, 0x6d, 0x6f, 0x6e, 0x69, 0x74, 0x6f, 0x72,
	0x69, 0x6e, 0x67, 0x12, 0x45, 0x0a, 0x06, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x18, 0x09, 0x20,
	0x01, 0x28, 0x0b, 0x32, 0x2d, 0x2e, 0x79, 0x61, 0x6e, 0x64, 0x65, 0x78, 0x2e, 0x63, 0x6c, 0x6f,
	0x75, 0x64, 0x2e, 0x6d, 0x64, 0x62, 0x2e, 0x6f, 0x70, 0x65, 0x6e, 0x73, 0x65, 0x61, 0x72, 0x63,
	0x68, 0x2e, 0x76, 0x31, 0x2e, 0x43, 0x6c, 0x75, 0x73, 0x74, 0x65, 0x72, 0x43, 0x6f, 0x6e, 0x66,
	0x69, 0x67, 0x52, 0x06, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x12, 0x1d, 0x0a, 0x0a, 0x6e, 0x65,
	0x74, 0x77, 0x6f, 0x72, 0x6b, 0x5f, 0x69, 0x64, 0x18, 0x0a, 0x20, 0x01, 0x28, 0x09, 0x52, 0x09,
	0x6e, 0x65, 0x74, 0x77, 0x6f, 0x72, 0x6b, 0x49, 0x64, 0x12, 0x46, 0x0a, 0x06, 0x68, 0x65, 0x61,
	0x6c, 0x74, 0x68, 0x18, 0x0b, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x2e, 0x2e, 0x79, 0x61, 0x6e, 0x64,
	0x65, 0x78, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x6d, 0x64, 0x62, 0x2e, 0x6f, 0x70, 0x65,
	0x6e, 0x73, 0x65, 0x61, 0x72, 0x63, 0x68, 0x2e, 0x76, 0x31, 0x2e, 0x43, 0x6c, 0x75, 0x73, 0x74,
	0x65, 0x72, 0x2e, 0x48, 0x65, 0x61, 0x6c, 0x74, 0x68, 0x52, 0x06, 0x68, 0x65, 0x61, 0x6c, 0x74,
	0x68, 0x12, 0x46, 0x0a, 0x06, 0x73, 0x74, 0x61, 0x74, 0x75, 0x73, 0x18, 0x0c, 0x20, 0x01, 0x28,
	0x0e, 0x32, 0x2e, 0x2e, 0x79, 0x61, 0x6e, 0x64, 0x65, 0x78, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64,
	0x2e, 0x6d, 0x64, 0x62, 0x2e, 0x6f, 0x70, 0x65, 0x6e, 0x73, 0x65, 0x61, 0x72, 0x63, 0x68, 0x2e,
	0x76, 0x31, 0x2e, 0x43, 0x6c, 0x75, 0x73, 0x74, 0x65, 0x72, 0x2e, 0x53, 0x74, 0x61, 0x74, 0x75,
	0x73, 0x52, 0x06, 0x73, 0x74, 0x61, 0x74, 0x75, 0x73, 0x12, 0x2c, 0x0a, 0x12, 0x73, 0x65, 0x63,
	0x75, 0x72, 0x69, 0x74, 0x79, 0x5f, 0x67, 0x72, 0x6f, 0x75, 0x70, 0x5f, 0x69, 0x64, 0x73, 0x18,
	0x0d, 0x20, 0x03, 0x28, 0x09, 0x52, 0x10, 0x73, 0x65, 0x63, 0x75, 0x72, 0x69, 0x74, 0x79, 0x47,
	0x72, 0x6f, 0x75, 0x70, 0x49, 0x64, 0x73, 0x12, 0x2c, 0x0a, 0x12, 0x73, 0x65, 0x72, 0x76, 0x69,
	0x63, 0x65, 0x5f, 0x61, 0x63, 0x63, 0x6f, 0x75, 0x6e, 0x74, 0x5f, 0x69, 0x64, 0x18, 0x0e, 0x20,
	0x01, 0x28, 0x09, 0x52, 0x10, 0x73, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x41, 0x63, 0x63, 0x6f,
	0x75, 0x6e, 0x74, 0x49, 0x64, 0x12, 0x2f, 0x0a, 0x13, 0x64, 0x65, 0x6c, 0x65, 0x74, 0x69, 0x6f,
	0x6e, 0x5f, 0x70, 0x72, 0x6f, 0x74, 0x65, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x18, 0x0f, 0x20, 0x01,
	0x28, 0x08, 0x52, 0x12, 0x64, 0x65, 0x6c, 0x65, 0x74, 0x69, 0x6f, 0x6e, 0x50, 0x72, 0x6f, 0x74,
	0x65, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x60, 0x0a, 0x12, 0x6d, 0x61, 0x69, 0x6e, 0x74, 0x65,
	0x6e, 0x61, 0x6e, 0x63, 0x65, 0x5f, 0x77, 0x69, 0x6e, 0x64, 0x6f, 0x77, 0x18, 0x10, 0x20, 0x01,
	0x28, 0x0b, 0x32, 0x31, 0x2e, 0x79, 0x61, 0x6e, 0x64, 0x65, 0x78, 0x2e, 0x63, 0x6c, 0x6f, 0x75,
	0x64, 0x2e, 0x6d, 0x64, 0x62, 0x2e, 0x6f, 0x70, 0x65, 0x6e, 0x73, 0x65, 0x61, 0x72, 0x63, 0x68,
	0x2e, 0x76, 0x31, 0x2e, 0x4d, 0x61, 0x69, 0x6e, 0x74, 0x65, 0x6e, 0x61, 0x6e, 0x63, 0x65, 0x57,
	0x69, 0x6e, 0x64, 0x6f, 0x77, 0x52, 0x11, 0x6d, 0x61, 0x69, 0x6e, 0x74, 0x65, 0x6e, 0x61, 0x6e,
	0x63, 0x65, 0x57, 0x69, 0x6e, 0x64, 0x6f, 0x77, 0x12, 0x61, 0x0a, 0x11, 0x70, 0x6c, 0x61, 0x6e,
	0x6e, 0x65, 0x64, 0x5f, 0x6f, 0x70, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x18, 0x11, 0x20,
	0x01, 0x28, 0x0b, 0x32, 0x34, 0x2e, 0x79, 0x61, 0x6e, 0x64, 0x65, 0x78, 0x2e, 0x63, 0x6c, 0x6f,
	0x75, 0x64, 0x2e, 0x6d, 0x64, 0x62, 0x2e, 0x6f, 0x70, 0x65, 0x6e, 0x73, 0x65, 0x61, 0x72, 0x63,
	0x68, 0x2e, 0x76, 0x31, 0x2e, 0x4d, 0x61, 0x69, 0x6e, 0x74, 0x65, 0x6e, 0x61, 0x6e, 0x63, 0x65,
	0x4f, 0x70, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x52, 0x10, 0x70, 0x6c, 0x61, 0x6e, 0x6e,
	0x65, 0x64, 0x4f, 0x70, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x1a, 0x39, 0x0a, 0x0b, 0x4c,
	0x61, 0x62, 0x65, 0x6c, 0x73, 0x45, 0x6e, 0x74, 0x72, 0x79, 0x12, 0x10, 0x0a, 0x03, 0x6b, 0x65,
	0x79, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x03, 0x6b, 0x65, 0x79, 0x12, 0x14, 0x0a, 0x05,
	0x76, 0x61, 0x6c, 0x75, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x05, 0x76, 0x61, 0x6c,
	0x75, 0x65, 0x3a, 0x02, 0x38, 0x01, 0x22, 0x49, 0x0a, 0x0b, 0x45, 0x6e, 0x76, 0x69, 0x72, 0x6f,
	0x6e, 0x6d, 0x65, 0x6e, 0x74, 0x12, 0x1b, 0x0a, 0x17, 0x45, 0x4e, 0x56, 0x49, 0x52, 0x4f, 0x4e,
	0x4d, 0x45, 0x4e, 0x54, 0x5f, 0x55, 0x4e, 0x53, 0x50, 0x45, 0x43, 0x49, 0x46, 0x49, 0x45, 0x44,
	0x10, 0x00, 0x12, 0x0e, 0x0a, 0x0a, 0x50, 0x52, 0x4f, 0x44, 0x55, 0x43, 0x54, 0x49, 0x4f, 0x4e,
	0x10, 0x01, 0x12, 0x0d, 0x0a, 0x09, 0x50, 0x52, 0x45, 0x53, 0x54, 0x41, 0x42, 0x4c, 0x45, 0x10,
	0x02, 0x22, 0x3f, 0x0a, 0x06, 0x48, 0x65, 0x61, 0x6c, 0x74, 0x68, 0x12, 0x12, 0x0a, 0x0e, 0x48,
	0x45, 0x41, 0x4c, 0x54, 0x48, 0x5f, 0x55, 0x4e, 0x4b, 0x4e, 0x4f, 0x57, 0x4e, 0x10, 0x00, 0x12,
	0x09, 0x0a, 0x05, 0x41, 0x4c, 0x49, 0x56, 0x45, 0x10, 0x01, 0x12, 0x08, 0x0a, 0x04, 0x44, 0x45,
	0x41, 0x44, 0x10, 0x02, 0x12, 0x0c, 0x0a, 0x08, 0x44, 0x45, 0x47, 0x52, 0x41, 0x44, 0x45, 0x44,
	0x10, 0x03, 0x22, 0x79, 0x0a, 0x06, 0x53, 0x74, 0x61, 0x74, 0x75, 0x73, 0x12, 0x12, 0x0a, 0x0e,
	0x53, 0x54, 0x41, 0x54, 0x55, 0x53, 0x5f, 0x55, 0x4e, 0x4b, 0x4e, 0x4f, 0x57, 0x4e, 0x10, 0x00,
	0x12, 0x0c, 0x0a, 0x08, 0x43, 0x52, 0x45, 0x41, 0x54, 0x49, 0x4e, 0x47, 0x10, 0x01, 0x12, 0x0b,
	0x0a, 0x07, 0x52, 0x55, 0x4e, 0x4e, 0x49, 0x4e, 0x47, 0x10, 0x02, 0x12, 0x09, 0x0a, 0x05, 0x45,
	0x52, 0x52, 0x4f, 0x52, 0x10, 0x03, 0x12, 0x0c, 0x0a, 0x08, 0x55, 0x50, 0x44, 0x41, 0x54, 0x49,
	0x4e, 0x47, 0x10, 0x04, 0x12, 0x0c, 0x0a, 0x08, 0x53, 0x54, 0x4f, 0x50, 0x50, 0x49, 0x4e, 0x47,
	0x10, 0x05, 0x12, 0x0b, 0x0a, 0x07, 0x53, 0x54, 0x4f, 0x50, 0x50, 0x45, 0x44, 0x10, 0x06, 0x12,
	0x0c, 0x0a, 0x08, 0x53, 0x54, 0x41, 0x52, 0x54, 0x49, 0x4e, 0x47, 0x10, 0x07, 0x22, 0x56, 0x0a,
	0x0a, 0x4d, 0x6f, 0x6e, 0x69, 0x74, 0x6f, 0x72, 0x69, 0x6e, 0x67, 0x12, 0x12, 0x0a, 0x04, 0x6e,
	0x61, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x12,
	0x20, 0x0a, 0x0b, 0x64, 0x65, 0x73, 0x63, 0x72, 0x69, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x18, 0x02,
	0x20, 0x01, 0x28, 0x09, 0x52, 0x0b, 0x64, 0x65, 0x73, 0x63, 0x72, 0x69, 0x70, 0x74, 0x69, 0x6f,
	0x6e, 0x12, 0x12, 0x0a, 0x04, 0x6c, 0x69, 0x6e, 0x6b, 0x18, 0x03, 0x20, 0x01, 0x28, 0x09, 0x52,
	0x04, 0x6c, 0x69, 0x6e, 0x6b, 0x22, 0x81, 0x02, 0x0a, 0x0d, 0x43, 0x6c, 0x75, 0x73, 0x74, 0x65,
	0x72, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x12, 0x18, 0x0a, 0x07, 0x76, 0x65, 0x72, 0x73, 0x69,
	0x6f, 0x6e, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x07, 0x76, 0x65, 0x72, 0x73, 0x69, 0x6f,
	0x6e, 0x12, 0x4a, 0x0a, 0x0a, 0x6f, 0x70, 0x65, 0x6e, 0x73, 0x65, 0x61, 0x72, 0x63, 0x68, 0x18,
	0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x2a, 0x2e, 0x79, 0x61, 0x6e, 0x64, 0x65, 0x78, 0x2e, 0x63,
	0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x6d, 0x64, 0x62, 0x2e, 0x6f, 0x70, 0x65, 0x6e, 0x73, 0x65, 0x61,
	0x72, 0x63, 0x68, 0x2e, 0x76, 0x31, 0x2e, 0x4f, 0x70, 0x65, 0x6e, 0x53, 0x65, 0x61, 0x72, 0x63,
	0x68, 0x52, 0x0a, 0x6f, 0x70, 0x65, 0x6e, 0x73, 0x65, 0x61, 0x72, 0x63, 0x68, 0x12, 0x4a, 0x0a,
	0x0a, 0x64, 0x61, 0x73, 0x68, 0x62, 0x6f, 0x61, 0x72, 0x64, 0x73, 0x18, 0x03, 0x20, 0x01, 0x28,
	0x0b, 0x32, 0x2a, 0x2e, 0x79, 0x61, 0x6e, 0x64, 0x65, 0x78, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64,
	0x2e, 0x6d, 0x64, 0x62, 0x2e, 0x6f, 0x70, 0x65, 0x6e, 0x73, 0x65, 0x61, 0x72, 0x63, 0x68, 0x2e,
	0x76, 0x31, 0x2e, 0x44, 0x61, 0x73, 0x68, 0x62, 0x6f, 0x61, 0x72, 0x64, 0x73, 0x52, 0x0a, 0x64,
	0x61, 0x73, 0x68, 0x62, 0x6f, 0x61, 0x72, 0x64, 0x73, 0x12, 0x3e, 0x0a, 0x06, 0x61, 0x63, 0x63,
	0x65, 0x73, 0x73, 0x18, 0x04, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x26, 0x2e, 0x79, 0x61, 0x6e, 0x64,
	0x65, 0x78, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x6d, 0x64, 0x62, 0x2e, 0x6f, 0x70, 0x65,
	0x6e, 0x73, 0x65, 0x61, 0x72, 0x63, 0x68, 0x2e, 0x76, 0x31, 0x2e, 0x41, 0x63, 0x63, 0x65, 0x73,
	0x73, 0x52, 0x06, 0x61, 0x63, 0x63, 0x65, 0x73, 0x73, 0x22, 0xfa, 0x04, 0x0a, 0x0a, 0x4f, 0x70,
	0x65, 0x6e, 0x53, 0x65, 0x61, 0x72, 0x63, 0x68, 0x12, 0x18, 0x0a, 0x07, 0x70, 0x6c, 0x75, 0x67,
	0x69, 0x6e, 0x73, 0x18, 0x01, 0x20, 0x03, 0x28, 0x09, 0x52, 0x07, 0x70, 0x6c, 0x75, 0x67, 0x69,
	0x6e, 0x73, 0x12, 0x55, 0x0a, 0x0b, 0x6e, 0x6f, 0x64, 0x65, 0x5f, 0x67, 0x72, 0x6f, 0x75, 0x70,
	0x73, 0x18, 0x02, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x34, 0x2e, 0x79, 0x61, 0x6e, 0x64, 0x65, 0x78,
	0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x6d, 0x64, 0x62, 0x2e, 0x6f, 0x70, 0x65, 0x6e, 0x73,
	0x65, 0x61, 0x72, 0x63, 0x68, 0x2e, 0x76, 0x31, 0x2e, 0x4f, 0x70, 0x65, 0x6e, 0x53, 0x65, 0x61,
	0x72, 0x63, 0x68, 0x2e, 0x4e, 0x6f, 0x64, 0x65, 0x47, 0x72, 0x6f, 0x75, 0x70, 0x52, 0x0a, 0x6e,
	0x6f, 0x64, 0x65, 0x47, 0x72, 0x6f, 0x75, 0x70, 0x73, 0x12, 0x75, 0x0a, 0x17, 0x6f, 0x70, 0x65,
	0x6e, 0x73, 0x65, 0x61, 0x72, 0x63, 0x68, 0x5f, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x5f, 0x73,
	0x65, 0x74, 0x5f, 0x32, 0x18, 0x03, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x3b, 0x2e, 0x79, 0x61, 0x6e,
	0x64, 0x65, 0x78, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x6d, 0x64, 0x62, 0x2e, 0x6f, 0x70,
	0x65, 0x6e, 0x73, 0x65, 0x61, 0x72, 0x63, 0x68, 0x2e, 0x76, 0x31, 0x2e, 0x63, 0x6f, 0x6e, 0x66,
	0x69, 0x67, 0x2e, 0x4f, 0x70, 0x65, 0x6e, 0x53, 0x65, 0x61, 0x72, 0x63, 0x68, 0x43, 0x6f, 0x6e,
	0x66, 0x69, 0x67, 0x53, 0x65, 0x74, 0x32, 0x48, 0x00, 0x52, 0x15, 0x6f, 0x70, 0x65, 0x6e, 0x73,
	0x65, 0x61, 0x72, 0x63, 0x68, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x53, 0x65, 0x74, 0x5f, 0x32,
	0x1a, 0xb9, 0x02, 0x0a, 0x09, 0x4e, 0x6f, 0x64, 0x65, 0x47, 0x72, 0x6f, 0x75, 0x70, 0x12, 0x12,
	0x0a, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x04, 0x6e, 0x61,
	0x6d, 0x65, 0x12, 0x47, 0x0a, 0x09, 0x72, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x73, 0x18,
	0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x29, 0x2e, 0x79, 0x61, 0x6e, 0x64, 0x65, 0x78, 0x2e, 0x63,
	0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x6d, 0x64, 0x62, 0x2e, 0x6f, 0x70, 0x65, 0x6e, 0x73, 0x65, 0x61,
	0x72, 0x63, 0x68, 0x2e, 0x76, 0x31, 0x2e, 0x52, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x73,
	0x52, 0x09, 0x72, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x73, 0x12, 0x1f, 0x0a, 0x0b, 0x68,
	0x6f, 0x73, 0x74, 0x73, 0x5f, 0x63, 0x6f, 0x75, 0x6e, 0x74, 0x18, 0x03, 0x20, 0x01, 0x28, 0x03,
	0x52, 0x0a, 0x68, 0x6f, 0x73, 0x74, 0x73, 0x43, 0x6f, 0x75, 0x6e, 0x74, 0x12, 0x19, 0x0a, 0x08,
	0x7a, 0x6f, 0x6e, 0x65, 0x5f, 0x69, 0x64, 0x73, 0x18, 0x04, 0x20, 0x03, 0x28, 0x09, 0x52, 0x07,
	0x7a, 0x6f, 0x6e, 0x65, 0x49, 0x64, 0x73, 0x12, 0x1d, 0x0a, 0x0a, 0x73, 0x75, 0x62, 0x6e, 0x65,
	0x74, 0x5f, 0x69, 0x64, 0x73, 0x18, 0x05, 0x20, 0x03, 0x28, 0x09, 0x52, 0x09, 0x73, 0x75, 0x62,
	0x6e, 0x65, 0x74, 0x49, 0x64, 0x73, 0x12, 0x28, 0x0a, 0x10, 0x61, 0x73, 0x73, 0x69, 0x67, 0x6e,
	0x5f, 0x70, 0x75, 0x62, 0x6c, 0x69, 0x63, 0x5f, 0x69, 0x70, 0x18, 0x06, 0x20, 0x01, 0x28, 0x08,
	0x52, 0x0e, 0x61, 0x73, 0x73, 0x69, 0x67, 0x6e, 0x50, 0x75, 0x62, 0x6c, 0x69, 0x63, 0x49, 0x70,
	0x12, 0x4a, 0x0a, 0x05, 0x72, 0x6f, 0x6c, 0x65, 0x73, 0x18, 0x07, 0x20, 0x03, 0x28, 0x0e, 0x32,
	0x34, 0x2e, 0x79, 0x61, 0x6e, 0x64, 0x65, 0x78, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x6d,
	0x64, 0x62, 0x2e, 0x6f, 0x70, 0x65, 0x6e, 0x73, 0x65, 0x61, 0x72, 0x63, 0x68, 0x2e, 0x76, 0x31,
	0x2e, 0x4f, 0x70, 0x65, 0x6e, 0x53, 0x65, 0x61, 0x72, 0x63, 0x68, 0x2e, 0x47, 0x72, 0x6f, 0x75,
	0x70, 0x52, 0x6f, 0x6c, 0x65, 0x52, 0x05, 0x72, 0x6f, 0x6c, 0x65, 0x73, 0x22, 0x3e, 0x0a, 0x09,
	0x47, 0x72, 0x6f, 0x75, 0x70, 0x52, 0x6f, 0x6c, 0x65, 0x12, 0x1a, 0x0a, 0x16, 0x47, 0x52, 0x4f,
	0x55, 0x50, 0x5f, 0x52, 0x4f, 0x4c, 0x45, 0x5f, 0x55, 0x4e, 0x53, 0x50, 0x45, 0x43, 0x49, 0x46,
	0x49, 0x45, 0x44, 0x10, 0x00, 0x12, 0x08, 0x0a, 0x04, 0x44, 0x41, 0x54, 0x41, 0x10, 0x01, 0x12,
	0x0b, 0x0a, 0x07, 0x4d, 0x41, 0x4e, 0x41, 0x47, 0x45, 0x52, 0x10, 0x02, 0x42, 0x08, 0x0a, 0x06,
	0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x22, 0xd3, 0x02, 0x0a, 0x0a, 0x44, 0x61, 0x73, 0x68, 0x62,
	0x6f, 0x61, 0x72, 0x64, 0x73, 0x12, 0x55, 0x0a, 0x0b, 0x6e, 0x6f, 0x64, 0x65, 0x5f, 0x67, 0x72,
	0x6f, 0x75, 0x70, 0x73, 0x18, 0x02, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x34, 0x2e, 0x79, 0x61, 0x6e,
	0x64, 0x65, 0x78, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x6d, 0x64, 0x62, 0x2e, 0x6f, 0x70,
	0x65, 0x6e, 0x73, 0x65, 0x61, 0x72, 0x63, 0x68, 0x2e, 0x76, 0x31, 0x2e, 0x44, 0x61, 0x73, 0x68,
	0x62, 0x6f, 0x61, 0x72, 0x64, 0x73, 0x2e, 0x4e, 0x6f, 0x64, 0x65, 0x47, 0x72, 0x6f, 0x75, 0x70,
	0x52, 0x0a, 0x6e, 0x6f, 0x64, 0x65, 0x47, 0x72, 0x6f, 0x75, 0x70, 0x73, 0x1a, 0xed, 0x01, 0x0a,
	0x09, 0x4e, 0x6f, 0x64, 0x65, 0x47, 0x72, 0x6f, 0x75, 0x70, 0x12, 0x12, 0x0a, 0x04, 0x6e, 0x61,
	0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x12, 0x47,
	0x0a, 0x09, 0x72, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x73, 0x18, 0x02, 0x20, 0x01, 0x28,
	0x0b, 0x32, 0x29, 0x2e, 0x79, 0x61, 0x6e, 0x64, 0x65, 0x78, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64,
	0x2e, 0x6d, 0x64, 0x62, 0x2e, 0x6f, 0x70, 0x65, 0x6e, 0x73, 0x65, 0x61, 0x72, 0x63, 0x68, 0x2e,
	0x76, 0x31, 0x2e, 0x52, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x73, 0x52, 0x09, 0x72, 0x65,
	0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x73, 0x12, 0x1f, 0x0a, 0x0b, 0x68, 0x6f, 0x73, 0x74, 0x73,
	0x5f, 0x63, 0x6f, 0x75, 0x6e, 0x74, 0x18, 0x03, 0x20, 0x01, 0x28, 0x03, 0x52, 0x0a, 0x68, 0x6f,
	0x73, 0x74, 0x73, 0x43, 0x6f, 0x75, 0x6e, 0x74, 0x12, 0x19, 0x0a, 0x08, 0x7a, 0x6f, 0x6e, 0x65,
	0x5f, 0x69, 0x64, 0x73, 0x18, 0x04, 0x20, 0x03, 0x28, 0x09, 0x52, 0x07, 0x7a, 0x6f, 0x6e, 0x65,
	0x49, 0x64, 0x73, 0x12, 0x1d, 0x0a, 0x0a, 0x73, 0x75, 0x62, 0x6e, 0x65, 0x74, 0x5f, 0x69, 0x64,
	0x73, 0x18, 0x05, 0x20, 0x03, 0x28, 0x09, 0x52, 0x09, 0x73, 0x75, 0x62, 0x6e, 0x65, 0x74, 0x49,
	0x64, 0x73, 0x12, 0x28, 0x0a, 0x10, 0x61, 0x73, 0x73, 0x69, 0x67, 0x6e, 0x5f, 0x70, 0x75, 0x62,
	0x6c, 0x69, 0x63, 0x5f, 0x69, 0x70, 0x18, 0x06, 0x20, 0x01, 0x28, 0x08, 0x52, 0x0e, 0x61, 0x73,
	0x73, 0x69, 0x67, 0x6e, 0x50, 0x75, 0x62, 0x6c, 0x69, 0x63, 0x49, 0x70, 0x22, 0x78, 0x0a, 0x09,
	0x52, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x73, 0x12, 0x2c, 0x0a, 0x12, 0x72, 0x65, 0x73,
	0x6f, 0x75, 0x72, 0x63, 0x65, 0x5f, 0x70, 0x72, 0x65, 0x73, 0x65, 0x74, 0x5f, 0x69, 0x64, 0x18,
	0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x10, 0x72, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x50,
	0x72, 0x65, 0x73, 0x65, 0x74, 0x49, 0x64, 0x12, 0x1b, 0x0a, 0x09, 0x64, 0x69, 0x73, 0x6b, 0x5f,
	0x73, 0x69, 0x7a, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x03, 0x52, 0x08, 0x64, 0x69, 0x73, 0x6b,
	0x53, 0x69, 0x7a, 0x65, 0x12, 0x20, 0x0a, 0x0c, 0x64, 0x69, 0x73, 0x6b, 0x5f, 0x74, 0x79, 0x70,
	0x65, 0x5f, 0x69, 0x64, 0x18, 0x03, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0a, 0x64, 0x69, 0x73, 0x6b,
	0x54, 0x79, 0x70, 0x65, 0x49, 0x64, 0x22, 0xe6, 0x08, 0x0a, 0x04, 0x48, 0x6f, 0x73, 0x74, 0x12,
	0x12, 0x0a, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x04, 0x6e,
	0x61, 0x6d, 0x65, 0x12, 0x1d, 0x0a, 0x0a, 0x63, 0x6c, 0x75, 0x73, 0x74, 0x65, 0x72, 0x5f, 0x69,
	0x64, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x09, 0x63, 0x6c, 0x75, 0x73, 0x74, 0x65, 0x72,
	0x49, 0x64, 0x12, 0x17, 0x0a, 0x07, 0x7a, 0x6f, 0x6e, 0x65, 0x5f, 0x69, 0x64, 0x18, 0x03, 0x20,
	0x01, 0x28, 0x09, 0x52, 0x06, 0x7a, 0x6f, 0x6e, 0x65, 0x49, 0x64, 0x12, 0x47, 0x0a, 0x09, 0x72,
	0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x73, 0x18, 0x04, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x29,
	0x2e, 0x79, 0x61, 0x6e, 0x64, 0x65, 0x78, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x6d, 0x64,
	0x62, 0x2e, 0x6f, 0x70, 0x65, 0x6e, 0x73, 0x65, 0x61, 0x72, 0x63, 0x68, 0x2e, 0x76, 0x31, 0x2e,
	0x52, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x73, 0x52, 0x09, 0x72, 0x65, 0x73, 0x6f, 0x75,
	0x72, 0x63, 0x65, 0x73, 0x12, 0x3d, 0x0a, 0x04, 0x74, 0x79, 0x70, 0x65, 0x18, 0x05, 0x20, 0x01,
	0x28, 0x0e, 0x32, 0x29, 0x2e, 0x79, 0x61, 0x6e, 0x64, 0x65, 0x78, 0x2e, 0x63, 0x6c, 0x6f, 0x75,
	0x64, 0x2e, 0x6d, 0x64, 0x62, 0x2e, 0x6f, 0x70, 0x65, 0x6e, 0x73, 0x65, 0x61, 0x72, 0x63, 0x68,
	0x2e, 0x76, 0x31, 0x2e, 0x48, 0x6f, 0x73, 0x74, 0x2e, 0x54, 0x79, 0x70, 0x65, 0x52, 0x04, 0x74,
	0x79, 0x70, 0x65, 0x12, 0x43, 0x0a, 0x06, 0x68, 0x65, 0x61, 0x6c, 0x74, 0x68, 0x18, 0x06, 0x20,
	0x01, 0x28, 0x0e, 0x32, 0x2b, 0x2e, 0x79, 0x61, 0x6e, 0x64, 0x65, 0x78, 0x2e, 0x63, 0x6c, 0x6f,
	0x75, 0x64, 0x2e, 0x6d, 0x64, 0x62, 0x2e, 0x6f, 0x70, 0x65, 0x6e, 0x73, 0x65, 0x61, 0x72, 0x63,
	0x68, 0x2e, 0x76, 0x31, 0x2e, 0x48, 0x6f, 0x73, 0x74, 0x2e, 0x48, 0x65, 0x61, 0x6c, 0x74, 0x68,
	0x52, 0x06, 0x68, 0x65, 0x61, 0x6c, 0x74, 0x68, 0x12, 0x1b, 0x0a, 0x09, 0x73, 0x75, 0x62, 0x6e,
	0x65, 0x74, 0x5f, 0x69, 0x64, 0x18, 0x08, 0x20, 0x01, 0x28, 0x09, 0x52, 0x08, 0x73, 0x75, 0x62,
	0x6e, 0x65, 0x74, 0x49, 0x64, 0x12, 0x28, 0x0a, 0x10, 0x61, 0x73, 0x73, 0x69, 0x67, 0x6e, 0x5f,
	0x70, 0x75, 0x62, 0x6c, 0x69, 0x63, 0x5f, 0x69, 0x70, 0x18, 0x09, 0x20, 0x01, 0x28, 0x08, 0x52,
	0x0e, 0x61, 0x73, 0x73, 0x69, 0x67, 0x6e, 0x50, 0x75, 0x62, 0x6c, 0x69, 0x63, 0x49, 0x70, 0x12,
	0x4a, 0x0a, 0x06, 0x73, 0x79, 0x73, 0x74, 0x65, 0x6d, 0x18, 0x0a, 0x20, 0x01, 0x28, 0x0b, 0x32,
	0x32, 0x2e, 0x79, 0x61, 0x6e, 0x64, 0x65, 0x78, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x6d,
	0x64, 0x62, 0x2e, 0x6f, 0x70, 0x65, 0x6e, 0x73, 0x65, 0x61, 0x72, 0x63, 0x68, 0x2e, 0x76, 0x31,
	0x2e, 0x48, 0x6f, 0x73, 0x74, 0x2e, 0x53, 0x79, 0x73, 0x74, 0x65, 0x6d, 0x4d, 0x65, 0x74, 0x72,
	0x69, 0x63, 0x73, 0x52, 0x06, 0x73, 0x79, 0x73, 0x74, 0x65, 0x6d, 0x12, 0x1d, 0x0a, 0x0a, 0x6e,
	0x6f, 0x64, 0x65, 0x5f, 0x67, 0x72, 0x6f, 0x75, 0x70, 0x18, 0x0b, 0x20, 0x01, 0x28, 0x09, 0x52,
	0x09, 0x6e, 0x6f, 0x64, 0x65, 0x47, 0x72, 0x6f, 0x75, 0x70, 0x12, 0x4a, 0x0a, 0x05, 0x72, 0x6f,
	0x6c, 0x65, 0x73, 0x18, 0x0c, 0x20, 0x03, 0x28, 0x0e, 0x32, 0x34, 0x2e, 0x79, 0x61, 0x6e, 0x64,
	0x65, 0x78, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x6d, 0x64, 0x62, 0x2e, 0x6f, 0x70, 0x65,
	0x6e, 0x73, 0x65, 0x61, 0x72, 0x63, 0x68, 0x2e, 0x76, 0x31, 0x2e, 0x4f, 0x70, 0x65, 0x6e, 0x53,
	0x65, 0x61, 0x72, 0x63, 0x68, 0x2e, 0x47, 0x72, 0x6f, 0x75, 0x70, 0x52, 0x6f, 0x6c, 0x65, 0x52,
	0x05, 0x72, 0x6f, 0x6c, 0x65, 0x73, 0x1a, 0x3d, 0x0a, 0x09, 0x43, 0x50, 0x55, 0x4d, 0x65, 0x74,
	0x72, 0x69, 0x63, 0x12, 0x1c, 0x0a, 0x09, 0x74, 0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70,
	0x18, 0x01, 0x20, 0x01, 0x28, 0x03, 0x52, 0x09, 0x74, 0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d,
	0x70, 0x12, 0x12, 0x0a, 0x04, 0x75, 0x73, 0x65, 0x64, 0x18, 0x02, 0x20, 0x01, 0x28, 0x01, 0x52,
	0x04, 0x75, 0x73, 0x65, 0x64, 0x1a, 0x56, 0x0a, 0x0c, 0x4d, 0x65, 0x6d, 0x6f, 0x72, 0x79, 0x4d,
	0x65, 0x74, 0x72, 0x69, 0x63, 0x12, 0x1c, 0x0a, 0x09, 0x74, 0x69, 0x6d, 0x65, 0x73, 0x74, 0x61,
	0x6d, 0x70, 0x18, 0x01, 0x20, 0x01, 0x28, 0x03, 0x52, 0x09, 0x74, 0x69, 0x6d, 0x65, 0x73, 0x74,
	0x61, 0x6d, 0x70, 0x12, 0x12, 0x0a, 0x04, 0x75, 0x73, 0x65, 0x64, 0x18, 0x02, 0x20, 0x01, 0x28,
	0x03, 0x52, 0x04, 0x75, 0x73, 0x65, 0x64, 0x12, 0x14, 0x0a, 0x05, 0x74, 0x6f, 0x74, 0x61, 0x6c,
	0x18, 0x03, 0x20, 0x01, 0x28, 0x03, 0x52, 0x05, 0x74, 0x6f, 0x74, 0x61, 0x6c, 0x1a, 0x54, 0x0a,
	0x0a, 0x44, 0x69, 0x73, 0x6b, 0x4d, 0x65, 0x74, 0x72, 0x69, 0x63, 0x12, 0x1c, 0x0a, 0x09, 0x74,
	0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x18, 0x01, 0x20, 0x01, 0x28, 0x03, 0x52, 0x09,
	0x74, 0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x12, 0x12, 0x0a, 0x04, 0x75, 0x73, 0x65,
	0x64, 0x18, 0x02, 0x20, 0x01, 0x28, 0x03, 0x52, 0x04, 0x75, 0x73, 0x65, 0x64, 0x12, 0x14, 0x0a,
	0x05, 0x74, 0x6f, 0x74, 0x61, 0x6c, 0x18, 0x03, 0x20, 0x01, 0x28, 0x03, 0x52, 0x05, 0x74, 0x6f,
	0x74, 0x61, 0x6c, 0x1a, 0xe1, 0x01, 0x0a, 0x0d, 0x53, 0x79, 0x73, 0x74, 0x65, 0x6d, 0x4d, 0x65,
	0x74, 0x72, 0x69, 0x63, 0x73, 0x12, 0x40, 0x0a, 0x03, 0x63, 0x70, 0x75, 0x18, 0x01, 0x20, 0x01,
	0x28, 0x0b, 0x32, 0x2e, 0x2e, 0x79, 0x61, 0x6e, 0x64, 0x65, 0x78, 0x2e, 0x63, 0x6c, 0x6f, 0x75,
	0x64, 0x2e, 0x6d, 0x64, 0x62, 0x2e, 0x6f, 0x70, 0x65, 0x6e, 0x73, 0x65, 0x61, 0x72, 0x63, 0x68,
	0x2e, 0x76, 0x31, 0x2e, 0x48, 0x6f, 0x73, 0x74, 0x2e, 0x43, 0x50, 0x55, 0x4d, 0x65, 0x74, 0x72,
	0x69, 0x63, 0x52, 0x03, 0x63, 0x70, 0x75, 0x12, 0x49, 0x0a, 0x06, 0x6d, 0x65, 0x6d, 0x6f, 0x72,
	0x79, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x31, 0x2e, 0x79, 0x61, 0x6e, 0x64, 0x65, 0x78,
	0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x6d, 0x64, 0x62, 0x2e, 0x6f, 0x70, 0x65, 0x6e, 0x73,
	0x65, 0x61, 0x72, 0x63, 0x68, 0x2e, 0x76, 0x31, 0x2e, 0x48, 0x6f, 0x73, 0x74, 0x2e, 0x4d, 0x65,
	0x6d, 0x6f, 0x72, 0x79, 0x4d, 0x65, 0x74, 0x72, 0x69, 0x63, 0x52, 0x06, 0x6d, 0x65, 0x6d, 0x6f,
	0x72, 0x79, 0x12, 0x43, 0x0a, 0x04, 0x64, 0x69, 0x73, 0x6b, 0x18, 0x03, 0x20, 0x01, 0x28, 0x0b,
	0x32, 0x2f, 0x2e, 0x79, 0x61, 0x6e, 0x64, 0x65, 0x78, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e,
	0x6d, 0x64, 0x62, 0x2e, 0x6f, 0x70, 0x65, 0x6e, 0x73, 0x65, 0x61, 0x72, 0x63, 0x68, 0x2e, 0x76,
	0x31, 0x2e, 0x48, 0x6f, 0x73, 0x74, 0x2e, 0x44, 0x69, 0x73, 0x6b, 0x4d, 0x65, 0x74, 0x72, 0x69,
	0x63, 0x52, 0x04, 0x64, 0x69, 0x73, 0x6b, 0x22, 0x38, 0x0a, 0x06, 0x48, 0x65, 0x61, 0x6c, 0x74,
	0x68, 0x12, 0x0b, 0x0a, 0x07, 0x55, 0x4e, 0x4b, 0x4e, 0x4f, 0x57, 0x4e, 0x10, 0x00, 0x12, 0x09,
	0x0a, 0x05, 0x41, 0x4c, 0x49, 0x56, 0x45, 0x10, 0x01, 0x12, 0x08, 0x0a, 0x04, 0x44, 0x45, 0x41,
	0x44, 0x10, 0x02, 0x12, 0x0c, 0x0a, 0x08, 0x44, 0x45, 0x47, 0x52, 0x41, 0x44, 0x45, 0x44, 0x10,
	0x03, 0x22, 0x3c, 0x0a, 0x04, 0x54, 0x79, 0x70, 0x65, 0x12, 0x14, 0x0a, 0x10, 0x54, 0x59, 0x50,
	0x45, 0x5f, 0x55, 0x4e, 0x53, 0x50, 0x45, 0x43, 0x49, 0x46, 0x49, 0x45, 0x44, 0x10, 0x00, 0x12,
	0x0e, 0x0a, 0x0a, 0x4f, 0x50, 0x45, 0x4e, 0x53, 0x45, 0x41, 0x52, 0x43, 0x48, 0x10, 0x01, 0x12,
	0x0e, 0x0a, 0x0a, 0x44, 0x41, 0x53, 0x48, 0x42, 0x4f, 0x41, 0x52, 0x44, 0x53, 0x10, 0x02, 0x22,
	0x4d, 0x0a, 0x06, 0x41, 0x63, 0x63, 0x65, 0x73, 0x73, 0x12, 0x23, 0x0a, 0x0d, 0x64, 0x61, 0x74,
	0x61, 0x5f, 0x74, 0x72, 0x61, 0x6e, 0x73, 0x66, 0x65, 0x72, 0x18, 0x01, 0x20, 0x01, 0x28, 0x08,
	0x52, 0x0c, 0x64, 0x61, 0x74, 0x61, 0x54, 0x72, 0x61, 0x6e, 0x73, 0x66, 0x65, 0x72, 0x12, 0x1e,
	0x0a, 0x0a, 0x73, 0x65, 0x72, 0x76, 0x65, 0x72, 0x6c, 0x65, 0x73, 0x73, 0x18, 0x02, 0x20, 0x01,
	0x28, 0x08, 0x52, 0x0a, 0x73, 0x65, 0x72, 0x76, 0x65, 0x72, 0x6c, 0x65, 0x73, 0x73, 0x42, 0x73,
	0x0a, 0x22, 0x79, 0x61, 0x6e, 0x64, 0x65, 0x78, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x61,
	0x70, 0x69, 0x2e, 0x6d, 0x64, 0x62, 0x2e, 0x6f, 0x70, 0x65, 0x6e, 0x73, 0x65, 0x61, 0x72, 0x63,
	0x68, 0x2e, 0x76, 0x31, 0x5a, 0x4d, 0x67, 0x69, 0x74, 0x68, 0x75, 0x62, 0x2e, 0x63, 0x6f, 0x6d,
	0x2f, 0x79, 0x61, 0x6e, 0x64, 0x65, 0x78, 0x2d, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2f, 0x67, 0x6f,
	0x2d, 0x67, 0x65, 0x6e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x2f, 0x79, 0x61, 0x6e, 0x64, 0x65, 0x78,
	0x2f, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2f, 0x6d, 0x64, 0x62, 0x2f, 0x6f, 0x70, 0x65, 0x6e, 0x73,
	0x65, 0x61, 0x72, 0x63, 0x68, 0x2f, 0x76, 0x31, 0x3b, 0x6f, 0x70, 0x65, 0x6e, 0x73, 0x65, 0x61,
	0x72, 0x63, 0x68, 0x62, 0x06, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x33,
}

var (
	file_yandex_cloud_mdb_opensearch_v1_cluster_proto_rawDescOnce sync.Once
	file_yandex_cloud_mdb_opensearch_v1_cluster_proto_rawDescData = file_yandex_cloud_mdb_opensearch_v1_cluster_proto_rawDesc
)

func file_yandex_cloud_mdb_opensearch_v1_cluster_proto_rawDescGZIP() []byte {
	file_yandex_cloud_mdb_opensearch_v1_cluster_proto_rawDescOnce.Do(func() {
		file_yandex_cloud_mdb_opensearch_v1_cluster_proto_rawDescData = protoimpl.X.CompressGZIP(file_yandex_cloud_mdb_opensearch_v1_cluster_proto_rawDescData)
	})
	return file_yandex_cloud_mdb_opensearch_v1_cluster_proto_rawDescData
}

var file_yandex_cloud_mdb_opensearch_v1_cluster_proto_enumTypes = make([]protoimpl.EnumInfo, 6)
var file_yandex_cloud_mdb_opensearch_v1_cluster_proto_msgTypes = make([]protoimpl.MessageInfo, 15)
var file_yandex_cloud_mdb_opensearch_v1_cluster_proto_goTypes = []interface{}{
	(Cluster_Environment)(0),            // 0: yandex.cloud.mdb.opensearch.v1.Cluster.Environment
	(Cluster_Health)(0),                 // 1: yandex.cloud.mdb.opensearch.v1.Cluster.Health
	(Cluster_Status)(0),                 // 2: yandex.cloud.mdb.opensearch.v1.Cluster.Status
	(OpenSearch_GroupRole)(0),           // 3: yandex.cloud.mdb.opensearch.v1.OpenSearch.GroupRole
	(Host_Health)(0),                    // 4: yandex.cloud.mdb.opensearch.v1.Host.Health
	(Host_Type)(0),                      // 5: yandex.cloud.mdb.opensearch.v1.Host.Type
	(*Cluster)(nil),                     // 6: yandex.cloud.mdb.opensearch.v1.Cluster
	(*Monitoring)(nil),                  // 7: yandex.cloud.mdb.opensearch.v1.Monitoring
	(*ClusterConfig)(nil),               // 8: yandex.cloud.mdb.opensearch.v1.ClusterConfig
	(*OpenSearch)(nil),                  // 9: yandex.cloud.mdb.opensearch.v1.OpenSearch
	(*Dashboards)(nil),                  // 10: yandex.cloud.mdb.opensearch.v1.Dashboards
	(*Resources)(nil),                   // 11: yandex.cloud.mdb.opensearch.v1.Resources
	(*Host)(nil),                        // 12: yandex.cloud.mdb.opensearch.v1.Host
	(*Access)(nil),                      // 13: yandex.cloud.mdb.opensearch.v1.Access
	nil,                                 // 14: yandex.cloud.mdb.opensearch.v1.Cluster.LabelsEntry
	(*OpenSearch_NodeGroup)(nil),        // 15: yandex.cloud.mdb.opensearch.v1.OpenSearch.NodeGroup
	(*Dashboards_NodeGroup)(nil),        // 16: yandex.cloud.mdb.opensearch.v1.Dashboards.NodeGroup
	(*Host_CPUMetric)(nil),              // 17: yandex.cloud.mdb.opensearch.v1.Host.CPUMetric
	(*Host_MemoryMetric)(nil),           // 18: yandex.cloud.mdb.opensearch.v1.Host.MemoryMetric
	(*Host_DiskMetric)(nil),             // 19: yandex.cloud.mdb.opensearch.v1.Host.DiskMetric
	(*Host_SystemMetrics)(nil),          // 20: yandex.cloud.mdb.opensearch.v1.Host.SystemMetrics
	(*timestamppb.Timestamp)(nil),       // 21: google.protobuf.Timestamp
	(*MaintenanceWindow)(nil),           // 22: yandex.cloud.mdb.opensearch.v1.MaintenanceWindow
	(*MaintenanceOperation)(nil),        // 23: yandex.cloud.mdb.opensearch.v1.MaintenanceOperation
	(*config.OpenSearchConfigSet2)(nil), // 24: yandex.cloud.mdb.opensearch.v1.config.OpenSearchConfigSet2
}
var file_yandex_cloud_mdb_opensearch_v1_cluster_proto_depIdxs = []int32{
	21, // 0: yandex.cloud.mdb.opensearch.v1.Cluster.created_at:type_name -> google.protobuf.Timestamp
	14, // 1: yandex.cloud.mdb.opensearch.v1.Cluster.labels:type_name -> yandex.cloud.mdb.opensearch.v1.Cluster.LabelsEntry
	0,  // 2: yandex.cloud.mdb.opensearch.v1.Cluster.environment:type_name -> yandex.cloud.mdb.opensearch.v1.Cluster.Environment
	7,  // 3: yandex.cloud.mdb.opensearch.v1.Cluster.monitoring:type_name -> yandex.cloud.mdb.opensearch.v1.Monitoring
	8,  // 4: yandex.cloud.mdb.opensearch.v1.Cluster.config:type_name -> yandex.cloud.mdb.opensearch.v1.ClusterConfig
	1,  // 5: yandex.cloud.mdb.opensearch.v1.Cluster.health:type_name -> yandex.cloud.mdb.opensearch.v1.Cluster.Health
	2,  // 6: yandex.cloud.mdb.opensearch.v1.Cluster.status:type_name -> yandex.cloud.mdb.opensearch.v1.Cluster.Status
	22, // 7: yandex.cloud.mdb.opensearch.v1.Cluster.maintenance_window:type_name -> yandex.cloud.mdb.opensearch.v1.MaintenanceWindow
	23, // 8: yandex.cloud.mdb.opensearch.v1.Cluster.planned_operation:type_name -> yandex.cloud.mdb.opensearch.v1.MaintenanceOperation
	9,  // 9: yandex.cloud.mdb.opensearch.v1.ClusterConfig.opensearch:type_name -> yandex.cloud.mdb.opensearch.v1.OpenSearch
	10, // 10: yandex.cloud.mdb.opensearch.v1.ClusterConfig.dashboards:type_name -> yandex.cloud.mdb.opensearch.v1.Dashboards
	13, // 11: yandex.cloud.mdb.opensearch.v1.ClusterConfig.access:type_name -> yandex.cloud.mdb.opensearch.v1.Access
	15, // 12: yandex.cloud.mdb.opensearch.v1.OpenSearch.node_groups:type_name -> yandex.cloud.mdb.opensearch.v1.OpenSearch.NodeGroup
	24, // 13: yandex.cloud.mdb.opensearch.v1.OpenSearch.opensearch_config_set_2:type_name -> yandex.cloud.mdb.opensearch.v1.config.OpenSearchConfigSet2
	16, // 14: yandex.cloud.mdb.opensearch.v1.Dashboards.node_groups:type_name -> yandex.cloud.mdb.opensearch.v1.Dashboards.NodeGroup
	11, // 15: yandex.cloud.mdb.opensearch.v1.Host.resources:type_name -> yandex.cloud.mdb.opensearch.v1.Resources
	5,  // 16: yandex.cloud.mdb.opensearch.v1.Host.type:type_name -> yandex.cloud.mdb.opensearch.v1.Host.Type
	4,  // 17: yandex.cloud.mdb.opensearch.v1.Host.health:type_name -> yandex.cloud.mdb.opensearch.v1.Host.Health
	20, // 18: yandex.cloud.mdb.opensearch.v1.Host.system:type_name -> yandex.cloud.mdb.opensearch.v1.Host.SystemMetrics
	3,  // 19: yandex.cloud.mdb.opensearch.v1.Host.roles:type_name -> yandex.cloud.mdb.opensearch.v1.OpenSearch.GroupRole
	11, // 20: yandex.cloud.mdb.opensearch.v1.OpenSearch.NodeGroup.resources:type_name -> yandex.cloud.mdb.opensearch.v1.Resources
	3,  // 21: yandex.cloud.mdb.opensearch.v1.OpenSearch.NodeGroup.roles:type_name -> yandex.cloud.mdb.opensearch.v1.OpenSearch.GroupRole
	11, // 22: yandex.cloud.mdb.opensearch.v1.Dashboards.NodeGroup.resources:type_name -> yandex.cloud.mdb.opensearch.v1.Resources
	17, // 23: yandex.cloud.mdb.opensearch.v1.Host.SystemMetrics.cpu:type_name -> yandex.cloud.mdb.opensearch.v1.Host.CPUMetric
	18, // 24: yandex.cloud.mdb.opensearch.v1.Host.SystemMetrics.memory:type_name -> yandex.cloud.mdb.opensearch.v1.Host.MemoryMetric
	19, // 25: yandex.cloud.mdb.opensearch.v1.Host.SystemMetrics.disk:type_name -> yandex.cloud.mdb.opensearch.v1.Host.DiskMetric
	26, // [26:26] is the sub-list for method output_type
	26, // [26:26] is the sub-list for method input_type
	26, // [26:26] is the sub-list for extension type_name
	26, // [26:26] is the sub-list for extension extendee
	0,  // [0:26] is the sub-list for field type_name
}

func init() { file_yandex_cloud_mdb_opensearch_v1_cluster_proto_init() }
func file_yandex_cloud_mdb_opensearch_v1_cluster_proto_init() {
	if File_yandex_cloud_mdb_opensearch_v1_cluster_proto != nil {
		return
	}
	file_yandex_cloud_mdb_opensearch_v1_maintenance_proto_init()
	if !protoimpl.UnsafeEnabled {
		file_yandex_cloud_mdb_opensearch_v1_cluster_proto_msgTypes[0].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*Cluster); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_yandex_cloud_mdb_opensearch_v1_cluster_proto_msgTypes[1].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*Monitoring); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_yandex_cloud_mdb_opensearch_v1_cluster_proto_msgTypes[2].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ClusterConfig); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_yandex_cloud_mdb_opensearch_v1_cluster_proto_msgTypes[3].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*OpenSearch); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_yandex_cloud_mdb_opensearch_v1_cluster_proto_msgTypes[4].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*Dashboards); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_yandex_cloud_mdb_opensearch_v1_cluster_proto_msgTypes[5].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*Resources); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_yandex_cloud_mdb_opensearch_v1_cluster_proto_msgTypes[6].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*Host); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_yandex_cloud_mdb_opensearch_v1_cluster_proto_msgTypes[7].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*Access); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_yandex_cloud_mdb_opensearch_v1_cluster_proto_msgTypes[9].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*OpenSearch_NodeGroup); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_yandex_cloud_mdb_opensearch_v1_cluster_proto_msgTypes[10].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*Dashboards_NodeGroup); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_yandex_cloud_mdb_opensearch_v1_cluster_proto_msgTypes[11].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*Host_CPUMetric); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_yandex_cloud_mdb_opensearch_v1_cluster_proto_msgTypes[12].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*Host_MemoryMetric); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_yandex_cloud_mdb_opensearch_v1_cluster_proto_msgTypes[13].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*Host_DiskMetric); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_yandex_cloud_mdb_opensearch_v1_cluster_proto_msgTypes[14].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*Host_SystemMetrics); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
	}
	file_yandex_cloud_mdb_opensearch_v1_cluster_proto_msgTypes[3].OneofWrappers = []interface{}{
		(*OpenSearch_OpensearchConfigSet_2)(nil),
	}
	type x struct{}
	out := protoimpl.TypeBuilder{
		File: protoimpl.DescBuilder{
			GoPackagePath: reflect.TypeOf(x{}).PkgPath(),
			RawDescriptor: file_yandex_cloud_mdb_opensearch_v1_cluster_proto_rawDesc,
			NumEnums:      6,
			NumMessages:   15,
			NumExtensions: 0,
			NumServices:   0,
		},
		GoTypes:           file_yandex_cloud_mdb_opensearch_v1_cluster_proto_goTypes,
		DependencyIndexes: file_yandex_cloud_mdb_opensearch_v1_cluster_proto_depIdxs,
		EnumInfos:         file_yandex_cloud_mdb_opensearch_v1_cluster_proto_enumTypes,
		MessageInfos:      file_yandex_cloud_mdb_opensearch_v1_cluster_proto_msgTypes,
	}.Build()
	File_yandex_cloud_mdb_opensearch_v1_cluster_proto = out.File
	file_yandex_cloud_mdb_opensearch_v1_cluster_proto_rawDesc = nil
	file_yandex_cloud_mdb_opensearch_v1_cluster_proto_goTypes = nil
	file_yandex_cloud_mdb_opensearch_v1_cluster_proto_depIdxs = nil
}
