// Code generated by sdkgen. DO NOT EDIT.

// nolint
package backup

import (
	"context"

	"google.golang.org/grpc"

	backup "github.com/yandex-cloud/go-genproto/yandex/cloud/backup/v1"
	"github.com/yandex-cloud/go-genproto/yandex/cloud/operation"
)

//revive:disable

// ResourceServiceClient is a backup.ResourceServiceClient with
// lazy GRPC connection initialization.
type ResourceServiceClient struct {
	getConn func(ctx context.Context) (*grpc.ClientConn, error)
}

// CreateDirectory implements backup.ResourceServiceClient
func (c *ResourceServiceClient) CreateDirectory(ctx context.Context, in *backup.CreateDirectoryRequest, opts ...grpc.CallOption) (*operation.Operation, error) {
	conn, err := c.getConn(ctx)
	if err != nil {
		return nil, err
	}
	return backup.NewResourceServiceClient(conn).CreateDirectory(ctx, in, opts...)
}

// Delete implements backup.ResourceServiceClient
func (c *ResourceServiceClient) Delete(ctx context.Context, in *backup.DeleteResourceRequest, opts ...grpc.CallOption) (*operation.Operation, error) {
	conn, err := c.getConn(ctx)
	if err != nil {
		return nil, err
	}
	return backup.NewResourceServiceClient(conn).Delete(ctx, in, opts...)
}

// Get implements backup.ResourceServiceClient
func (c *ResourceServiceClient) Get(ctx context.Context, in *backup.GetResourceRequest, opts ...grpc.CallOption) (*backup.GetResourceResponse, error) {
	conn, err := c.getConn(ctx)
	if err != nil {
		return nil, err
	}
	return backup.NewResourceServiceClient(conn).Get(ctx, in, opts...)
}

// List implements backup.ResourceServiceClient
func (c *ResourceServiceClient) List(ctx context.Context, in *backup.ListResourcesRequest, opts ...grpc.CallOption) (*backup.ListResourcesResponse, error) {
	conn, err := c.getConn(ctx)
	if err != nil {
		return nil, err
	}
	return backup.NewResourceServiceClient(conn).List(ctx, in, opts...)
}

type ResourceIterator struct {
	ctx  context.Context
	opts []grpc.CallOption

	err           error
	started       bool
	requestedSize int64
	pageSize      int64

	client  *ResourceServiceClient
	request *backup.ListResourcesRequest

	items []*backup.Resource
}

func (c *ResourceServiceClient) ResourceIterator(ctx context.Context, req *backup.ListResourcesRequest, opts ...grpc.CallOption) *ResourceIterator {
	var pageSize int64
	const defaultPageSize = 1000
	pageSize = req.PageSize
	if pageSize == 0 {
		pageSize = defaultPageSize
	}
	return &ResourceIterator{
		ctx:      ctx,
		opts:     opts,
		client:   c,
		request:  req,
		pageSize: pageSize,
	}
}

func (it *ResourceIterator) Next() bool {
	if it.err != nil {
		return false
	}
	if len(it.items) > 1 {
		it.items[0] = nil
		it.items = it.items[1:]
		return true
	}
	it.items = nil // consume last item, if any

	if it.started && it.request.PageToken == "" {
		return false
	}
	it.started = true

	if it.requestedSize == 0 || it.requestedSize > it.pageSize {
		it.request.PageSize = it.pageSize
	} else {
		it.request.PageSize = it.requestedSize
	}

	response, err := it.client.List(it.ctx, it.request, it.opts...)
	it.err = err
	if err != nil {
		return false
	}

	it.items = response.Resources
	it.request.PageToken = response.NextPageToken
	return len(it.items) > 0
}

func (it *ResourceIterator) Take(size int64) ([]*backup.Resource, error) {
	if it.err != nil {
		return nil, it.err
	}

	if size == 0 {
		size = 1 << 32 // something insanely large
	}
	it.requestedSize = size
	defer func() {
		// reset iterator for future calls.
		it.requestedSize = 0
	}()

	var result []*backup.Resource

	for it.requestedSize > 0 && it.Next() {
		it.requestedSize--
		result = append(result, it.Value())
	}

	if it.err != nil {
		return nil, it.err
	}

	return result, nil
}

func (it *ResourceIterator) TakeAll() ([]*backup.Resource, error) {
	return it.Take(0)
}

func (it *ResourceIterator) Value() *backup.Resource {
	if len(it.items) == 0 {
		panic("calling Value on empty iterator")
	}
	return it.items[0]
}

func (it *ResourceIterator) Error() error {
	return it.err
}

// ListDirectory implements backup.ResourceServiceClient
func (c *ResourceServiceClient) ListDirectory(ctx context.Context, in *backup.ListDirectoryRequest, opts ...grpc.CallOption) (*backup.ListDirectoryResponse, error) {
	conn, err := c.getConn(ctx)
	if err != nil {
		return nil, err
	}
	return backup.NewResourceServiceClient(conn).ListDirectory(ctx, in, opts...)
}

type ResourceDirectoryIterator struct {
	ctx  context.Context
	opts []grpc.CallOption

	err           error
	started       bool
	requestedSize int64
	pageSize      int64

	client  *ResourceServiceClient
	request *backup.ListDirectoryRequest

	items []*backup.ListDirectoryResponse_FilesystemItem
}

func (c *ResourceServiceClient) ResourceDirectoryIterator(ctx context.Context, req *backup.ListDirectoryRequest, opts ...grpc.CallOption) *ResourceDirectoryIterator {
	var pageSize int64
	const defaultPageSize = 1000

	if pageSize == 0 {
		pageSize = defaultPageSize
	}
	return &ResourceDirectoryIterator{
		ctx:      ctx,
		opts:     opts,
		client:   c,
		request:  req,
		pageSize: pageSize,
	}
}

func (it *ResourceDirectoryIterator) Next() bool {
	if it.err != nil {
		return false
	}
	if len(it.items) > 1 {
		it.items[0] = nil
		it.items = it.items[1:]
		return true
	}
	it.items = nil // consume last item, if any

	if it.started {
		return false
	}
	it.started = true

	response, err := it.client.ListDirectory(it.ctx, it.request, it.opts...)
	it.err = err
	if err != nil {
		return false
	}

	it.items = response.Items
	return len(it.items) > 0
}

func (it *ResourceDirectoryIterator) Take(size int64) ([]*backup.ListDirectoryResponse_FilesystemItem, error) {
	if it.err != nil {
		return nil, it.err
	}

	if size == 0 {
		size = 1 << 32 // something insanely large
	}
	it.requestedSize = size
	defer func() {
		// reset iterator for future calls.
		it.requestedSize = 0
	}()

	var result []*backup.ListDirectoryResponse_FilesystemItem

	for it.requestedSize > 0 && it.Next() {
		it.requestedSize--
		result = append(result, it.Value())
	}

	if it.err != nil {
		return nil, it.err
	}

	return result, nil
}

func (it *ResourceDirectoryIterator) TakeAll() ([]*backup.ListDirectoryResponse_FilesystemItem, error) {
	return it.Take(0)
}

func (it *ResourceDirectoryIterator) Value() *backup.ListDirectoryResponse_FilesystemItem {
	if len(it.items) == 0 {
		panic("calling Value on empty iterator")
	}
	return it.items[0]
}

func (it *ResourceDirectoryIterator) Error() error {
	return it.err
}

// ListTasks implements backup.ResourceServiceClient
func (c *ResourceServiceClient) ListTasks(ctx context.Context, in *backup.ListTasksRequest, opts ...grpc.CallOption) (*backup.ListTasksResponse, error) {
	conn, err := c.getConn(ctx)
	if err != nil {
		return nil, err
	}
	return backup.NewResourceServiceClient(conn).ListTasks(ctx, in, opts...)
}

type ResourceTasksIterator struct {
	ctx  context.Context
	opts []grpc.CallOption

	err           error
	started       bool
	requestedSize int64
	pageSize      int64

	client  *ResourceServiceClient
	request *backup.ListTasksRequest

	items []*backup.Task
}

func (c *ResourceServiceClient) ResourceTasksIterator(ctx context.Context, req *backup.ListTasksRequest, opts ...grpc.CallOption) *ResourceTasksIterator {
	var pageSize int64
	const defaultPageSize = 1000
	pageSize = req.PageSize
	if pageSize == 0 {
		pageSize = defaultPageSize
	}
	return &ResourceTasksIterator{
		ctx:      ctx,
		opts:     opts,
		client:   c,
		request:  req,
		pageSize: pageSize,
	}
}

func (it *ResourceTasksIterator) Next() bool {
	if it.err != nil {
		return false
	}
	if len(it.items) > 1 {
		it.items[0] = nil
		it.items = it.items[1:]
		return true
	}
	it.items = nil // consume last item, if any

	if it.started && it.request.PageToken == "" {
		return false
	}
	it.started = true

	if it.requestedSize == 0 || it.requestedSize > it.pageSize {
		it.request.PageSize = it.pageSize
	} else {
		it.request.PageSize = it.requestedSize
	}

	response, err := it.client.ListTasks(it.ctx, it.request, it.opts...)
	it.err = err
	if err != nil {
		return false
	}

	it.items = response.Tasks
	it.request.PageToken = response.NextPageToken
	return len(it.items) > 0
}

func (it *ResourceTasksIterator) Take(size int64) ([]*backup.Task, error) {
	if it.err != nil {
		return nil, it.err
	}

	if size == 0 {
		size = 1 << 32 // something insanely large
	}
	it.requestedSize = size
	defer func() {
		// reset iterator for future calls.
		it.requestedSize = 0
	}()

	var result []*backup.Task

	for it.requestedSize > 0 && it.Next() {
		it.requestedSize--
		result = append(result, it.Value())
	}

	if it.err != nil {
		return nil, it.err
	}

	return result, nil
}

func (it *ResourceTasksIterator) TakeAll() ([]*backup.Task, error) {
	return it.Take(0)
}

func (it *ResourceTasksIterator) Value() *backup.Task {
	if len(it.items) == 0 {
		panic("calling Value on empty iterator")
	}
	return it.items[0]
}

func (it *ResourceTasksIterator) Error() error {
	return it.err
}
