// Code generated by sdkgen. DO NOT EDIT.

// nolint
package compute

import (
	"context"

	"google.golang.org/grpc"

	compute "github.com/yandex-cloud/go-genproto/yandex/cloud/compute/v1"
	"github.com/yandex-cloud/go-genproto/yandex/cloud/operation"
)

//revive:disable

// SnapshotServiceClient is a compute.SnapshotServiceClient with
// lazy GRPC connection initialization.
type SnapshotServiceClient struct {
	getConn func(ctx context.Context) (*grpc.ClientConn, error)
}

// Create implements compute.SnapshotServiceClient
func (c *SnapshotServiceClient) Create(ctx context.Context, in *compute.CreateSnapshotRequest, opts ...grpc.CallOption) (*operation.Operation, error) {
	conn, err := c.getConn(ctx)
	if err != nil {
		return nil, err
	}
	return compute.NewSnapshotServiceClient(conn).Create(ctx, in, opts...)
}

// Delete implements compute.SnapshotServiceClient
func (c *SnapshotServiceClient) Delete(ctx context.Context, in *compute.DeleteSnapshotRequest, opts ...grpc.CallOption) (*operation.Operation, error) {
	conn, err := c.getConn(ctx)
	if err != nil {
		return nil, err
	}
	return compute.NewSnapshotServiceClient(conn).Delete(ctx, in, opts...)
}

// Get implements compute.SnapshotServiceClient
func (c *SnapshotServiceClient) Get(ctx context.Context, in *compute.GetSnapshotRequest, opts ...grpc.CallOption) (*compute.Snapshot, error) {
	conn, err := c.getConn(ctx)
	if err != nil {
		return nil, err
	}
	return compute.NewSnapshotServiceClient(conn).Get(ctx, in, opts...)
}

// List implements compute.SnapshotServiceClient
func (c *SnapshotServiceClient) List(ctx context.Context, in *compute.ListSnapshotsRequest, opts ...grpc.CallOption) (*compute.ListSnapshotsResponse, error) {
	conn, err := c.getConn(ctx)
	if err != nil {
		return nil, err
	}
	return compute.NewSnapshotServiceClient(conn).List(ctx, in, opts...)
}

type SnapshotIterator struct {
	ctx  context.Context
	opts []grpc.CallOption

	err           error
	started       bool
	requestedSize int64
	pageSize      int64

	client  *SnapshotServiceClient
	request *compute.ListSnapshotsRequest

	items []*compute.Snapshot
}

func (c *SnapshotServiceClient) SnapshotIterator(ctx context.Context, req *compute.ListSnapshotsRequest, opts ...grpc.CallOption) *SnapshotIterator {
	var pageSize int64
	const defaultPageSize = 1000
	pageSize = req.PageSize
	if pageSize == 0 {
		pageSize = defaultPageSize
	}
	return &SnapshotIterator{
		ctx:      ctx,
		opts:     opts,
		client:   c,
		request:  req,
		pageSize: pageSize,
	}
}

func (it *SnapshotIterator) Next() bool {
	if it.err != nil {
		return false
	}
	if len(it.items) > 1 {
		it.items[0] = nil
		it.items = it.items[1:]
		return true
	}
	it.items = nil // consume last item, if any

	if it.started && it.request.PageToken == "" {
		return false
	}
	it.started = true

	if it.requestedSize == 0 || it.requestedSize > it.pageSize {
		it.request.PageSize = it.pageSize
	} else {
		it.request.PageSize = it.requestedSize
	}

	response, err := it.client.List(it.ctx, it.request, it.opts...)
	it.err = err
	if err != nil {
		return false
	}

	it.items = response.Snapshots
	it.request.PageToken = response.NextPageToken
	return len(it.items) > 0
}

func (it *SnapshotIterator) Take(size int64) ([]*compute.Snapshot, error) {
	if it.err != nil {
		return nil, it.err
	}

	if size == 0 {
		size = 1 << 32 // something insanely large
	}
	it.requestedSize = size
	defer func() {
		// reset iterator for future calls.
		it.requestedSize = 0
	}()

	var result []*compute.Snapshot

	for it.requestedSize > 0 && it.Next() {
		it.requestedSize--
		result = append(result, it.Value())
	}

	if it.err != nil {
		return nil, it.err
	}

	return result, nil
}

func (it *SnapshotIterator) TakeAll() ([]*compute.Snapshot, error) {
	return it.Take(0)
}

func (it *SnapshotIterator) Value() *compute.Snapshot {
	if len(it.items) == 0 {
		panic("calling Value on empty iterator")
	}
	return it.items[0]
}

func (it *SnapshotIterator) Error() error {
	return it.err
}

// ListOperations implements compute.SnapshotServiceClient
func (c *SnapshotServiceClient) ListOperations(ctx context.Context, in *compute.ListSnapshotOperationsRequest, opts ...grpc.CallOption) (*compute.ListSnapshotOperationsResponse, error) {
	conn, err := c.getConn(ctx)
	if err != nil {
		return nil, err
	}
	return compute.NewSnapshotServiceClient(conn).ListOperations(ctx, in, opts...)
}

type SnapshotOperationsIterator struct {
	ctx  context.Context
	opts []grpc.CallOption

	err           error
	started       bool
	requestedSize int64
	pageSize      int64

	client  *SnapshotServiceClient
	request *compute.ListSnapshotOperationsRequest

	items []*operation.Operation
}

func (c *SnapshotServiceClient) SnapshotOperationsIterator(ctx context.Context, req *compute.ListSnapshotOperationsRequest, opts ...grpc.CallOption) *SnapshotOperationsIterator {
	var pageSize int64
	const defaultPageSize = 1000
	pageSize = req.PageSize
	if pageSize == 0 {
		pageSize = defaultPageSize
	}
	return &SnapshotOperationsIterator{
		ctx:      ctx,
		opts:     opts,
		client:   c,
		request:  req,
		pageSize: pageSize,
	}
}

func (it *SnapshotOperationsIterator) Next() bool {
	if it.err != nil {
		return false
	}
	if len(it.items) > 1 {
		it.items[0] = nil
		it.items = it.items[1:]
		return true
	}
	it.items = nil // consume last item, if any

	if it.started && it.request.PageToken == "" {
		return false
	}
	it.started = true

	if it.requestedSize == 0 || it.requestedSize > it.pageSize {
		it.request.PageSize = it.pageSize
	} else {
		it.request.PageSize = it.requestedSize
	}

	response, err := it.client.ListOperations(it.ctx, it.request, it.opts...)
	it.err = err
	if err != nil {
		return false
	}

	it.items = response.Operations
	it.request.PageToken = response.NextPageToken
	return len(it.items) > 0
}

func (it *SnapshotOperationsIterator) Take(size int64) ([]*operation.Operation, error) {
	if it.err != nil {
		return nil, it.err
	}

	if size == 0 {
		size = 1 << 32 // something insanely large
	}
	it.requestedSize = size
	defer func() {
		// reset iterator for future calls.
		it.requestedSize = 0
	}()

	var result []*operation.Operation

	for it.requestedSize > 0 && it.Next() {
		it.requestedSize--
		result = append(result, it.Value())
	}

	if it.err != nil {
		return nil, it.err
	}

	return result, nil
}

func (it *SnapshotOperationsIterator) TakeAll() ([]*operation.Operation, error) {
	return it.Take(0)
}

func (it *SnapshotOperationsIterator) Value() *operation.Operation {
	if len(it.items) == 0 {
		panic("calling Value on empty iterator")
	}
	return it.items[0]
}

func (it *SnapshotOperationsIterator) Error() error {
	return it.err
}

// Update implements compute.SnapshotServiceClient
func (c *SnapshotServiceClient) Update(ctx context.Context, in *compute.UpdateSnapshotRequest, opts ...grpc.CallOption) (*operation.Operation, error) {
	conn, err := c.getConn(ctx)
	if err != nil {
		return nil, err
	}
	return compute.NewSnapshotServiceClient(conn).Update(ctx, in, opts...)
}
