// Code generated by sdkgen. DO NOT EDIT.

// nolint
package vpc

import (
	"context"

	"google.golang.org/grpc"

	"github.com/yandex-cloud/go-genproto/yandex/cloud/operation"
	vpc "github.com/yandex-cloud/go-genproto/yandex/cloud/vpc/v1"
)

//revive:disable

// SubnetServiceClient is a vpc.SubnetServiceClient with
// lazy GRPC connection initialization.
type SubnetServiceClient struct {
	getConn func(ctx context.Context) (*grpc.ClientConn, error)
}

// AddCidrBlocks implements vpc.SubnetServiceClient
func (c *SubnetServiceClient) AddCidrBlocks(ctx context.Context, in *vpc.AddSubnetCidrBlocksRequest, opts ...grpc.CallOption) (*operation.Operation, error) {
	conn, err := c.getConn(ctx)
	if err != nil {
		return nil, err
	}
	return vpc.NewSubnetServiceClient(conn).AddCidrBlocks(ctx, in, opts...)
}

// Create implements vpc.SubnetServiceClient
func (c *SubnetServiceClient) Create(ctx context.Context, in *vpc.CreateSubnetRequest, opts ...grpc.CallOption) (*operation.Operation, error) {
	conn, err := c.getConn(ctx)
	if err != nil {
		return nil, err
	}
	return vpc.NewSubnetServiceClient(conn).Create(ctx, in, opts...)
}

// Delete implements vpc.SubnetServiceClient
func (c *SubnetServiceClient) Delete(ctx context.Context, in *vpc.DeleteSubnetRequest, opts ...grpc.CallOption) (*operation.Operation, error) {
	conn, err := c.getConn(ctx)
	if err != nil {
		return nil, err
	}
	return vpc.NewSubnetServiceClient(conn).Delete(ctx, in, opts...)
}

// Get implements vpc.SubnetServiceClient
func (c *SubnetServiceClient) Get(ctx context.Context, in *vpc.GetSubnetRequest, opts ...grpc.CallOption) (*vpc.Subnet, error) {
	conn, err := c.getConn(ctx)
	if err != nil {
		return nil, err
	}
	return vpc.NewSubnetServiceClient(conn).Get(ctx, in, opts...)
}

// List implements vpc.SubnetServiceClient
func (c *SubnetServiceClient) List(ctx context.Context, in *vpc.ListSubnetsRequest, opts ...grpc.CallOption) (*vpc.ListSubnetsResponse, error) {
	conn, err := c.getConn(ctx)
	if err != nil {
		return nil, err
	}
	return vpc.NewSubnetServiceClient(conn).List(ctx, in, opts...)
}

type SubnetIterator struct {
	ctx  context.Context
	opts []grpc.CallOption

	err           error
	started       bool
	requestedSize int64
	pageSize      int64

	client  *SubnetServiceClient
	request *vpc.ListSubnetsRequest

	items []*vpc.Subnet
}

func (c *SubnetServiceClient) SubnetIterator(ctx context.Context, req *vpc.ListSubnetsRequest, opts ...grpc.CallOption) *SubnetIterator {
	var pageSize int64
	const defaultPageSize = 1000
	pageSize = req.PageSize
	if pageSize == 0 {
		pageSize = defaultPageSize
	}
	return &SubnetIterator{
		ctx:      ctx,
		opts:     opts,
		client:   c,
		request:  req,
		pageSize: pageSize,
	}
}

func (it *SubnetIterator) Next() bool {
	if it.err != nil {
		return false
	}
	if len(it.items) > 1 {
		it.items[0] = nil
		it.items = it.items[1:]
		return true
	}
	it.items = nil // consume last item, if any

	if it.started && it.request.PageToken == "" {
		return false
	}
	it.started = true

	if it.requestedSize == 0 || it.requestedSize > it.pageSize {
		it.request.PageSize = it.pageSize
	} else {
		it.request.PageSize = it.requestedSize
	}

	response, err := it.client.List(it.ctx, it.request, it.opts...)
	it.err = err
	if err != nil {
		return false
	}

	it.items = response.Subnets
	it.request.PageToken = response.NextPageToken
	return len(it.items) > 0
}

func (it *SubnetIterator) Take(size int64) ([]*vpc.Subnet, error) {
	if it.err != nil {
		return nil, it.err
	}

	if size == 0 {
		size = 1 << 32 // something insanely large
	}
	it.requestedSize = size
	defer func() {
		// reset iterator for future calls.
		it.requestedSize = 0
	}()

	var result []*vpc.Subnet

	for it.requestedSize > 0 && it.Next() {
		it.requestedSize--
		result = append(result, it.Value())
	}

	if it.err != nil {
		return nil, it.err
	}

	return result, nil
}

func (it *SubnetIterator) TakeAll() ([]*vpc.Subnet, error) {
	return it.Take(0)
}

func (it *SubnetIterator) Value() *vpc.Subnet {
	if len(it.items) == 0 {
		panic("calling Value on empty iterator")
	}
	return it.items[0]
}

func (it *SubnetIterator) Error() error {
	return it.err
}

// ListOperations implements vpc.SubnetServiceClient
func (c *SubnetServiceClient) ListOperations(ctx context.Context, in *vpc.ListSubnetOperationsRequest, opts ...grpc.CallOption) (*vpc.ListSubnetOperationsResponse, error) {
	conn, err := c.getConn(ctx)
	if err != nil {
		return nil, err
	}
	return vpc.NewSubnetServiceClient(conn).ListOperations(ctx, in, opts...)
}

type SubnetOperationsIterator struct {
	ctx  context.Context
	opts []grpc.CallOption

	err           error
	started       bool
	requestedSize int64
	pageSize      int64

	client  *SubnetServiceClient
	request *vpc.ListSubnetOperationsRequest

	items []*operation.Operation
}

func (c *SubnetServiceClient) SubnetOperationsIterator(ctx context.Context, req *vpc.ListSubnetOperationsRequest, opts ...grpc.CallOption) *SubnetOperationsIterator {
	var pageSize int64
	const defaultPageSize = 1000
	pageSize = req.PageSize
	if pageSize == 0 {
		pageSize = defaultPageSize
	}
	return &SubnetOperationsIterator{
		ctx:      ctx,
		opts:     opts,
		client:   c,
		request:  req,
		pageSize: pageSize,
	}
}

func (it *SubnetOperationsIterator) Next() bool {
	if it.err != nil {
		return false
	}
	if len(it.items) > 1 {
		it.items[0] = nil
		it.items = it.items[1:]
		return true
	}
	it.items = nil // consume last item, if any

	if it.started && it.request.PageToken == "" {
		return false
	}
	it.started = true

	if it.requestedSize == 0 || it.requestedSize > it.pageSize {
		it.request.PageSize = it.pageSize
	} else {
		it.request.PageSize = it.requestedSize
	}

	response, err := it.client.ListOperations(it.ctx, it.request, it.opts...)
	it.err = err
	if err != nil {
		return false
	}

	it.items = response.Operations
	it.request.PageToken = response.NextPageToken
	return len(it.items) > 0
}

func (it *SubnetOperationsIterator) Take(size int64) ([]*operation.Operation, error) {
	if it.err != nil {
		return nil, it.err
	}

	if size == 0 {
		size = 1 << 32 // something insanely large
	}
	it.requestedSize = size
	defer func() {
		// reset iterator for future calls.
		it.requestedSize = 0
	}()

	var result []*operation.Operation

	for it.requestedSize > 0 && it.Next() {
		it.requestedSize--
		result = append(result, it.Value())
	}

	if it.err != nil {
		return nil, it.err
	}

	return result, nil
}

func (it *SubnetOperationsIterator) TakeAll() ([]*operation.Operation, error) {
	return it.Take(0)
}

func (it *SubnetOperationsIterator) Value() *operation.Operation {
	if len(it.items) == 0 {
		panic("calling Value on empty iterator")
	}
	return it.items[0]
}

func (it *SubnetOperationsIterator) Error() error {
	return it.err
}

// ListUsedAddresses implements vpc.SubnetServiceClient
func (c *SubnetServiceClient) ListUsedAddresses(ctx context.Context, in *vpc.ListUsedAddressesRequest, opts ...grpc.CallOption) (*vpc.ListUsedAddressesResponse, error) {
	conn, err := c.getConn(ctx)
	if err != nil {
		return nil, err
	}
	return vpc.NewSubnetServiceClient(conn).ListUsedAddresses(ctx, in, opts...)
}

type SubnetUsedAddressesIterator struct {
	ctx  context.Context
	opts []grpc.CallOption

	err           error
	started       bool
	requestedSize int64
	pageSize      int64

	client  *SubnetServiceClient
	request *vpc.ListUsedAddressesRequest

	items []*vpc.UsedAddress
}

func (c *SubnetServiceClient) SubnetUsedAddressesIterator(ctx context.Context, req *vpc.ListUsedAddressesRequest, opts ...grpc.CallOption) *SubnetUsedAddressesIterator {
	var pageSize int64
	const defaultPageSize = 1000
	pageSize = req.PageSize
	if pageSize == 0 {
		pageSize = defaultPageSize
	}
	return &SubnetUsedAddressesIterator{
		ctx:      ctx,
		opts:     opts,
		client:   c,
		request:  req,
		pageSize: pageSize,
	}
}

func (it *SubnetUsedAddressesIterator) Next() bool {
	if it.err != nil {
		return false
	}
	if len(it.items) > 1 {
		it.items[0] = nil
		it.items = it.items[1:]
		return true
	}
	it.items = nil // consume last item, if any

	if it.started && it.request.PageToken == "" {
		return false
	}
	it.started = true

	if it.requestedSize == 0 || it.requestedSize > it.pageSize {
		it.request.PageSize = it.pageSize
	} else {
		it.request.PageSize = it.requestedSize
	}

	response, err := it.client.ListUsedAddresses(it.ctx, it.request, it.opts...)
	it.err = err
	if err != nil {
		return false
	}

	it.items = response.Addresses
	it.request.PageToken = response.NextPageToken
	return len(it.items) > 0
}

func (it *SubnetUsedAddressesIterator) Take(size int64) ([]*vpc.UsedAddress, error) {
	if it.err != nil {
		return nil, it.err
	}

	if size == 0 {
		size = 1 << 32 // something insanely large
	}
	it.requestedSize = size
	defer func() {
		// reset iterator for future calls.
		it.requestedSize = 0
	}()

	var result []*vpc.UsedAddress

	for it.requestedSize > 0 && it.Next() {
		it.requestedSize--
		result = append(result, it.Value())
	}

	if it.err != nil {
		return nil, it.err
	}

	return result, nil
}

func (it *SubnetUsedAddressesIterator) TakeAll() ([]*vpc.UsedAddress, error) {
	return it.Take(0)
}

func (it *SubnetUsedAddressesIterator) Value() *vpc.UsedAddress {
	if len(it.items) == 0 {
		panic("calling Value on empty iterator")
	}
	return it.items[0]
}

func (it *SubnetUsedAddressesIterator) Error() error {
	return it.err
}

// Move implements vpc.SubnetServiceClient
func (c *SubnetServiceClient) Move(ctx context.Context, in *vpc.MoveSubnetRequest, opts ...grpc.CallOption) (*operation.Operation, error) {
	conn, err := c.getConn(ctx)
	if err != nil {
		return nil, err
	}
	return vpc.NewSubnetServiceClient(conn).Move(ctx, in, opts...)
}

// RemoveCidrBlocks implements vpc.SubnetServiceClient
func (c *SubnetServiceClient) RemoveCidrBlocks(ctx context.Context, in *vpc.RemoveSubnetCidrBlocksRequest, opts ...grpc.CallOption) (*operation.Operation, error) {
	conn, err := c.getConn(ctx)
	if err != nil {
		return nil, err
	}
	return vpc.NewSubnetServiceClient(conn).RemoveCidrBlocks(ctx, in, opts...)
}

// Update implements vpc.SubnetServiceClient
func (c *SubnetServiceClient) Update(ctx context.Context, in *vpc.UpdateSubnetRequest, opts ...grpc.CallOption) (*operation.Operation, error) {
	conn, err := c.getConn(ctx)
	if err != nil {
		return nil, err
	}
	return vpc.NewSubnetServiceClient(conn).Update(ctx, in, opts...)
}
