// Code generated by protoc-gen-go-grpc. DO NOT EDIT.
// versions:
// - protoc-gen-go-grpc v1.3.0
// - protoc             v3.17.3
// source: yandex/cloud/serverless/functions/v1/function_service.proto

package functions

import (
	context "context"
	access "github.com/yandex-cloud/go-genproto/yandex/cloud/access"
	operation "github.com/yandex-cloud/go-genproto/yandex/cloud/operation"
	grpc "google.golang.org/grpc"
	codes "google.golang.org/grpc/codes"
	status "google.golang.org/grpc/status"
)

// This is a compile-time assertion to ensure that this generated file
// is compatible with the grpc package it is being compiled against.
// Requires gRPC-Go v1.32.0 or later.
const _ = grpc.SupportPackageIsVersion7

const (
	FunctionService_Get_FullMethodName                  = "/yandex.cloud.serverless.functions.v1.FunctionService/Get"
	FunctionService_List_FullMethodName                 = "/yandex.cloud.serverless.functions.v1.FunctionService/List"
	FunctionService_Create_FullMethodName               = "/yandex.cloud.serverless.functions.v1.FunctionService/Create"
	FunctionService_Update_FullMethodName               = "/yandex.cloud.serverless.functions.v1.FunctionService/Update"
	FunctionService_Delete_FullMethodName               = "/yandex.cloud.serverless.functions.v1.FunctionService/Delete"
	FunctionService_GetVersion_FullMethodName           = "/yandex.cloud.serverless.functions.v1.FunctionService/GetVersion"
	FunctionService_GetVersionByTag_FullMethodName      = "/yandex.cloud.serverless.functions.v1.FunctionService/GetVersionByTag"
	FunctionService_ListVersions_FullMethodName         = "/yandex.cloud.serverless.functions.v1.FunctionService/ListVersions"
	FunctionService_DeleteVersion_FullMethodName        = "/yandex.cloud.serverless.functions.v1.FunctionService/DeleteVersion"
	FunctionService_SetTag_FullMethodName               = "/yandex.cloud.serverless.functions.v1.FunctionService/SetTag"
	FunctionService_RemoveTag_FullMethodName            = "/yandex.cloud.serverless.functions.v1.FunctionService/RemoveTag"
	FunctionService_ListTagHistory_FullMethodName       = "/yandex.cloud.serverless.functions.v1.FunctionService/ListTagHistory"
	FunctionService_CreateVersion_FullMethodName        = "/yandex.cloud.serverless.functions.v1.FunctionService/CreateVersion"
	FunctionService_ListRuntimes_FullMethodName         = "/yandex.cloud.serverless.functions.v1.FunctionService/ListRuntimes"
	FunctionService_ListOperations_FullMethodName       = "/yandex.cloud.serverless.functions.v1.FunctionService/ListOperations"
	FunctionService_ListAccessBindings_FullMethodName   = "/yandex.cloud.serverless.functions.v1.FunctionService/ListAccessBindings"
	FunctionService_SetAccessBindings_FullMethodName    = "/yandex.cloud.serverless.functions.v1.FunctionService/SetAccessBindings"
	FunctionService_UpdateAccessBindings_FullMethodName = "/yandex.cloud.serverless.functions.v1.FunctionService/UpdateAccessBindings"
	FunctionService_ListScalingPolicies_FullMethodName  = "/yandex.cloud.serverless.functions.v1.FunctionService/ListScalingPolicies"
	FunctionService_SetScalingPolicy_FullMethodName     = "/yandex.cloud.serverless.functions.v1.FunctionService/SetScalingPolicy"
	FunctionService_RemoveScalingPolicy_FullMethodName  = "/yandex.cloud.serverless.functions.v1.FunctionService/RemoveScalingPolicy"
)

// FunctionServiceClient is the client API for FunctionService service.
//
// For semantics around ctx use and closing/ending streaming RPCs, please refer to https://pkg.go.dev/google.golang.org/grpc/?tab=doc#ClientConn.NewStream.
type FunctionServiceClient interface {
	// Returns the specified function.
	//
	// To get the list of all available functions, make a [List] request.
	Get(ctx context.Context, in *GetFunctionRequest, opts ...grpc.CallOption) (*Function, error)
	// Retrieves the list of functions in the specified folder.
	List(ctx context.Context, in *ListFunctionsRequest, opts ...grpc.CallOption) (*ListFunctionsResponse, error)
	// Creates a function in the specified folder.
	Create(ctx context.Context, in *CreateFunctionRequest, opts ...grpc.CallOption) (*operation.Operation, error)
	// Updates the specified function.
	Update(ctx context.Context, in *UpdateFunctionRequest, opts ...grpc.CallOption) (*operation.Operation, error)
	// Deletes the specified function.
	Delete(ctx context.Context, in *DeleteFunctionRequest, opts ...grpc.CallOption) (*operation.Operation, error)
	// Returns the specified version of a function.
	//
	// To get the list of available version, make a [ListVersions] request.
	GetVersion(ctx context.Context, in *GetFunctionVersionRequest, opts ...grpc.CallOption) (*Version, error)
	// Returns all versions with the specified tag.
	//
	// To get the list of all available versions, make a [ListVersions] request.
	GetVersionByTag(ctx context.Context, in *GetFunctionVersionByTagRequest, opts ...grpc.CallOption) (*Version, error)
	// Retrieves the list of versions for the specified function, or of all function versions
	// in the specified folder.
	ListVersions(ctx context.Context, in *ListFunctionsVersionsRequest, opts ...grpc.CallOption) (*ListFunctionsVersionsResponse, error)
	// Deletes the specified version of a function.
	//
	// NOTE: old untagged function versions are deleted automatically.
	DeleteVersion(ctx context.Context, in *DeleteFunctionVersionRequest, opts ...grpc.CallOption) (*operation.Operation, error)
	// Set a tag for the specified version of a function.
	SetTag(ctx context.Context, in *SetFunctionTagRequest, opts ...grpc.CallOption) (*operation.Operation, error)
	// Remove a tag from the specified version of a function.
	RemoveTag(ctx context.Context, in *RemoveFunctionTagRequest, opts ...grpc.CallOption) (*operation.Operation, error)
	// Returns the log of tags assigned to versions of the specified function.
	ListTagHistory(ctx context.Context, in *ListFunctionTagHistoryRequest, opts ...grpc.CallOption) (*ListFunctionTagHistoryResponse, error)
	// Creates a version for the specified function.
	CreateVersion(ctx context.Context, in *CreateFunctionVersionRequest, opts ...grpc.CallOption) (*operation.Operation, error)
	// Lists available runtime environments for the specified function.
	ListRuntimes(ctx context.Context, in *ListRuntimesRequest, opts ...grpc.CallOption) (*ListRuntimesResponse, error)
	// Lists operations for the specified function.
	ListOperations(ctx context.Context, in *ListFunctionOperationsRequest, opts ...grpc.CallOption) (*ListFunctionOperationsResponse, error)
	// Lists existing access bindings for the specified function.
	ListAccessBindings(ctx context.Context, in *access.ListAccessBindingsRequest, opts ...grpc.CallOption) (*access.ListAccessBindingsResponse, error)
	// Sets access bindings for the function.
	SetAccessBindings(ctx context.Context, in *access.SetAccessBindingsRequest, opts ...grpc.CallOption) (*operation.Operation, error)
	// Updates access bindings for the specified function.
	UpdateAccessBindings(ctx context.Context, in *access.UpdateAccessBindingsRequest, opts ...grpc.CallOption) (*operation.Operation, error)
	// Lists existing scaling policies for specified function
	ListScalingPolicies(ctx context.Context, in *ListScalingPoliciesRequest, opts ...grpc.CallOption) (*ListScalingPoliciesResponse, error)
	// Set scaling policy for specified function and tag
	SetScalingPolicy(ctx context.Context, in *SetScalingPolicyRequest, opts ...grpc.CallOption) (*operation.Operation, error)
	// Remove scaling policy for specified function and tag
	RemoveScalingPolicy(ctx context.Context, in *RemoveScalingPolicyRequest, opts ...grpc.CallOption) (*operation.Operation, error)
}

type functionServiceClient struct {
	cc grpc.ClientConnInterface
}

func NewFunctionServiceClient(cc grpc.ClientConnInterface) FunctionServiceClient {
	return &functionServiceClient{cc}
}

func (c *functionServiceClient) Get(ctx context.Context, in *GetFunctionRequest, opts ...grpc.CallOption) (*Function, error) {
	out := new(Function)
	err := c.cc.Invoke(ctx, FunctionService_Get_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *functionServiceClient) List(ctx context.Context, in *ListFunctionsRequest, opts ...grpc.CallOption) (*ListFunctionsResponse, error) {
	out := new(ListFunctionsResponse)
	err := c.cc.Invoke(ctx, FunctionService_List_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *functionServiceClient) Create(ctx context.Context, in *CreateFunctionRequest, opts ...grpc.CallOption) (*operation.Operation, error) {
	out := new(operation.Operation)
	err := c.cc.Invoke(ctx, FunctionService_Create_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *functionServiceClient) Update(ctx context.Context, in *UpdateFunctionRequest, opts ...grpc.CallOption) (*operation.Operation, error) {
	out := new(operation.Operation)
	err := c.cc.Invoke(ctx, FunctionService_Update_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *functionServiceClient) Delete(ctx context.Context, in *DeleteFunctionRequest, opts ...grpc.CallOption) (*operation.Operation, error) {
	out := new(operation.Operation)
	err := c.cc.Invoke(ctx, FunctionService_Delete_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *functionServiceClient) GetVersion(ctx context.Context, in *GetFunctionVersionRequest, opts ...grpc.CallOption) (*Version, error) {
	out := new(Version)
	err := c.cc.Invoke(ctx, FunctionService_GetVersion_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *functionServiceClient) GetVersionByTag(ctx context.Context, in *GetFunctionVersionByTagRequest, opts ...grpc.CallOption) (*Version, error) {
	out := new(Version)
	err := c.cc.Invoke(ctx, FunctionService_GetVersionByTag_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *functionServiceClient) ListVersions(ctx context.Context, in *ListFunctionsVersionsRequest, opts ...grpc.CallOption) (*ListFunctionsVersionsResponse, error) {
	out := new(ListFunctionsVersionsResponse)
	err := c.cc.Invoke(ctx, FunctionService_ListVersions_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *functionServiceClient) DeleteVersion(ctx context.Context, in *DeleteFunctionVersionRequest, opts ...grpc.CallOption) (*operation.Operation, error) {
	out := new(operation.Operation)
	err := c.cc.Invoke(ctx, FunctionService_DeleteVersion_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *functionServiceClient) SetTag(ctx context.Context, in *SetFunctionTagRequest, opts ...grpc.CallOption) (*operation.Operation, error) {
	out := new(operation.Operation)
	err := c.cc.Invoke(ctx, FunctionService_SetTag_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *functionServiceClient) RemoveTag(ctx context.Context, in *RemoveFunctionTagRequest, opts ...grpc.CallOption) (*operation.Operation, error) {
	out := new(operation.Operation)
	err := c.cc.Invoke(ctx, FunctionService_RemoveTag_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *functionServiceClient) ListTagHistory(ctx context.Context, in *ListFunctionTagHistoryRequest, opts ...grpc.CallOption) (*ListFunctionTagHistoryResponse, error) {
	out := new(ListFunctionTagHistoryResponse)
	err := c.cc.Invoke(ctx, FunctionService_ListTagHistory_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *functionServiceClient) CreateVersion(ctx context.Context, in *CreateFunctionVersionRequest, opts ...grpc.CallOption) (*operation.Operation, error) {
	out := new(operation.Operation)
	err := c.cc.Invoke(ctx, FunctionService_CreateVersion_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *functionServiceClient) ListRuntimes(ctx context.Context, in *ListRuntimesRequest, opts ...grpc.CallOption) (*ListRuntimesResponse, error) {
	out := new(ListRuntimesResponse)
	err := c.cc.Invoke(ctx, FunctionService_ListRuntimes_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *functionServiceClient) ListOperations(ctx context.Context, in *ListFunctionOperationsRequest, opts ...grpc.CallOption) (*ListFunctionOperationsResponse, error) {
	out := new(ListFunctionOperationsResponse)
	err := c.cc.Invoke(ctx, FunctionService_ListOperations_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *functionServiceClient) ListAccessBindings(ctx context.Context, in *access.ListAccessBindingsRequest, opts ...grpc.CallOption) (*access.ListAccessBindingsResponse, error) {
	out := new(access.ListAccessBindingsResponse)
	err := c.cc.Invoke(ctx, FunctionService_ListAccessBindings_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *functionServiceClient) SetAccessBindings(ctx context.Context, in *access.SetAccessBindingsRequest, opts ...grpc.CallOption) (*operation.Operation, error) {
	out := new(operation.Operation)
	err := c.cc.Invoke(ctx, FunctionService_SetAccessBindings_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *functionServiceClient) UpdateAccessBindings(ctx context.Context, in *access.UpdateAccessBindingsRequest, opts ...grpc.CallOption) (*operation.Operation, error) {
	out := new(operation.Operation)
	err := c.cc.Invoke(ctx, FunctionService_UpdateAccessBindings_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *functionServiceClient) ListScalingPolicies(ctx context.Context, in *ListScalingPoliciesRequest, opts ...grpc.CallOption) (*ListScalingPoliciesResponse, error) {
	out := new(ListScalingPoliciesResponse)
	err := c.cc.Invoke(ctx, FunctionService_ListScalingPolicies_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *functionServiceClient) SetScalingPolicy(ctx context.Context, in *SetScalingPolicyRequest, opts ...grpc.CallOption) (*operation.Operation, error) {
	out := new(operation.Operation)
	err := c.cc.Invoke(ctx, FunctionService_SetScalingPolicy_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *functionServiceClient) RemoveScalingPolicy(ctx context.Context, in *RemoveScalingPolicyRequest, opts ...grpc.CallOption) (*operation.Operation, error) {
	out := new(operation.Operation)
	err := c.cc.Invoke(ctx, FunctionService_RemoveScalingPolicy_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

// FunctionServiceServer is the server API for FunctionService service.
// All implementations should embed UnimplementedFunctionServiceServer
// for forward compatibility
type FunctionServiceServer interface {
	// Returns the specified function.
	//
	// To get the list of all available functions, make a [List] request.
	Get(context.Context, *GetFunctionRequest) (*Function, error)
	// Retrieves the list of functions in the specified folder.
	List(context.Context, *ListFunctionsRequest) (*ListFunctionsResponse, error)
	// Creates a function in the specified folder.
	Create(context.Context, *CreateFunctionRequest) (*operation.Operation, error)
	// Updates the specified function.
	Update(context.Context, *UpdateFunctionRequest) (*operation.Operation, error)
	// Deletes the specified function.
	Delete(context.Context, *DeleteFunctionRequest) (*operation.Operation, error)
	// Returns the specified version of a function.
	//
	// To get the list of available version, make a [ListVersions] request.
	GetVersion(context.Context, *GetFunctionVersionRequest) (*Version, error)
	// Returns all versions with the specified tag.
	//
	// To get the list of all available versions, make a [ListVersions] request.
	GetVersionByTag(context.Context, *GetFunctionVersionByTagRequest) (*Version, error)
	// Retrieves the list of versions for the specified function, or of all function versions
	// in the specified folder.
	ListVersions(context.Context, *ListFunctionsVersionsRequest) (*ListFunctionsVersionsResponse, error)
	// Deletes the specified version of a function.
	//
	// NOTE: old untagged function versions are deleted automatically.
	DeleteVersion(context.Context, *DeleteFunctionVersionRequest) (*operation.Operation, error)
	// Set a tag for the specified version of a function.
	SetTag(context.Context, *SetFunctionTagRequest) (*operation.Operation, error)
	// Remove a tag from the specified version of a function.
	RemoveTag(context.Context, *RemoveFunctionTagRequest) (*operation.Operation, error)
	// Returns the log of tags assigned to versions of the specified function.
	ListTagHistory(context.Context, *ListFunctionTagHistoryRequest) (*ListFunctionTagHistoryResponse, error)
	// Creates a version for the specified function.
	CreateVersion(context.Context, *CreateFunctionVersionRequest) (*operation.Operation, error)
	// Lists available runtime environments for the specified function.
	ListRuntimes(context.Context, *ListRuntimesRequest) (*ListRuntimesResponse, error)
	// Lists operations for the specified function.
	ListOperations(context.Context, *ListFunctionOperationsRequest) (*ListFunctionOperationsResponse, error)
	// Lists existing access bindings for the specified function.
	ListAccessBindings(context.Context, *access.ListAccessBindingsRequest) (*access.ListAccessBindingsResponse, error)
	// Sets access bindings for the function.
	SetAccessBindings(context.Context, *access.SetAccessBindingsRequest) (*operation.Operation, error)
	// Updates access bindings for the specified function.
	UpdateAccessBindings(context.Context, *access.UpdateAccessBindingsRequest) (*operation.Operation, error)
	// Lists existing scaling policies for specified function
	ListScalingPolicies(context.Context, *ListScalingPoliciesRequest) (*ListScalingPoliciesResponse, error)
	// Set scaling policy for specified function and tag
	SetScalingPolicy(context.Context, *SetScalingPolicyRequest) (*operation.Operation, error)
	// Remove scaling policy for specified function and tag
	RemoveScalingPolicy(context.Context, *RemoveScalingPolicyRequest) (*operation.Operation, error)
}

// UnimplementedFunctionServiceServer should be embedded to have forward compatible implementations.
type UnimplementedFunctionServiceServer struct {
}

func (UnimplementedFunctionServiceServer) Get(context.Context, *GetFunctionRequest) (*Function, error) {
	return nil, status.Errorf(codes.Unimplemented, "method Get not implemented")
}
func (UnimplementedFunctionServiceServer) List(context.Context, *ListFunctionsRequest) (*ListFunctionsResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method List not implemented")
}
func (UnimplementedFunctionServiceServer) Create(context.Context, *CreateFunctionRequest) (*operation.Operation, error) {
	return nil, status.Errorf(codes.Unimplemented, "method Create not implemented")
}
func (UnimplementedFunctionServiceServer) Update(context.Context, *UpdateFunctionRequest) (*operation.Operation, error) {
	return nil, status.Errorf(codes.Unimplemented, "method Update not implemented")
}
func (UnimplementedFunctionServiceServer) Delete(context.Context, *DeleteFunctionRequest) (*operation.Operation, error) {
	return nil, status.Errorf(codes.Unimplemented, "method Delete not implemented")
}
func (UnimplementedFunctionServiceServer) GetVersion(context.Context, *GetFunctionVersionRequest) (*Version, error) {
	return nil, status.Errorf(codes.Unimplemented, "method GetVersion not implemented")
}
func (UnimplementedFunctionServiceServer) GetVersionByTag(context.Context, *GetFunctionVersionByTagRequest) (*Version, error) {
	return nil, status.Errorf(codes.Unimplemented, "method GetVersionByTag not implemented")
}
func (UnimplementedFunctionServiceServer) ListVersions(context.Context, *ListFunctionsVersionsRequest) (*ListFunctionsVersionsResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method ListVersions not implemented")
}
func (UnimplementedFunctionServiceServer) DeleteVersion(context.Context, *DeleteFunctionVersionRequest) (*operation.Operation, error) {
	return nil, status.Errorf(codes.Unimplemented, "method DeleteVersion not implemented")
}
func (UnimplementedFunctionServiceServer) SetTag(context.Context, *SetFunctionTagRequest) (*operation.Operation, error) {
	return nil, status.Errorf(codes.Unimplemented, "method SetTag not implemented")
}
func (UnimplementedFunctionServiceServer) RemoveTag(context.Context, *RemoveFunctionTagRequest) (*operation.Operation, error) {
	return nil, status.Errorf(codes.Unimplemented, "method RemoveTag not implemented")
}
func (UnimplementedFunctionServiceServer) ListTagHistory(context.Context, *ListFunctionTagHistoryRequest) (*ListFunctionTagHistoryResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method ListTagHistory not implemented")
}
func (UnimplementedFunctionServiceServer) CreateVersion(context.Context, *CreateFunctionVersionRequest) (*operation.Operation, error) {
	return nil, status.Errorf(codes.Unimplemented, "method CreateVersion not implemented")
}
func (UnimplementedFunctionServiceServer) ListRuntimes(context.Context, *ListRuntimesRequest) (*ListRuntimesResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method ListRuntimes not implemented")
}
func (UnimplementedFunctionServiceServer) ListOperations(context.Context, *ListFunctionOperationsRequest) (*ListFunctionOperationsResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method ListOperations not implemented")
}
func (UnimplementedFunctionServiceServer) ListAccessBindings(context.Context, *access.ListAccessBindingsRequest) (*access.ListAccessBindingsResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method ListAccessBindings not implemented")
}
func (UnimplementedFunctionServiceServer) SetAccessBindings(context.Context, *access.SetAccessBindingsRequest) (*operation.Operation, error) {
	return nil, status.Errorf(codes.Unimplemented, "method SetAccessBindings not implemented")
}
func (UnimplementedFunctionServiceServer) UpdateAccessBindings(context.Context, *access.UpdateAccessBindingsRequest) (*operation.Operation, error) {
	return nil, status.Errorf(codes.Unimplemented, "method UpdateAccessBindings not implemented")
}
func (UnimplementedFunctionServiceServer) ListScalingPolicies(context.Context, *ListScalingPoliciesRequest) (*ListScalingPoliciesResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method ListScalingPolicies not implemented")
}
func (UnimplementedFunctionServiceServer) SetScalingPolicy(context.Context, *SetScalingPolicyRequest) (*operation.Operation, error) {
	return nil, status.Errorf(codes.Unimplemented, "method SetScalingPolicy not implemented")
}
func (UnimplementedFunctionServiceServer) RemoveScalingPolicy(context.Context, *RemoveScalingPolicyRequest) (*operation.Operation, error) {
	return nil, status.Errorf(codes.Unimplemented, "method RemoveScalingPolicy not implemented")
}

// UnsafeFunctionServiceServer may be embedded to opt out of forward compatibility for this service.
// Use of this interface is not recommended, as added methods to FunctionServiceServer will
// result in compilation errors.
type UnsafeFunctionServiceServer interface {
	mustEmbedUnimplementedFunctionServiceServer()
}

func RegisterFunctionServiceServer(s grpc.ServiceRegistrar, srv FunctionServiceServer) {
	s.RegisterService(&FunctionService_ServiceDesc, srv)
}

func _FunctionService_Get_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GetFunctionRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(FunctionServiceServer).Get(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: FunctionService_Get_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(FunctionServiceServer).Get(ctx, req.(*GetFunctionRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _FunctionService_List_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ListFunctionsRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(FunctionServiceServer).List(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: FunctionService_List_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(FunctionServiceServer).List(ctx, req.(*ListFunctionsRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _FunctionService_Create_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(CreateFunctionRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(FunctionServiceServer).Create(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: FunctionService_Create_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(FunctionServiceServer).Create(ctx, req.(*CreateFunctionRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _FunctionService_Update_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(UpdateFunctionRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(FunctionServiceServer).Update(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: FunctionService_Update_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(FunctionServiceServer).Update(ctx, req.(*UpdateFunctionRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _FunctionService_Delete_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(DeleteFunctionRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(FunctionServiceServer).Delete(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: FunctionService_Delete_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(FunctionServiceServer).Delete(ctx, req.(*DeleteFunctionRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _FunctionService_GetVersion_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GetFunctionVersionRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(FunctionServiceServer).GetVersion(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: FunctionService_GetVersion_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(FunctionServiceServer).GetVersion(ctx, req.(*GetFunctionVersionRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _FunctionService_GetVersionByTag_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GetFunctionVersionByTagRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(FunctionServiceServer).GetVersionByTag(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: FunctionService_GetVersionByTag_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(FunctionServiceServer).GetVersionByTag(ctx, req.(*GetFunctionVersionByTagRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _FunctionService_ListVersions_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ListFunctionsVersionsRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(FunctionServiceServer).ListVersions(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: FunctionService_ListVersions_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(FunctionServiceServer).ListVersions(ctx, req.(*ListFunctionsVersionsRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _FunctionService_DeleteVersion_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(DeleteFunctionVersionRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(FunctionServiceServer).DeleteVersion(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: FunctionService_DeleteVersion_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(FunctionServiceServer).DeleteVersion(ctx, req.(*DeleteFunctionVersionRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _FunctionService_SetTag_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(SetFunctionTagRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(FunctionServiceServer).SetTag(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: FunctionService_SetTag_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(FunctionServiceServer).SetTag(ctx, req.(*SetFunctionTagRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _FunctionService_RemoveTag_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(RemoveFunctionTagRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(FunctionServiceServer).RemoveTag(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: FunctionService_RemoveTag_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(FunctionServiceServer).RemoveTag(ctx, req.(*RemoveFunctionTagRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _FunctionService_ListTagHistory_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ListFunctionTagHistoryRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(FunctionServiceServer).ListTagHistory(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: FunctionService_ListTagHistory_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(FunctionServiceServer).ListTagHistory(ctx, req.(*ListFunctionTagHistoryRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _FunctionService_CreateVersion_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(CreateFunctionVersionRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(FunctionServiceServer).CreateVersion(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: FunctionService_CreateVersion_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(FunctionServiceServer).CreateVersion(ctx, req.(*CreateFunctionVersionRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _FunctionService_ListRuntimes_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ListRuntimesRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(FunctionServiceServer).ListRuntimes(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: FunctionService_ListRuntimes_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(FunctionServiceServer).ListRuntimes(ctx, req.(*ListRuntimesRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _FunctionService_ListOperations_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ListFunctionOperationsRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(FunctionServiceServer).ListOperations(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: FunctionService_ListOperations_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(FunctionServiceServer).ListOperations(ctx, req.(*ListFunctionOperationsRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _FunctionService_ListAccessBindings_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(access.ListAccessBindingsRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(FunctionServiceServer).ListAccessBindings(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: FunctionService_ListAccessBindings_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(FunctionServiceServer).ListAccessBindings(ctx, req.(*access.ListAccessBindingsRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _FunctionService_SetAccessBindings_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(access.SetAccessBindingsRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(FunctionServiceServer).SetAccessBindings(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: FunctionService_SetAccessBindings_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(FunctionServiceServer).SetAccessBindings(ctx, req.(*access.SetAccessBindingsRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _FunctionService_UpdateAccessBindings_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(access.UpdateAccessBindingsRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(FunctionServiceServer).UpdateAccessBindings(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: FunctionService_UpdateAccessBindings_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(FunctionServiceServer).UpdateAccessBindings(ctx, req.(*access.UpdateAccessBindingsRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _FunctionService_ListScalingPolicies_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ListScalingPoliciesRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(FunctionServiceServer).ListScalingPolicies(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: FunctionService_ListScalingPolicies_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(FunctionServiceServer).ListScalingPolicies(ctx, req.(*ListScalingPoliciesRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _FunctionService_SetScalingPolicy_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(SetScalingPolicyRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(FunctionServiceServer).SetScalingPolicy(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: FunctionService_SetScalingPolicy_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(FunctionServiceServer).SetScalingPolicy(ctx, req.(*SetScalingPolicyRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _FunctionService_RemoveScalingPolicy_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(RemoveScalingPolicyRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(FunctionServiceServer).RemoveScalingPolicy(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: FunctionService_RemoveScalingPolicy_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(FunctionServiceServer).RemoveScalingPolicy(ctx, req.(*RemoveScalingPolicyRequest))
	}
	return interceptor(ctx, in, info, handler)
}

// FunctionService_ServiceDesc is the grpc.ServiceDesc for FunctionService service.
// It's only intended for direct use with grpc.RegisterService,
// and not to be introspected or modified (even as a copy)
var FunctionService_ServiceDesc = grpc.ServiceDesc{
	ServiceName: "yandex.cloud.serverless.functions.v1.FunctionService",
	HandlerType: (*FunctionServiceServer)(nil),
	Methods: []grpc.MethodDesc{
		{
			MethodName: "Get",
			Handler:    _FunctionService_Get_Handler,
		},
		{
			MethodName: "List",
			Handler:    _FunctionService_List_Handler,
		},
		{
			MethodName: "Create",
			Handler:    _FunctionService_Create_Handler,
		},
		{
			MethodName: "Update",
			Handler:    _FunctionService_Update_Handler,
		},
		{
			MethodName: "Delete",
			Handler:    _FunctionService_Delete_Handler,
		},
		{
			MethodName: "GetVersion",
			Handler:    _FunctionService_GetVersion_Handler,
		},
		{
			MethodName: "GetVersionByTag",
			Handler:    _FunctionService_GetVersionByTag_Handler,
		},
		{
			MethodName: "ListVersions",
			Handler:    _FunctionService_ListVersions_Handler,
		},
		{
			MethodName: "DeleteVersion",
			Handler:    _FunctionService_DeleteVersion_Handler,
		},
		{
			MethodName: "SetTag",
			Handler:    _FunctionService_SetTag_Handler,
		},
		{
			MethodName: "RemoveTag",
			Handler:    _FunctionService_RemoveTag_Handler,
		},
		{
			MethodName: "ListTagHistory",
			Handler:    _FunctionService_ListTagHistory_Handler,
		},
		{
			MethodName: "CreateVersion",
			Handler:    _FunctionService_CreateVersion_Handler,
		},
		{
			MethodName: "ListRuntimes",
			Handler:    _FunctionService_ListRuntimes_Handler,
		},
		{
			MethodName: "ListOperations",
			Handler:    _FunctionService_ListOperations_Handler,
		},
		{
			MethodName: "ListAccessBindings",
			Handler:    _FunctionService_ListAccessBindings_Handler,
		},
		{
			MethodName: "SetAccessBindings",
			Handler:    _FunctionService_SetAccessBindings_Handler,
		},
		{
			MethodName: "UpdateAccessBindings",
			Handler:    _FunctionService_UpdateAccessBindings_Handler,
		},
		{
			MethodName: "ListScalingPolicies",
			Handler:    _FunctionService_ListScalingPolicies_Handler,
		},
		{
			MethodName: "SetScalingPolicy",
			Handler:    _FunctionService_SetScalingPolicy_Handler,
		},
		{
			MethodName: "RemoveScalingPolicy",
			Handler:    _FunctionService_RemoveScalingPolicy_Handler,
		},
	},
	Streams:  []grpc.StreamDesc{},
	Metadata: "yandex/cloud/serverless/functions/v1/function_service.proto",
}
