// Code generated by sdkgen. DO NOT EDIT.

// nolint
package billing

import (
	"context"

	"google.golang.org/grpc"

	billing "github.com/yandex-cloud/go-genproto/yandex/cloud/billing/v1"
)

//revive:disable

// ServiceServiceClient is a billing.ServiceServiceClient with
// lazy GRPC connection initialization.
type ServiceServiceClient struct {
	getConn func(ctx context.Context) (*grpc.ClientConn, error)
}

// Get implements billing.ServiceServiceClient
func (c *ServiceServiceClient) Get(ctx context.Context, in *billing.GetServiceRequest, opts ...grpc.CallOption) (*billing.Service, error) {
	conn, err := c.getConn(ctx)
	if err != nil {
		return nil, err
	}
	return billing.NewServiceServiceClient(conn).Get(ctx, in, opts...)
}

// List implements billing.ServiceServiceClient
func (c *ServiceServiceClient) List(ctx context.Context, in *billing.ListServicesRequest, opts ...grpc.CallOption) (*billing.ListServicesResponse, error) {
	conn, err := c.getConn(ctx)
	if err != nil {
		return nil, err
	}
	return billing.NewServiceServiceClient(conn).List(ctx, in, opts...)
}

type ServiceIterator struct {
	ctx  context.Context
	opts []grpc.CallOption

	err           error
	started       bool
	requestedSize int64
	pageSize      int64

	client  *ServiceServiceClient
	request *billing.ListServicesRequest

	items []*billing.Service
}

func (c *ServiceServiceClient) ServiceIterator(ctx context.Context, req *billing.ListServicesRequest, opts ...grpc.CallOption) *ServiceIterator {
	var pageSize int64
	const defaultPageSize = 1000
	pageSize = req.PageSize
	if pageSize == 0 {
		pageSize = defaultPageSize
	}
	return &ServiceIterator{
		ctx:      ctx,
		opts:     opts,
		client:   c,
		request:  req,
		pageSize: pageSize,
	}
}

func (it *ServiceIterator) Next() bool {
	if it.err != nil {
		return false
	}
	if len(it.items) > 1 {
		it.items[0] = nil
		it.items = it.items[1:]
		return true
	}
	it.items = nil // consume last item, if any

	if it.started && it.request.PageToken == "" {
		return false
	}
	it.started = true

	if it.requestedSize == 0 || it.requestedSize > it.pageSize {
		it.request.PageSize = it.pageSize
	} else {
		it.request.PageSize = it.requestedSize
	}

	response, err := it.client.List(it.ctx, it.request, it.opts...)
	it.err = err
	if err != nil {
		return false
	}

	it.items = response.Services
	it.request.PageToken = response.NextPageToken
	return len(it.items) > 0
}

func (it *ServiceIterator) Take(size int64) ([]*billing.Service, error) {
	if it.err != nil {
		return nil, it.err
	}

	if size == 0 {
		size = 1 << 32 // something insanely large
	}
	it.requestedSize = size
	defer func() {
		// reset iterator for future calls.
		it.requestedSize = 0
	}()

	var result []*billing.Service

	for it.requestedSize > 0 && it.Next() {
		it.requestedSize--
		result = append(result, it.Value())
	}

	if it.err != nil {
		return nil, it.err
	}

	return result, nil
}

func (it *ServiceIterator) TakeAll() ([]*billing.Service, error) {
	return it.Take(0)
}

func (it *ServiceIterator) Value() *billing.Service {
	if len(it.items) == 0 {
		panic("calling Value on empty iterator")
	}
	return it.items[0]
}

func (it *ServiceIterator) Error() error {
	return it.err
}
