// Code generated by sdkgen. DO NOT EDIT.

// nolint
package monitoring

import (
	"context"

	"google.golang.org/grpc"

	monitoring "github.com/yandex-cloud/go-genproto/yandex/cloud/monitoring/v3"
	"github.com/yandex-cloud/go-genproto/yandex/cloud/operation"
)

//revive:disable

// DashboardServiceClient is a monitoring.DashboardServiceClient with
// lazy GRPC connection initialization.
type DashboardServiceClient struct {
	getConn func(ctx context.Context) (*grpc.ClientConn, error)
}

// Create implements monitoring.DashboardServiceClient
func (c *DashboardServiceClient) Create(ctx context.Context, in *monitoring.CreateDashboardRequest, opts ...grpc.CallOption) (*operation.Operation, error) {
	conn, err := c.getConn(ctx)
	if err != nil {
		return nil, err
	}
	return monitoring.NewDashboardServiceClient(conn).Create(ctx, in, opts...)
}

// Delete implements monitoring.DashboardServiceClient
func (c *DashboardServiceClient) Delete(ctx context.Context, in *monitoring.DeleteDashboardRequest, opts ...grpc.CallOption) (*operation.Operation, error) {
	conn, err := c.getConn(ctx)
	if err != nil {
		return nil, err
	}
	return monitoring.NewDashboardServiceClient(conn).Delete(ctx, in, opts...)
}

// Get implements monitoring.DashboardServiceClient
func (c *DashboardServiceClient) Get(ctx context.Context, in *monitoring.GetDashboardRequest, opts ...grpc.CallOption) (*monitoring.Dashboard, error) {
	conn, err := c.getConn(ctx)
	if err != nil {
		return nil, err
	}
	return monitoring.NewDashboardServiceClient(conn).Get(ctx, in, opts...)
}

// List implements monitoring.DashboardServiceClient
func (c *DashboardServiceClient) List(ctx context.Context, in *monitoring.ListDashboardsRequest, opts ...grpc.CallOption) (*monitoring.ListDashboardsResponse, error) {
	conn, err := c.getConn(ctx)
	if err != nil {
		return nil, err
	}
	return monitoring.NewDashboardServiceClient(conn).List(ctx, in, opts...)
}

type DashboardIterator struct {
	ctx  context.Context
	opts []grpc.CallOption

	err           error
	started       bool
	requestedSize int64
	pageSize      int64

	client  *DashboardServiceClient
	request *monitoring.ListDashboardsRequest

	items []*monitoring.Dashboard
}

func (c *DashboardServiceClient) DashboardIterator(ctx context.Context, req *monitoring.ListDashboardsRequest, opts ...grpc.CallOption) *DashboardIterator {
	var pageSize int64
	const defaultPageSize = 1000
	pageSize = req.PageSize
	if pageSize == 0 {
		pageSize = defaultPageSize
	}
	return &DashboardIterator{
		ctx:      ctx,
		opts:     opts,
		client:   c,
		request:  req,
		pageSize: pageSize,
	}
}

func (it *DashboardIterator) Next() bool {
	if it.err != nil {
		return false
	}
	if len(it.items) > 1 {
		it.items[0] = nil
		it.items = it.items[1:]
		return true
	}
	it.items = nil // consume last item, if any

	if it.started && it.request.PageToken == "" {
		return false
	}
	it.started = true

	if it.requestedSize == 0 || it.requestedSize > it.pageSize {
		it.request.PageSize = it.pageSize
	} else {
		it.request.PageSize = it.requestedSize
	}

	response, err := it.client.List(it.ctx, it.request, it.opts...)
	it.err = err
	if err != nil {
		return false
	}

	it.items = response.Dashboards
	it.request.PageToken = response.NextPageToken
	return len(it.items) > 0
}

func (it *DashboardIterator) Take(size int64) ([]*monitoring.Dashboard, error) {
	if it.err != nil {
		return nil, it.err
	}

	if size == 0 {
		size = 1 << 32 // something insanely large
	}
	it.requestedSize = size
	defer func() {
		// reset iterator for future calls.
		it.requestedSize = 0
	}()

	var result []*monitoring.Dashboard

	for it.requestedSize > 0 && it.Next() {
		it.requestedSize--
		result = append(result, it.Value())
	}

	if it.err != nil {
		return nil, it.err
	}

	return result, nil
}

func (it *DashboardIterator) TakeAll() ([]*monitoring.Dashboard, error) {
	return it.Take(0)
}

func (it *DashboardIterator) Value() *monitoring.Dashboard {
	if len(it.items) == 0 {
		panic("calling Value on empty iterator")
	}
	return it.items[0]
}

func (it *DashboardIterator) Error() error {
	return it.err
}

// ListOperations implements monitoring.DashboardServiceClient
func (c *DashboardServiceClient) ListOperations(ctx context.Context, in *monitoring.ListDashboardOperationsRequest, opts ...grpc.CallOption) (*monitoring.ListDashboardOperationsResponse, error) {
	conn, err := c.getConn(ctx)
	if err != nil {
		return nil, err
	}
	return monitoring.NewDashboardServiceClient(conn).ListOperations(ctx, in, opts...)
}

type DashboardOperationsIterator struct {
	ctx  context.Context
	opts []grpc.CallOption

	err           error
	started       bool
	requestedSize int64
	pageSize      int64

	client  *DashboardServiceClient
	request *monitoring.ListDashboardOperationsRequest

	items []*operation.Operation
}

func (c *DashboardServiceClient) DashboardOperationsIterator(ctx context.Context, req *monitoring.ListDashboardOperationsRequest, opts ...grpc.CallOption) *DashboardOperationsIterator {
	var pageSize int64
	const defaultPageSize = 1000
	pageSize = req.PageSize
	if pageSize == 0 {
		pageSize = defaultPageSize
	}
	return &DashboardOperationsIterator{
		ctx:      ctx,
		opts:     opts,
		client:   c,
		request:  req,
		pageSize: pageSize,
	}
}

func (it *DashboardOperationsIterator) Next() bool {
	if it.err != nil {
		return false
	}
	if len(it.items) > 1 {
		it.items[0] = nil
		it.items = it.items[1:]
		return true
	}
	it.items = nil // consume last item, if any

	if it.started && it.request.PageToken == "" {
		return false
	}
	it.started = true

	if it.requestedSize == 0 || it.requestedSize > it.pageSize {
		it.request.PageSize = it.pageSize
	} else {
		it.request.PageSize = it.requestedSize
	}

	response, err := it.client.ListOperations(it.ctx, it.request, it.opts...)
	it.err = err
	if err != nil {
		return false
	}

	it.items = response.Operations
	it.request.PageToken = response.NextPageToken
	return len(it.items) > 0
}

func (it *DashboardOperationsIterator) Take(size int64) ([]*operation.Operation, error) {
	if it.err != nil {
		return nil, it.err
	}

	if size == 0 {
		size = 1 << 32 // something insanely large
	}
	it.requestedSize = size
	defer func() {
		// reset iterator for future calls.
		it.requestedSize = 0
	}()

	var result []*operation.Operation

	for it.requestedSize > 0 && it.Next() {
		it.requestedSize--
		result = append(result, it.Value())
	}

	if it.err != nil {
		return nil, it.err
	}

	return result, nil
}

func (it *DashboardOperationsIterator) TakeAll() ([]*operation.Operation, error) {
	return it.Take(0)
}

func (it *DashboardOperationsIterator) Value() *operation.Operation {
	if len(it.items) == 0 {
		panic("calling Value on empty iterator")
	}
	return it.items[0]
}

func (it *DashboardOperationsIterator) Error() error {
	return it.err
}

// Update implements monitoring.DashboardServiceClient
func (c *DashboardServiceClient) Update(ctx context.Context, in *monitoring.UpdateDashboardRequest, opts ...grpc.CallOption) (*operation.Operation, error) {
	conn, err := c.getConn(ctx)
	if err != nil {
		return nil, err
	}
	return monitoring.NewDashboardServiceClient(conn).Update(ctx, in, opts...)
}
