import events from "node:events";
import { type ApsDataRequest, type ParameterT, type ReceivedDataResponse, type Request } from "./constants";
export declare const busyQueue: Array<Request>;
export declare const apsBusyQueue: Array<Request>;
export declare let readyToSend: boolean;
export declare function enableRTS(): void;
export declare function disableRTS(): void;
export declare let enableRtsTimeout: NodeJS.Timeout | undefined;
declare class Driver extends events.EventEmitter {
    private path;
    private serialPort?;
    private initialized;
    private writer;
    private parser;
    private frameParserEvent;
    private seqNumber;
    private timeoutResetTimeout?;
    private apsRequestFreeSlots;
    private apsDataConfirm;
    private apsDataIndication;
    private configChanged;
    private socketPort?;
    private delay;
    private readyToSendTimeout;
    private handleDeviceStatusDelay;
    private processQueues;
    private timeoutCounter;
    private currentBaudRate;
    constructor(path: string);
    protected intervals: NodeJS.Timeout[];
    protected registerInterval(interval: NodeJS.Timeout): void;
    protected catchPromise<T>(val: Promise<T>): Promise<undefined | Awaited<T>>;
    setDelay(delay: number): void;
    private onPortClose;
    open(baudrate: number): Promise<void>;
    openSerialPort(baudrate: number): Promise<void>;
    private openSocketPort;
    close(): Promise<void>;
    readParameterRequest(parameterId: number): Promise<unknown>;
    writeParameterRequest(parameterId: number, parameter: ParameterT): Promise<void>;
    writeLinkKey(ieeeAddress: string, hashedKey: Buffer): Promise<void>;
    readFirmwareVersionRequest(): Promise<number[]>;
    private sendReadParameterRequest;
    private sendWriteParameterRequest;
    private getLengthOfParameter;
    private parameterBuffer;
    private sendReadFirmwareVersionRequest;
    private sendReadDeviceStateRequest;
    private sendRequest;
    private processQueue;
    private processBusyQueue;
    changeNetworkStateRequest(networkState: number): Promise<void>;
    private sendChangeNetworkStateRequest;
    private deviceStateRequest;
    private checkDeviceStatus;
    private handleDeviceStatus;
    private readReceivedDataRequest;
    enqueueSendDataRequest(request: ApsDataRequest): Promise<undefined | ReceivedDataResponse>;
    private querySendDataStateRequest;
    private processApsQueue;
    private processApsConfirmIndQueue;
    private sendQueryDataStateRequest;
    private sendReadReceivedDataRequest;
    private sendEnqueueSendDataRequest;
    private processApsBusyQueue;
    private calcCrc;
    macAddrStringToArray(addr: string): Array<number>;
    macAddrArrayToString(addr: Array<number>): string;
    /**
     *  generalArrayToString result is not reversed!
     */
    generalArrayToString(key: Array<number>, length: number): string;
    private nextSeqNumber;
    private onParsed;
    private sleep;
    private resetTimeoutCounterAfter1min;
}
export default Driver;
//# sourceMappingURL=driver.d.ts.map