import type { GenericZdoResponse } from "../../../zspec/zdo/definition/tstypes";
interface Request {
    commandId: number;
    networkState?: number;
    parameterId?: number;
    parameter?: ParameterT;
    request?: ApsDataRequest;
    seqNumber: number;
    resolve: (value: any) => void;
    reject: (value: Error) => void;
    ts?: number;
}
interface WaitForDataRequest {
    addr: number | string;
    profileId: number;
    clusterId: number;
    transactionSequenceNumber?: number;
    resolve: (value: ReceivedDataResponse | PromiseLike<ReceivedDataResponse>) => void;
    reject: (value: Error) => void;
    ts?: number;
    timeout?: number;
}
interface ReceivedDataResponse {
    commandId: number;
    seqNr: number;
    status: number;
    frameLength: number;
    payloadLength: number;
    deviceState: number;
    destAddrMode: number;
    destAddr16?: number;
    destAddr64?: string;
    destEndpoint: number;
    srcAddrMode: number;
    srcAddr16?: number;
    srcAddr64?: string;
    srcEndpoint: number;
    profileId: number;
    clusterId: number;
    asduLength: number;
    asduPayload: Buffer;
    lqi: number;
    rssi: number;
    zdo?: GenericZdoResponse;
}
interface GpDataInd {
    rspId: number;
    seqNr: number;
    id: number;
    options: number;
    srcId: number;
    frameCounter: number;
    commandId: number;
    commandFrameSize: number;
    commandFrame: Buffer;
}
interface DataStateResponse {
    commandId: number;
    seqNr: number;
    status: number;
    frameLength: number;
    payloadLength: number;
    deviceState: number;
    requestId: number;
    destAddrMode: number;
    destAddr16?: number;
    destAddr64?: string;
    destEndpoint?: number;
    srcEndpoint: number;
    confirmStatus: number;
}
interface ApsDataRequest {
    requestId: number;
    destAddrMode: number;
    destAddr16?: number;
    destAddr64?: string;
    destEndpoint?: number;
    profileId: number;
    clusterId: number;
    srcEndpoint: number;
    asduLength: number;
    asduPayload: Buffer;
    txOptions: number;
    radius: number;
    timeout?: number;
}
type ParamMac = string;
type ParamPanId = number;
type ParamExtPanId = string;
type ParamNwkAddr = number;
type ParamChannel = number;
type ParamChannelMask = number;
type ParamPermitJoin = number;
type ParamNetworkKey = string;
type Command = ParamMac | ParamPanId | ParamNwkAddr | ParamExtPanId | ParamChannel | ParamChannelMask | ParamPermitJoin | ParamNetworkKey;
type ParameterT = number | number[];
export type { Request, WaitForDataRequest, ApsDataRequest, ReceivedDataResponse, DataStateResponse, ParameterT, Command, ParamMac, ParamPanId, ParamNwkAddr, ParamExtPanId, ParamChannel, ParamChannelMask, ParamPermitJoin, ParamNetworkKey, GpDataInd, };
declare const _default: {
    PARAM: {
        Network: {
            NET_OFFLINE: number;
            NET_JOINING: number;
            NET_CONNECTED: number;
            NET_LEAVING: number;
            MAC: number;
            PAN_ID: number;
            NWK_ADDRESS: number;
            EXT_PAN_ID: number;
            CHANNEL_MASK: number;
            APS_EXT_PAN_ID: number;
            NETWORK_KEY: number;
            LINK_KEY: number;
            CHANNEL: number;
            PERMIT_JOIN: number;
            WATCHDOG_TTL: number;
        };
        STK: {
            Endpoint: number;
        };
        FrameType: {
            ReadDeviceState: number;
            ReadParameter: number;
            WriteParameter: number;
            ReadFirmwareVersion: number;
            DeviceStateChanged: number;
            GreenPowerDataInd: number;
        };
        APS: {
            DATA_CONFIRM: number;
            DATA_REQUEST: number;
            DATA_INDICATION: number;
        };
        NetworkState: {
            NET_OFFLINE: number;
            NET_JOINING: number;
            NET_CONNECTED: number;
            NET_LEAVING: number;
            CHANGE_NETWORK_STATE: number;
        };
        addressMode: {
            GROUP_ADDR: number;
            NWK_ADDR: number;
            IEEE_ADDR: number;
        };
        txRadius: {
            DEFAULT_RADIUS: number;
            UNLIMITED: number;
        };
    };
};
export default _default;
//# sourceMappingURL=constants.d.ts.map